/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamLogConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamLogConfigurator.class);

    public static void configure(InputStream is) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            String[] names;
            for (String name : names = new String[]{"ch.qos.logback.classic.LoggerContext", "ch.qos.logback.classic.joran.JoranConfigurator"}) {
                Class.forName(name, false, cl);
            }
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(is);
        }
        catch (ClassNotFoundException e) {
            System.err.println("WLogC: Logback JARs are missing in classpath");
        }
        catch (NoClassDefFoundError e) {
            System.err.println("WLogC: Logback JARs are missing in classpath");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void configure(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            WebcamLogConfigurator.configure(fis);
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found " + file, e);
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error("Cannot close file " + file, e);
                    e.printStackTrace();
                }
            }
        }
    }

    public static void configure(String file) {
        WebcamLogConfigurator.configure(new File(file));
    }
}

