/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.DataBuffer;
import fm.icelink.MacContextBase;
import fm.icelink.MacType;
import fm.icelink.stun.Attribute;

public class MessageIntegrityAttribute
extends Attribute {
    private byte[] _keyBuffer;
    private DataBuffer _messageBuffer;
    private DataBuffer _valueBuffer;

    public DataBuffer getMessageBuffer() {
        return this._messageBuffer;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getMessageIntegrityType();
    }

    @Override
    protected int getValueLength() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(byte[] keyBuffer) {
        boolean flag;
        if (this.getMessageBuffer() == null) {
            throw new RuntimeException(new Exception("Message buffer must be set before writing message-integrity attribute."));
        }
        int offset = 2;
        int num2 = this.getMessageBuffer().read16(offset);
        try {
            this.getMessageBuffer().write16(this.getMessageBuffer().getLength() - 20 + super.getLength(), offset);
            flag = this._valueBuffer != null && this._valueBuffer.sequenceEquals(MacContextBase.compute(MacType.HmacSha1, DataBuffer.wrap(keyBuffer), this.getMessageBuffer()));
        }
        finally {
            this.getMessageBuffer().write16(num2, offset);
        }
        return flag;
    }

    public MessageIntegrityAttribute(byte[] keyBuffer) {
        this._keyBuffer = keyBuffer;
    }

    private MessageIntegrityAttribute() {
    }

    public static MessageIntegrityAttribute readValueFrom(DataBuffer buffer, int offset, int length, DataBuffer messageBuffer) {
        MessageIntegrityAttribute attribute = new MessageIntegrityAttribute();
        attribute._valueBuffer = buffer.subset(offset, length);
        attribute.setMessageBuffer(messageBuffer);
        return attribute;
    }

    public void setMessageBuffer(DataBuffer value) {
        this._messageBuffer = value;
    }

    public String toString() {
        return "MESSAGE-INTEGRITY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        if (this._keyBuffer == null) {
            throw new RuntimeException(new Exception("Key buffer must be set before writing message-integrity attribute."));
        }
        if (this.getMessageBuffer() == null) {
            throw new RuntimeException(new Exception("Message buffer must be set before writing message-integrity attribute."));
        }
        int num = 2;
        int num2 = this.getMessageBuffer().read16(num);
        try {
            this.getMessageBuffer().write16(this.getMessageBuffer().getLength() - 20 + super.getLength(), num);
            buffer.write(MacContextBase.compute(MacType.HmacSha1, DataBuffer.wrap(this._keyBuffer), this.getMessageBuffer()), offset);
        }
        finally {
            this.getMessageBuffer().write16(num2, num);
        }
    }
}

