/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.Error;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaTrackStats;
import fm.icelink.PliControlFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.sdp.MediaDescription;

public abstract class VideoEncoder
extends VideoPipe {
    private AtomicLong __framesEncoded = new AtomicLong();
    private int _frameHeight;
    private long _frameRateStartTicks = -1L;
    private int _frameWidth;

    @Override
    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        for (MediaControlFrame frame : controlFrames) {
            if (!(frame instanceof PliControlFrame)) continue;
            this.setForceKeyFrame(true);
        }
    }

    @Override
    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription) {
            mediaDescription.insertNackPliAttribute(((VideoFormat)super.getOutputFormat()).getName(), ((VideoFormat)super.getOutputFormat()).getClockRate(), ((VideoFormat)super.getOutputFormat()).getParameters());
        }
        return null;
    }

    @Override
    protected void doProcessStatsFromOutput(MediaTrackStats stats) {
        super.doProcessStatsFromOutput(stats);
        stats.setFrameWidth(this.getFrameWidth());
        stats.setFrameHeight(this.getFrameHeight());
        stats.setFrameRate(this.getFrameRate());
        stats.setFramesEncoded(this.getFramesEncoded());
    }

    public abstract boolean getForceKeyFrame();

    public int getFrameHeight() {
        return this._frameHeight;
    }

    public int getFrameRate() {
        long framesEncoded = this.getFramesEncoded();
        if (framesEncoded == 0L) {
            return -1;
        }
        long num2 = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this._frameRateStartTicks;
        if (num2 < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(framesEncoded * (long)Constants.getTicksPerSecond() / num2);
    }

    public long getFramesEncoded() {
        return this.__framesEncoded.getValue();
    }

    public int getFrameWidth() {
        return this._frameWidth;
    }

    @Override
    public int getMaxInputBitrate() {
        return -1;
    }

    @Override
    public boolean processFrame(VideoFrame frame) {
        VideoBuffer lastBuffer = (VideoBuffer)frame.getLastBuffer();
        if (lastBuffer != null) {
            if (this._frameRateStartTicks == -1L) {
                this._frameRateStartTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            }
            this.setFrameWidth(lastBuffer.getWidth());
            this.setFrameHeight(lastBuffer.getHeight());
        }
        return super.processFrame(frame);
    }

    @Override
    protected void raiseFrame(VideoFrame frame) {
        this.__framesEncoded.increment();
        super.raiseFrame(frame);
    }

    public abstract void setForceKeyFrame(boolean var1);

    private void setFrameHeight(int value) {
        this._frameHeight = value;
    }

    private void setFrameWidth(int value) {
        this._frameWidth = value;
    }

    public VideoEncoder(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
    }
}

