/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpErrorCause;
import java.util.ArrayList;

class SctpErrorChunk
extends SctpControlChunk {
    private SctpErrorCause[] _errorCauses;

    @Override
    public byte[] getBytes() {
        return SctpErrorChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpErrorChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        for (int i = 0; i < ArrayExtensions.getLength(chunk.getErrorCauses()); ++i) {
            bytes.addRange(chunk.getErrorCauses()[i].getBytes());
        }
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        return bytes.toArray();
    }

    public SctpErrorCause[] getErrorCauses() {
        return this._errorCauses;
    }

    public static SctpErrorChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex;
            int num = Binary.fromBytes16(bytes, 2, false);
            ArrayList<SctpErrorCause> list = new ArrayList<SctpErrorCause>();
            for (startIndex = 4; startIndex < num; startIndex += offsetPlus.getValue()) {
                SctpErrorCause _var0 = SctpErrorCause.parseBytes(bytes, startIndex, offsetPlus);
                SctpErrorCause item = _var0;
                if (item == null) {
                    offsetPlus.setValue(0);
                    return null;
                }
                list.add(item);
            }
            offsetPlus.setValue(startIndex);
            return new SctpErrorChunk(list.toArray(new SctpErrorCause[0]));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            Log.warn("Could not parse SCTP Error chunk");
            return null;
        }
    }

    public SctpErrorChunk(SctpErrorCause[] errorCauses) {
        super.setCanBundleWithDataAndSackChunks(false);
        super.setType(SctpChunkType.getError());
        this.setErrorCauses(errorCauses);
        super.setUnrecognized(false);
    }

    public void setErrorCauses(SctpErrorCause[] value) {
        this._errorCauses = value;
    }
}

