/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.LinkedList;
import fm.icelink.LinkedListNode;
import fm.icelink.LongExtensions;
import fm.icelink.SctpDataChunk;
import java.util.HashMap;

class SctpDataQueue {
    private Object __lock = new Object();
    private HashMap<String, LinkedListNode<SctpDataChunk>> __tsnDataDictionary = new HashMap();
    private LinkedList<SctpDataChunk> __tsnDataLinkedList = new LinkedList();
    private long _allAckedUpTo;
    private long _notAckedPast;
    public static long _unset = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SctpDataChunk dataChunk) {
        Object object = this.__lock;
        synchronized (object) {
            boolean flag = false;
            LinkedListNode<SctpDataChunk> last = this.__tsnDataLinkedList.getLast();
            LinkedListNode<SctpDataChunk> node2 = null;
            if (last == null) {
                node2 = this.__tsnDataLinkedList.addFirst(dataChunk);
            } else {
                while (!flag) {
                    if (SctpDataChunk.compareTsns(last.getValue().getTsn(), dataChunk.getTsn()) > 1) {
                        node2 = this.__tsnDataLinkedList.addAfterNode(last, dataChunk);
                        flag = true;
                        continue;
                    }
                    if (last.getPrevious() != null) {
                        last = last.getPrevious();
                        continue;
                    }
                    node2 = this.__tsnDataLinkedList.addFirst(dataChunk);
                    flag = true;
                }
            }
            if (this.getNotAckedPast() == -1L) {
                this.setNotAckedPast(dataChunk.getTsn());
            }
            HashMapExtensions.add(this.__tsnDataDictionary, LongExtensions.toString(dataChunk.getTsn()), node2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chunkExists(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            return this.__tsnDataDictionary.containsKey(LongExtensions.toString(tsn));
        }
    }

    public long getAllAckedUpTo() {
        return this._allAckedUpTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpDataChunk getChunk(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            if (this.chunkExists(tsn)) {
                return HashMapExtensions.getItem(this.__tsnDataDictionary).get(LongExtensions.toString(tsn)).getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = this.__lock;
        synchronized (object) {
            return HashMapExtensions.getCount(this.__tsnDataDictionary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEarliestTSN() {
        Object object = this.__lock;
        synchronized (object) {
            return this.__tsnDataLinkedList.getFirst() == null ? -1L : this.__tsnDataLinkedList.getFirst().getValue().getTsn();
        }
    }

    public SctpDataChunk getFirstUnAcked() {
        return this.getNextChunk(this.getAllAckedUpTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpDataChunk getNextChunk(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            if (this.chunkExists(tsn)) {
                LinkedListNode<SctpDataChunk> next = HashMapExtensions.getItem(this.__tsnDataDictionary).get(LongExtensions.toString(tsn)).getNext();
                SctpDataChunk sctpDataChunk = next == null ? null : next.getValue();
                return sctpDataChunk;
            }
            for (LinkedListNode<SctpDataChunk> node2 = this.__tsnDataLinkedList.getFirst(); node2 != null; node2 = node2.getNext()) {
                if (SctpDataChunk.compareTsns(node2.getValue().getTsn(), tsn) == 1) {
                    return node2.getValue();
                }
                if (SctpDataChunk.compareTsns(node2.getValue().getTsn(), tsn) != 0) continue;
                return node2.getNext() == null ? null : node2.getNext().getValue();
            }
            return null;
        }
    }

    public long getNotAckedPast() {
        return this._notAckedPast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpDataChunk getPreviousChunk(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            if (this.chunkExists(tsn)) {
                LinkedListNode<SctpDataChunk> previous = HashMapExtensions.getItem(this.__tsnDataDictionary).get(LongExtensions.toString(tsn)).getPrevious();
                SctpDataChunk sctpDataChunk = previous == null ? null : previous.getValue();
                return sctpDataChunk;
            }
            for (LinkedListNode<SctpDataChunk> node2 = this.__tsnDataLinkedList.getLast(); node2 != null && node2.getValue() != null; node2 = node2.getPrevious()) {
                if (SctpDataChunk.compareTsns(node2.getValue().getTsn(), tsn) == 2) {
                    return node2.getValue();
                }
                if (SctpDataChunk.compareTsns(node2.getValue().getTsn(), tsn) != 0) continue;
                return node2.getPrevious() == null || node2.getPrevious().getValue() == null ? null : node2.getPrevious().getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getTsns() {
        Object object = this.__lock;
        synchronized (object) {
            long[] numArray = new long[HashMapExtensions.getCount(this.__tsnDataDictionary)];
            int index = 0;
            LinkedListNode<SctpDataChunk> first = this.__tsnDataLinkedList.getFirst();
            while (first != null) {
                numArray[index] = first.getValue().getTsn();
                first = first.getNext();
                ++index;
            }
            return numArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            LinkedListNode<SctpDataChunk> first = this.__tsnDataLinkedList.getFirst();
            boolean flag = false;
            while (first != null && !flag) {
                if (SctpDataChunk.compareTsns(tsn, first.getValue().getTsn()) < 2) {
                    HashMapExtensions.remove(this.__tsnDataDictionary, LongExtensions.toString(first.getValue().getTsn()));
                    this.__tsnDataLinkedList.remove(first.getValue());
                    first = this.__tsnDataLinkedList.getFirst();
                    if (first != null) continue;
                    this.setAllAckedUpTo(-1L);
                    this.setNotAckedPast(-1L);
                    continue;
                }
                if (SctpDataChunk.compareTsns(first.getValue().getTsn(), this.getAllAckedUpTo()) < 2) {
                    this.setAllAckedUpTo(-1L);
                }
                if (SctpDataChunk.compareTsns(first.getValue().getTsn(), this.getNotAckedPast()) < 2) {
                    this.setNotAckedPast(first.getValue().getTsn());
                }
                flag = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            if (this.getChunk(tsn) != null) {
                LinkedListNode node = null;
                Holder<Object> _var0 = new Holder<Object>(node);
                boolean _var1 = HashMapExtensions.tryGetValue(this.__tsnDataDictionary, LongExtensions.toString(tsn), _var0);
                node = _var0.getValue();
                boolean flag = HashMapExtensions.remove(this.__tsnDataDictionary, LongExtensions.toString(tsn));
                this.__tsnDataLinkedList.removeNode(node);
                if (this.__tsnDataLinkedList.getCount() == 0) {
                    this.setNotAckedPast(-1L);
                    this.setAllAckedUpTo(-1L);
                }
                return flag;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.__lock;
        synchronized (object) {
            this.setAllAckedUpTo(-1L);
            this.setNotAckedPast(-1L);
            this.__tsnDataDictionary.clear();
            this.__tsnDataLinkedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpDataQueue() {
        Object object = this.__lock;
        synchronized (object) {
            this.setAllAckedUpTo(-1L);
            this.setNotAckedPast(-1L);
        }
    }

    public void setAllAckedUpTo(long value) {
        this._allAckedUpTo = value;
    }

    public void setNotAckedPast(long value) {
        this._notAckedPast = value;
    }
}

