/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.Binary;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.DtlsFingerprint;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashContextBase;
import fm.icelink.HashType;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.RsaCrypto;
import fm.icelink.RsaKey;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.X501Attribute;
import fm.icelink.X501AttributeType;
import fm.icelink.X501DirectoryString;
import fm.icelink.X501Name;
import fm.icelink.X501RelativeDistinguishedName;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509Certificate;
import fm.icelink.X509RsaPublicKey;
import fm.icelink.X509SubjectPublicKeyInfo;
import fm.icelink.X509TbsCertificate;
import fm.icelink.X509Time;
import fm.icelink.X509TimeType;
import fm.icelink.X509Validity;
import java.util.Date;

public class DtlsCertificate {
    private Asn1Sequence __asn1;
    private boolean __autoRegenerate = true;
    private DataBuffer __buffer;
    private Date __effectiveDate = new Date();
    private Date __expirationDate = new Date();
    private String __issuerName;
    private RsaKey __key;
    private DataBuffer __md5Fingerprint;
    private byte[] __serialNumber;
    private DataBuffer __sha1Fingerprint;
    private DataBuffer __sha256Fingerprint;
    private X509AlgorithmIdentifier __signatureAlgorithm;
    private String __subjectName;
    private X509Certificate __x509;
    private String _id;

    public DtlsFingerprint calculateFingerprint(String algorithm) {
        byte[] bytes = this.getBytes();
        DataBuffer buffer2 = null;
        if (Global.equals(algorithm, DtlsFingerprint.getSha256Algorithm())) {
            if (this.__sha256Fingerprint == null) {
                this.__sha256Fingerprint = HashContextBase.compute(HashType.Sha256, DataBuffer.wrap(bytes));
            }
            buffer2 = this.__sha256Fingerprint;
        } else if (Global.equals(algorithm, DtlsFingerprint.getSha1Algorithm())) {
            if (this.__sha1Fingerprint == null) {
                this.__sha1Fingerprint = HashContextBase.compute(HashType.Sha1, DataBuffer.wrap(bytes));
            }
            buffer2 = this.__sha1Fingerprint;
        } else if (Global.equals(algorithm, DtlsFingerprint.getMd5Algorithm())) {
            if (this.__md5Fingerprint == null) {
                this.__md5Fingerprint = HashContextBase.compute(HashType.Md5, DataBuffer.wrap(bytes));
            }
            buffer2 = this.__md5Fingerprint;
        } else {
            Log.error(StringExtensions.format("Unsupported fingerprint algorithm: {0}.", algorithm));
            return null;
        }
        String str = buffer2.toHexString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < StringExtensions.getLength(str); i += 2) {
            if (i > 0) {
                StringBuilderExtensions.append(builder, ":");
            }
            StringBuilderExtensions.append(builder, StringExtensions.toUpper(StringExtensions.substring(str, i, 2)));
        }
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("Calculated DTLS certificate fingerprint {0} for algorithm {1}.", builder.toString(), algorithm));
        }
        return new DtlsFingerprint(algorithm, builder.toString());
    }

    public DtlsCertificate clone() {
        DtlsCertificate certificate = new DtlsCertificate();
        certificate.__issuerName = this.getIssuerName();
        certificate.__subjectName = this.getSubjectName();
        certificate.__effectiveDate = this.getEffectiveDate();
        certificate.__expirationDate = this.getExpirationDate();
        certificate.__serialNumber = this.getSerialNumber();
        certificate.__signatureAlgorithm = this.getSignatureAlgorithm();
        certificate.__key = this.getKey();
        certificate.__buffer = this.__buffer;
        certificate.__asn1 = this.__asn1;
        certificate.__x509 = this.__x509;
        certificate.__sha1Fingerprint = this.__sha1Fingerprint;
        certificate.__sha256Fingerprint = this.__sha256Fingerprint;
        return certificate;
    }

    public DtlsCertificate() {
        this.setId(Guid.newGuid().toString().replace("-", ""));
    }

    static DtlsCertificate fromAsn1(Asn1Any any) {
        X509Certificate certificate = X509Certificate.fromAsn1(any);
        if (certificate == null) {
            return null;
        }
        return DtlsCertificate.fromX509(certificate);
    }

    static DtlsCertificate fromX509(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        byte[] signature = x509Certificate.getSignature();
        X509TbsCertificate tbsCertificate = x509Certificate.getTbsCertificate();
        if (tbsCertificate == null) {
            return null;
        }
        if (!X509AlgorithmIdentifier.areEqual(x509Certificate.getSignatureAlgorithm(), tbsCertificate.getSignatureAlgorithm())) {
            return null;
        }
        boolean flag = X509AlgorithmIdentifier.algorithmsAreEqual(x509Certificate.getSignatureAlgorithm(), X509AlgorithmIdentifier.getSha1WithRsaEncryption());
        boolean flag2 = X509AlgorithmIdentifier.algorithmsAreEqual(x509Certificate.getSignatureAlgorithm(), X509AlgorithmIdentifier.getSha256WithRsaEncryption());
        if (!flag && !flag2) {
            throw new RuntimeException(new Exception("Signature algorithm is not supported."));
        }
        RsaKey publicKey = null;
        if (signature != null) {
            X509SubjectPublicKeyInfo subjectPublicKeyInfo = tbsCertificate.getSubjectPublicKeyInfo();
            if (subjectPublicKeyInfo == null || subjectPublicKeyInfo.getSubjectPublicKey() == null) {
                return null;
            }
            X509RsaPublicKey key2 = X509RsaPublicKey.fromAsn1(Asn1Any.parseBytes(subjectPublicKeyInfo.getSubjectPublicKey()));
            if (key2 == null) {
                return null;
            }
            RsaKey key3 = new RsaKey();
            key3.setModulus(key2.getModulus());
            key3.setPublicExponent(key2.getExponent());
            publicKey = key3;
            if (tbsCertificate.getSourceAsn() == null) {
                if (flag ? !RsaCrypto.verifyRsaSha1(tbsCertificate.toAsn1().getBytes(), signature, publicKey) : flag2 && !RsaCrypto.verifyRsaSha256(tbsCertificate.toAsn1().getBytes(), signature, publicKey)) {
                    // empty if block
                }
            } else {
                DataBuffer buffer;
                DataBuffer sourceData = tbsCertificate.getSourceAsn().getSourceData();
                if (sourceData.sequenceEquals(buffer = tbsCertificate.toAsn1().getBuffer())) {
                    Log.warn(StringExtensions.format("Certificate ASN.1 input does not match certificate ASN.1 output.\nINPUT: {0}\nOUTPUT: {1}", sourceData.toHexString(), buffer.toHexString()));
                }
                if (flag ? !RsaCrypto.verifyRsaSha1(sourceData.toArray(), signature, publicKey) : !flag2 || !RsaCrypto.verifyRsaSha256(sourceData.toArray(), signature, publicKey)) {
                    // empty if block
                }
            }
        }
        if (tbsCertificate.getValidity() == null) {
            return null;
        }
        DtlsCertificate certificate2 = new DtlsCertificate();
        certificate2.__signatureAlgorithm = x509Certificate.getSignatureAlgorithm();
        certificate2.__serialNumber = tbsCertificate.getSerialNumber();
        certificate2.__effectiveDate = tbsCertificate.getValidity().getNotBefore().getValue();
        certificate2.__expirationDate = tbsCertificate.getValidity().getNotAfter().getValue();
        certificate2.__issuerName = DtlsCertificate.getCommonName(tbsCertificate.getIssuer());
        certificate2.__subjectName = DtlsCertificate.getCommonName(tbsCertificate.getSubject());
        certificate2.__key = publicKey;
        return certificate2;
    }

    public static DtlsCertificate generateCertificate() {
        return DtlsCertificate.generateCertificate("IceLink");
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate, RsaKey key) {
        Date utcNow = DateExtensions.getUtcNow();
        if (key == null) {
            throw new RuntimeException(new Exception("Key cannot be null."));
        }
        if (!key.hasPublic()) {
            throw new RuntimeException(new Exception("Key is missing public details."));
        }
        if (!key.hasPrivate()) {
            throw new RuntimeException(new Exception("Key is missing private details."));
        }
        DtlsCertificate certificate = new DtlsCertificate();
        certificate.__issuerName = issuerName != null ? issuerName : "IceLink";
        certificate.__subjectName = subjectName != null ? subjectName : "IceLink";
        certificate.__effectiveDate = DateExtensions.addSeconds(utcNow, -864000.0);
        certificate.__expirationDate = expirationDate;
        certificate.__serialNumber = Binary.toBytes32(LockedRandomizer.next(), false);
        certificate.__signatureAlgorithm = X509AlgorithmIdentifier.getSha1WithRsaEncryption();
        certificate.__key = key;
        return certificate;
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate) {
        return DtlsCertificate.generateCertificate(issuerName, subjectName, expirationDate, RsaCrypto.createRsaKey());
    }

    public static DtlsCertificate generateCertificate(String issuerName, String subjectName) {
        Date expirationDate = DateExtensions.addSeconds(DateExtensions.getUtcNow(), 864000.0);
        return DtlsCertificate.generateCertificate(issuerName, subjectName, expirationDate);
    }

    public static DtlsCertificate generateCertificate(String name) {
        return DtlsCertificate.generateCertificate(name, name);
    }

    public static DtlsCertificate generateCertificateFromOldCertificate(DtlsCertificate oldCertificate) {
        return DtlsCertificate.generateCertificate(oldCertificate.getIssuerName(), oldCertificate.getSubjectName());
    }

    public static DtlsCertificate generateCertificateFromOldCertificate(DtlsCertificate oldCertificate, Date expirationDate) {
        return DtlsCertificate.generateCertificate(oldCertificate.getIssuerName(), oldCertificate.getSubjectName(), expirationDate);
    }

    public boolean getAutoRegenerate() {
        return this.__autoRegenerate;
    }

    public DataBuffer getBuffer() {
        Asn1Sequence sequence;
        if (this.__buffer == null && (sequence = this.toAsn1()) != null) {
            this.__buffer = sequence.getBuffer();
        }
        return this.__buffer;
    }

    public byte[] getBytes() {
        return this.getBuffer().toArray();
    }

    private static String getCommonName(X501Name name) {
        if (name == null) {
            return null;
        }
        X501Attribute attribute = name.getAttribute(X501AttributeType.getCommonName());
        if (attribute == null) {
            return null;
        }
        return attribute.attributeValueAsString();
    }

    public Date getEffectiveDate() {
        return this.__effectiveDate;
    }

    public Date getExpirationDate() {
        return this.__expirationDate;
    }

    public String getId() {
        return this._id;
    }

    public boolean getIsExpired() {
        long num2;
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        return ticks > (num2 = DateExtensions.getTicks(this.getExpirationDate()));
    }

    public boolean getIsExpiring() {
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        return DateExtensions.getTicks(this.getExpirationDate()) - ticks < 86400L;
    }

    public String getIssuerName() {
        return this.__issuerName;
    }

    public RsaKey getKey() {
        return this.__key;
    }

    byte[] getSerialNumber() {
        return this.__serialNumber;
    }

    X509AlgorithmIdentifier getSignatureAlgorithm() {
        return this.__signatureAlgorithm;
    }

    public String getSubjectName() {
        return this.__subjectName;
    }

    public static DtlsCertificate parseBytes(byte[] bytes) {
        Asn1Any any = Asn1Any.parseBytes(bytes);
        if (any == null) {
            return null;
        }
        return DtlsCertificate.fromAsn1(any);
    }

    public void regenerate() {
        Date expirationDate = DateExtensions.addSeconds(DateExtensions.getUtcNow(), 864000.0);
        this.regenerate(expirationDate);
    }

    public void regenerate(Date expirationDate) {
        this.__expirationDate = expirationDate;
        this.__serialNumber = Binary.toBytes32(LockedRandomizer.next(), false);
        this.__key = RsaCrypto.createRsaKey();
        this.__buffer = null;
        this.__asn1 = null;
        this.__x509 = null;
        this.__sha1Fingerprint = null;
        this.__sha256Fingerprint = null;
    }

    public void setAutoRegenerate(boolean value) {
        this.__autoRegenerate = value;
    }

    public void setId(String value) {
        this._id = value;
    }

    public void setKey(RsaKey value) {
        this.__key = value;
    }

    Asn1Sequence toAsn1() {
        X509Certificate certificate;
        if (this.__asn1 == null && (certificate = this.toX509()) != null) {
            this.__asn1 = certificate.toAsn1();
        }
        return this.__asn1;
    }

    X509Certificate toX509() {
        if (this.__x509 == null) {
            if (this.getKey() == null || !this.getKey().hasPrivate()) {
                throw new RuntimeException(new Exception("Key is missing private information."));
            }
            X509TbsCertificate certificate2 = new X509TbsCertificate();
            certificate2.setVersion(X509TbsCertificate.getVersion3());
            certificate2.setSerialNumber(this.getSerialNumber());
            certificate2.setSignatureAlgorithm(this.getSignatureAlgorithm());
            certificate2.setIssuer(new X501Name(new X501RelativeDistinguishedName[]{new X501RelativeDistinguishedName(new X501Attribute[]{new X501Attribute(X501AttributeType.getCommonName(), new X501DirectoryString(this.getIssuerName()).toAsn1Printable().getBytes())})}));
            X509Validity validity = new X509Validity();
            validity.setNotBefore(new X509Time(this.getEffectiveDate(), X509TimeType.Utc));
            validity.setNotAfter(new X509Time(this.getExpirationDate(), X509TimeType.Utc));
            certificate2.setValidity(validity);
            certificate2.setSubject(new X501Name(new X501RelativeDistinguishedName[]{new X501RelativeDistinguishedName(new X501Attribute[]{new X501Attribute(X501AttributeType.getCommonName(), new X501DirectoryString(this.getSubjectName()).toAsn1Printable().getBytes())})}));
            X509SubjectPublicKeyInfo info = new X509SubjectPublicKeyInfo();
            info.setAlgorithm(X509AlgorithmIdentifier.getRsaEncryption());
            info.setSubjectPublicKey(new X509RsaPublicKey(this.getKey().getModulus(), this.getKey().getPublicExponent()).toAsn1().getBytes());
            certificate2.setSubjectPublicKeyInfo(info);
            X509TbsCertificate certificate = certificate2;
            byte[] buffer = RsaCrypto.signRsaSha1(certificate.toAsn1().getBytes(), this.getKey());
            X509Certificate certificate3 = new X509Certificate();
            certificate3.setTbsCertificate(certificate);
            certificate3.setSignatureAlgorithm(this.getSignatureAlgorithm());
            certificate3.setSignature(buffer);
            this.__x509 = certificate3;
        }
        return this.__x509;
    }
}

