/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.LongHolder;

public class Binary {
    public static void deinterleave(byte[] inputFrame, byte[] outputFrame, int start, int length, boolean reversePlanes) {
        int num = start + length;
        int num2 = length / 2;
        if (num > ArrayExtensions.getLength(outputFrame)) {
            Log.error("start + length greater than outputFrame length");
        } else {
            int num4;
            int num3;
            if (reversePlanes) {
                num3 = start + num2;
                num4 = start;
            } else {
                num3 = start;
                num4 = start + num2;
            }
            for (int i = start; i < num; i += 2) {
                outputFrame[num3++] = inputFrame[i];
                outputFrame[num4++] = inputFrame[i + 1];
            }
        }
    }

    public static void deinterleave(byte[] inputFrame, byte[] outputFrame, int start, int length) {
        Binary.deinterleave(inputFrame, outputFrame, start, length, false);
    }

    public static void deinterleave(byte[] inputFrame, byte[] outputFrame) {
        Binary.deinterleave(inputFrame, outputFrame, 0, ArrayExtensions.getLength(inputFrame), false);
    }

    public static void deinterleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int start, boolean reversePlanes) {
        int num = width * height;
        int length = num * 2;
        int num3 = stride - width;
        int num4 = start + length;
        if (num4 > ArrayExtensions.getLength(outputFrame)) {
            Log.error("start + length greater than outputFrame length");
        } else {
            int num9;
            int num6;
            int num5;
            if (reversePlanes) {
                num5 = start + num;
                num6 = start;
            } else {
                num5 = start;
                num6 = start + num;
            }
            int num7 = height + 1;
            int[] numArray = new int[num7];
            int num8 = width * 2;
            for (num9 = 0; num9 < num7; ++num9) {
                numArray[num9] = num8 * num9 + start;
                if (num9 <= 1) continue;
                numArray[num9] = numArray[num9] + num3 * (num9 - 1);
            }
            if (rotation == 270) {
                for (num9 = 1; num9 <= num8; num9 += 2) {
                    for (int num10 = 1; num10 < num7; ++num10) {
                        outputFrame[num5++] = inputFrame[numArray[num10] - (num9 + 1)];
                        outputFrame[num6++] = inputFrame[numArray[num10] - num9];
                    }
                }
            } else if (rotation == 90) {
                for (num9 = 0; num9 < num8; num9 += 2) {
                    for (int num10 = num7 - 2; num10 >= 0; --num10) {
                        outputFrame[num5++] = inputFrame[numArray[num10] + num9];
                        outputFrame[num6++] = inputFrame[numArray[num10] + (num9 + 1)];
                    }
                }
            } else if (rotation == 180) {
                for (num9 = start + length - 1; num9 >= start; num9 -= 2) {
                    outputFrame[num5++] = inputFrame[num9 - 1];
                    outputFrame[num6++] = inputFrame[num9];
                }
            } else {
                Binary.deinterleave(inputFrame, outputFrame, start, length, reversePlanes);
            }
        }
    }

    public static void deinterleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int start) {
        Binary.deinterleaveTransform(inputFrame, outputFrame, width, height, stride, rotation, start, false);
    }

    public static void deinterleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation) {
        Binary.deinterleaveTransform(inputFrame, outputFrame, width, height, stride, rotation, 0, false);
    }

    public static boolean fromBytes1(byte[] input, int inputIndex, int bitOffset) {
        return (BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 7 - bitOffset) & 1) == 1;
    }

    public static int fromBytes13(byte[] input, int inputIndex, int bitOffset, boolean littleEndian) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes16(input, inputIndex, littleEndian), 1 - bitOffset) & 0x1FFF;
    }

    public static int fromBytes15(byte[] input, int inputIndex, int bitOffset, boolean littleEndian) {
        if (bitOffset != 0 && bitOffset != 1) {
            throw new RuntimeException(new Exception("FromBytes15 does not support crossing the byte boundary."));
        }
        return BitAssistant.rightShiftInteger(Binary.fromBytes16(input, inputIndex, littleEndian), 1 - bitOffset) & Short.MAX_VALUE;
    }

    public static int fromBytes16(byte[] input, int inputIndex, boolean littleEndian) {
        int num = 0;
        if (littleEndian) {
            return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8);
        }
        return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0);
    }

    public static int fromBytes2(byte[] input, int inputIndex, int bitOffset) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 6 - bitOffset) & 3;
    }

    public static int fromBytes24(byte[] input, int inputIndex, boolean littleEndian) {
        int num = 0;
        if (littleEndian) {
            num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0);
            return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 16);
        }
        num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 8)) | BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex++]), 0);
    }

    public static int fromBytes3(byte[] input, int inputIndex, int bitOffset) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 5 - bitOffset) & 7;
    }

    public static long fromBytes32(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static int fromBytes4(byte[] input, int inputIndex, int bitOffset) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 4 - bitOffset) & 0xF;
    }

    public static long fromBytes40(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static long fromBytes48(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static int fromBytes5(byte[] input, int inputIndex, int bitOffset) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 3 - bitOffset) & 0x1F;
    }

    public static long fromBytes56(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static int fromBytes6(byte[] input, int inputIndex, int bitOffset) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 2 - bitOffset) & 0x3F;
    }

    public static long fromBytes64(byte[] input, int inputIndex, boolean littleEndian) {
        long num = 0L;
        if (littleEndian) {
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
            num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
            return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 56);
        }
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 56);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 48);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 40);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 32);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 24);
        num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 16);
        return (num |= BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 8)) | BitAssistant.leftShiftLong(BitAssistant.castLong(input[inputIndex++]), 0);
    }

    public static int fromBytes7(byte[] input, int inputIndex, int bitOffset) {
        return BitAssistant.rightShiftInteger(Binary.fromBytes8(input, inputIndex), 1 - bitOffset) & 0x7F;
    }

    public static int fromBytes8(byte[] input, int inputIndex) {
        return BitAssistant.leftShiftInteger(BitAssistant.castInteger(input[inputIndex]), 0);
    }

    public static void interleave(byte[] inputFrame, byte[] outputFrame) {
        Binary.interleave(inputFrame, outputFrame, 0, ArrayExtensions.getLength(inputFrame), false);
    }

    public static void interleave(byte[] inputFrame, byte[] outputFrame, int start, int length) {
        Binary.interleave(inputFrame, outputFrame, start, length, false);
    }

    public static void interleave(byte[] inputFrame, byte[] outputFrame, int start, int length, boolean reversePlanes) {
        int num = start + length;
        int num2 = length / 2;
        if (num > ArrayExtensions.getLength(outputFrame)) {
            Log.error("start + length greater than outputFrame length");
        } else {
            int num4;
            int num3;
            if (reversePlanes) {
                num3 = start + num2;
                num4 = start;
            } else {
                num3 = start;
                num4 = start + num2;
            }
            int num5 = 0;
            for (int i = 0; i < num2; ++i) {
                outputFrame[num5++] = inputFrame[num3 + i];
                outputFrame[num5++] = inputFrame[num4 + i];
            }
        }
    }

    public static void interleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation) {
        Binary.interleaveTransform(inputFrame, outputFrame, width, height, stride, rotation, 0, false);
    }

    public static void interleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int start) {
        Binary.interleaveTransform(inputFrame, outputFrame, width, height, stride, rotation, start, false);
    }

    public static void interleaveTransform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int start, boolean reversePlanes) {
        int num = stride > 0 ? stride * height : width * height;
        int num2 = width * height * 2;
        int num3 = stride > 0 ? stride - width : width;
        int num4 = start + num2;
        if (num4 > ArrayExtensions.getLength(outputFrame)) {
            Log.error("start + length greater than outputFrame length");
        } else {
            int num9;
            int num6;
            int num5;
            if (reversePlanes) {
                num5 = start + num;
                num6 = start;
            } else {
                num5 = start;
                num6 = start + num;
            }
            int num7 = height + 1;
            int[] numArray = new int[num7];
            int num8 = width;
            for (num9 = 0; num9 < num7; ++num9) {
                numArray[num9] = num8 * num9 + start + num3 * (num9 - 1);
            }
            int num10 = 0;
            if (rotation == 270) {
                for (num9 = 1; num9 <= num8; ++num9) {
                    for (int num11 = 1; num11 < num7; ++num11) {
                        outputFrame[num10++] = inputFrame[num5 + numArray[num11] - num9];
                        outputFrame[num10++] = inputFrame[num6 + numArray[num11] - num9];
                    }
                }
            } else if (rotation == 90) {
                for (num9 = 0; num9 < num8; ++num9) {
                    for (int num11 = num7 - 2; num11 >= 0; --num11) {
                        outputFrame[num10++] = inputFrame[num5 + numArray[num11] + num9 + num3];
                        outputFrame[num10++] = inputFrame[num6 + numArray[num11] + num9 + num3];
                    }
                }
            } else if (rotation == 180) {
                for (num9 = num - 1; num9 >= 0; --num9) {
                    outputFrame[num10++] = inputFrame[num5 + num9];
                    outputFrame[num10++] = inputFrame[num6 + num9];
                }
            } else {
                Binary.interleave(inputFrame, outputFrame, start, num * 2, reversePlanes);
            }
        }
    }

    public static byte[] toBytes1(boolean value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes1(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes1(boolean value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            int num = Binary.fromBytes8(output, outputIndex);
            output[outputIndex] = (byte)(num ^ ((value ? -1 : 0) ^ num) & BitAssistant.leftShiftInteger(1, 7 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes13(int value, int bitOffset, boolean littleEndian) {
        byte[] output = new byte[2];
        Binary.toBytes13(value, bitOffset, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes13(int value, int bitOffset, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes16(output, outputIndex, littleEndian) & ~BitAssistant.leftShiftInteger(8191, 1 - bitOffset) | BitAssistant.leftShiftInteger(value & 0x1FFF, 1 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes16(int value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 1 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes16(int value, boolean littleEndian) {
        byte[] output = new byte[2];
        Binary.toBytes16(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes2(int value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes2(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes2(int value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes8(output, outputIndex) & ~BitAssistant.leftShiftInteger(3, 6 - bitOffset) | BitAssistant.leftShiftInteger(value & 3, 6 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes24(int value, boolean littleEndian) {
        byte[] output = new byte[3];
        Binary.toBytes24(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes24(int value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 2 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
                output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF0000, 16);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF0000, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF00, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes3(int value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes3(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes3(int value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes8(output, outputIndex) & ~BitAssistant.leftShiftInteger(7, 5 - bitOffset) | BitAssistant.leftShiftInteger(value & 7, 5 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes32(long value, boolean littleEndian) {
        byte[] output = new byte[4];
        Binary.toBytes32(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes32(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 3 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes4(int value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes8(output, outputIndex) & ~BitAssistant.leftShiftInteger(15, 4 - bitOffset) | BitAssistant.leftShiftInteger(value & 0xF, 4 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes4(int value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes4(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes40(long value, boolean littleEndian) {
        byte[] output = new byte[5];
        Binary.toBytes40(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes40(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 4 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes48(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 5 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes48(long value, boolean littleEndian) {
        byte[] output = new byte[6];
        Binary.toBytes48(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes5(int value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes8(output, outputIndex) & ~BitAssistant.leftShiftInteger(31, 3 - bitOffset) | BitAssistant.leftShiftInteger(value & 0x1F, 3 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes5(int value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes5(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes56(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 6 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes56(long value, boolean littleEndian) {
        byte[] output = new byte[7];
        Binary.toBytes56(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes6(int value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes6(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes6(int value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes8(output, outputIndex) & ~BitAssistant.leftShiftInteger(63, 2 - bitOffset) | BitAssistant.leftShiftInteger(value & 0x3F, 2 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes64(long value, boolean littleEndian, byte[] output, int outputIndex) {
        if (outputIndex + 7 < ArrayExtensions.getLength(output)) {
            if (littleEndian) {
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value, 0);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
                output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value, 56);
                return output;
            }
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value, 56);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000000000L, 48);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000000000L, 40);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00000000L, 32);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF000000L, 24);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF0000L, 16);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFF00L, 8);
            output[outputIndex++] = (byte)BitAssistant.rightShiftLong(value & 0xFFL, 0);
            return output;
        }
        return null;
    }

    public static byte[] toBytes64(long value, boolean littleEndian) {
        byte[] output = new byte[8];
        Binary.toBytes64(value, littleEndian, output, 0);
        return output;
    }

    public static byte[] toBytes7(int value, int bitOffset) {
        byte[] output = new byte[1];
        Binary.toBytes7(value, bitOffset, output, 0);
        return output;
    }

    public static byte[] toBytes7(int value, int bitOffset, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)(Binary.fromBytes8(output, outputIndex) & ~BitAssistant.leftShiftInteger(127, 1 - bitOffset) | BitAssistant.leftShiftInteger(value & 0x7F, 1 - bitOffset));
            return output;
        }
        return null;
    }

    public static byte[] toBytes8(int value) {
        byte[] output = new byte[1];
        Binary.toBytes8(value, output, 0);
        return output;
    }

    public static byte[] toBytes8(int value, byte[] output, int outputIndex) {
        if (outputIndex < ArrayExtensions.getLength(output)) {
            output[outputIndex] = (byte)BitAssistant.rightShiftInteger(value & 0xFF, 0);
            return output;
        }
        return null;
    }

    public static void transform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int inputStart, int outputStart) {
        Binary.transform(inputFrame, outputFrame, width, height, stride, rotation, inputStart, outputStart, 1);
    }

    public static void transform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation) {
        Binary.transform(inputFrame, outputFrame, width, height, stride, rotation, 0, 0);
    }

    public static void transform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int inputStart, int outputStart, int chunkLength) {
        int num = width * height * chunkLength;
        int length = stride > 0 ? stride * height * chunkLength : num;
        int num3 = outputStart > 0 ? outputStart : inputStart;
        int num4 = stride > 0 ? (stride - width) * chunkLength : 0;
        int num5 = outputStart + num;
        if (num5 > ArrayExtensions.getLength(outputFrame)) {
            Log.error("otuputStart + calculated output plane length is greater than outputFrame length");
        } else {
            int num8;
            int num6 = height + 1;
            int[] numArray = new int[num6];
            int num7 = width * chunkLength;
            for (num8 = 0; num8 < num6; ++num8) {
                numArray[num8] = num7 * num8 + inputStart + num4 * (num8 - 1);
            }
            if (rotation == 270) {
                for (num8 = 1; num8 <= num7; num8 += chunkLength) {
                    for (int num9 = 1; num9 < num6; ++num9) {
                        for (int num10 = chunkLength - 1; num10 >= 0; --num10) {
                            outputFrame[num3++] = inputFrame[numArray[num9] - num8 - num10];
                        }
                    }
                }
            } else if (rotation == 90) {
                for (num8 = 0; num8 < num7; num8 += chunkLength) {
                    for (int num9 = num6 - 2; num9 >= 0; --num9) {
                        for (int num10 = 0; num10 < chunkLength; ++num10) {
                            outputFrame[num3++] = inputFrame[numArray[num9] + num4 + num8 + num10];
                        }
                    }
                }
            } else if (rotation == 180) {
                int num11 = 0;
                for (num8 = inputStart + length - num4 - 1; num8 >= inputStart; num8 -= chunkLength) {
                    if (num4 == 0 || num11 == 0 || num11 % num7 != 0) {
                        for (int num10 = chunkLength - 1; num10 >= 0; --num10) {
                            outputFrame[num3++] = inputFrame[num8 - num10];
                            ++num11;
                        }
                        continue;
                    }
                    num8 -= num4 - chunkLength;
                    num11 = 0;
                }
            } else if (num4 == 0) {
                BitAssistant.copy(inputFrame, inputStart, outputFrame, outputStart, length);
            } else {
                for (num8 = 0; num8 < height; ++num8) {
                    BitAssistant.copy(inputFrame, inputStart + stride * chunkLength * num8, outputFrame, outputStart + width * chunkLength * num8, width * chunkLength);
                }
            }
        }
    }

    public static void transform(byte[] inputFrame, byte[] outputFrame, int width, int height, int stride, int rotation, int start) {
        Binary.transform(inputFrame, outputFrame, width, height, stride, rotation, start, start);
    }

    public static boolean tryFromBytes1(byte[] input, int inputIndex, int bitOffset, BooleanHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes1(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(false);
        return false;
    }

    public static boolean tryFromBytes13(byte[] input, int inputIndex, int bitOffset, boolean littleEndian, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes13(input, inputIndex, bitOffset, littleEndian));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes15(byte[] input, int inputIndex, int bitOffset, boolean littleEndian, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes15(input, inputIndex, bitOffset, littleEndian));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes16(byte[] input, int inputIndex, boolean littleEndian, IntegerHolder value) {
        if (inputIndex + 1 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes16(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes2(byte[] input, int inputIndex, int bitOffset, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes2(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes24(byte[] input, int inputIndex, boolean littleEndian, IntegerHolder value) {
        if (inputIndex + 2 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes24(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes3(byte[] input, int inputIndex, int bitOffset, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes3(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes32(byte[] input, int inputIndex, boolean littleEndian, LongHolder value) {
        if (inputIndex + 3 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes32(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0L);
        return false;
    }

    public static boolean tryFromBytes4(byte[] input, int inputIndex, int bitOffset, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes4(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes40(byte[] input, int inputIndex, boolean littleEndian, LongHolder value) {
        if (inputIndex + 4 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes40(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0L);
        return false;
    }

    public static boolean tryFromBytes48(byte[] input, int inputIndex, boolean littleEndian, LongHolder value) {
        if (inputIndex + 5 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes48(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0L);
        return false;
    }

    public static boolean tryFromBytes5(byte[] input, int inputIndex, int bitOffset, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes5(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes56(byte[] input, int inputIndex, boolean littleEndian, LongHolder value) {
        if (inputIndex + 6 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes56(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0L);
        return false;
    }

    public static boolean tryFromBytes6(byte[] input, int inputIndex, int bitOffset, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes6(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes64(byte[] input, int inputIndex, boolean littleEndian, LongHolder value) {
        if (inputIndex + 7 < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes64(input, inputIndex, littleEndian));
            return true;
        }
        value.setValue(0L);
        return false;
    }

    public static boolean tryFromBytes7(byte[] input, int inputIndex, int bitOffset, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes7(input, inputIndex, bitOffset));
            return true;
        }
        value.setValue(0);
        return false;
    }

    public static boolean tryFromBytes8(byte[] input, int inputIndex, IntegerHolder value) {
        if (inputIndex < ArrayExtensions.getLength(input)) {
            value.setValue(Binary.fromBytes8(input, inputIndex));
            return true;
        }
        value.setValue(0);
        return false;
    }
}

