/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1BmpString;
import fm.icelink.Asn1Boolean;
import fm.icelink.Asn1GeneralString;
import fm.icelink.Asn1GeneralizedTime;
import fm.icelink.Asn1GraphicString;
import fm.icelink.Asn1Ia5String;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Null;
import fm.icelink.Asn1NumericString;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1OctetString;
import fm.icelink.Asn1PrintableString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Asn1Set;
import fm.icelink.Asn1UniversalString;
import fm.icelink.Asn1Unknown;
import fm.icelink.Asn1UtcTime;
import fm.icelink.Asn1Utf8String;
import fm.icelink.Asn1VisibleString;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.ParseAssistant;
import fm.icelink.StringExtensions;
import java.util.Date;

abstract class Asn1Any {
    private static byte[] _decode128LowerBytes;
    private static byte[] _decode128UpperBytes;
    private static byte[] _encode128LowerBytes;
    private static byte[] _encode128UpperBytes;
    private static int _indefiniteLength;
    private DataBuffer _sourceData;

    protected Asn1Any() {
    }

    public static byte[] decode128(byte[] encoded) {
        return Asn1Any.decode128(encoded, 0, ArrayExtensions.getLength(encoded));
    }

    public static byte[] decode128(byte[] encoded, int offset, int length) {
        byte[] buffer = new byte[(int)MathAssistant.ceil(Asn1Any.intToDouble(length) * 7.0 / 8.0)];
        for (int i = length * 7 - 1; i >= 0; i -= 8) {
            int num2 = (int)MathAssistant.floor(Asn1Any.intToDouble(i) / 7.0);
            int index = i / 8;
            int num4 = i % 7;
            byte num5 = encoded[offset + num2];
            num5 = (byte)(num5 & _decode128LowerBytes[num4]);
            byte num6 = num2 == 0 ? (byte)0 : encoded[offset + num2 - 1];
            num6 = (byte)(num6 & _decode128UpperBytes[num4]);
            buffer[index] = (byte)(num5 >> 6 - num4 | num6 << num4 + 1);
        }
        return buffer;
    }

    public static long decode128Integer(byte[] bytes, int offset, int length) {
        return Binary.fromBytes32(Asn1Any.pad(Asn1Any.decode128(bytes, offset, length), 4), 0, false);
    }

    public static long decode128Integer(byte[] bytes) {
        return Asn1Any.decode128Integer(bytes, 0, ArrayExtensions.getLength(bytes));
    }

    public static long decode128Long(byte[] bytes, int offset, int length) {
        return Binary.fromBytes64(Asn1Any.pad(Asn1Any.decode128(bytes, offset, length), 8), 0, false);
    }

    public static long decode128Long(byte[] bytes) {
        return Asn1Any.decode128Long(bytes, 0, ArrayExtensions.getLength(bytes));
    }

    public static int decode128Short(byte[] bytes, int offset, int length) {
        return Binary.fromBytes16(Asn1Any.pad(Asn1Any.decode128(bytes, offset, length), 2), 0, false);
    }

    public static int decode128Short(byte[] bytes) {
        return Asn1Any.decode128Short(bytes, 0, ArrayExtensions.getLength(bytes));
    }

    public static Date deserializeTimestamp(String timestampString) {
        if (!timestampString.endsWith("Z")) {
            Log.error(StringExtensions.format("Timestamp format is incorrect: {0}.", timestampString));
            return DateExtensions.getUtcNow();
        }
        String str = StringExtensions.substring(timestampString, 0, StringExtensions.getLength(timestampString) - 1);
        if (StringExtensions.getLength(str) % 2 > 0 || StringExtensions.getLength(str) < StringExtensions.getLength("YYMMDD")) {
            Log.error(StringExtensions.format("Timestamp format is incorrect: {0}.", timestampString));
            return DateExtensions.getUtcNow();
        }
        if (StringExtensions.getLength(str) == StringExtensions.getLength("YYMMDD")) {
            str = StringExtensions.concat(str, "00");
        }
        if (StringExtensions.getLength(str) == StringExtensions.getLength("YYMMDDhh")) {
            str = StringExtensions.concat(str, "00");
        }
        if (StringExtensions.getLength(str) == StringExtensions.getLength("YYMMDDhhmm")) {
            str = StringExtensions.concat(str, "00");
        }
        if (StringExtensions.getLength(str) == StringExtensions.getLength("YYMMDDhhmmss")) {
            str = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, 0, 2)) >= 50 ? StringExtensions.concat("19", str) : StringExtensions.concat("20", str);
        }
        int startIndex = 0;
        int year = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, startIndex, 4));
        int month = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, startIndex += 4, 2));
        int day = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, startIndex += 2, 2));
        int hour = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, startIndex += 2, 2));
        int minute = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, startIndex += 2, 2));
        int second = ParseAssistant.parseIntegerValue(StringExtensions.substring(str, startIndex += 2, 2));
        startIndex += 2;
        return DateExtensions.createDate(year, month, day, hour, minute, second);
    }

    public static byte[] encode128(byte[] value) {
        byte[] array = new byte[(int)MathAssistant.ceil(Asn1Any.intToDouble(ArrayExtensions.getLength(value)) * 8.0 / 7.0)];
        for (int i = ArrayExtensions.getLength(value) * 8 - 1; i >= 0; i -= 7) {
            int index = i / 7;
            int num3 = (int)MathAssistant.floor(Asn1Any.intToDouble(i) / 8.0);
            int num4 = i % 8;
            byte num5 = value[num3];
            if (num4 == 7) {
                num5 = (byte)(num5 & 0x7F);
            } else if (num4 == 6) {
                num5 = (byte)(num5 & 0xFE);
            } else {
                int num6 = value[num3] & 0xFF;
                int num7 = num3 == 0 ? 0 : value[num3 - 1] & 0xFF;
                num5 = (byte)((num6 &= _encode128LowerBytes[num4]) >> 7 - num4 | (num7 &= _encode128UpperBytes[num4]) << num4 + 1);
            }
            if (index < ArrayExtensions.getLength(array) - 1) {
                num5 = (byte)(num5 | 0x80);
            }
            array[index] = num5;
        }
        while ((array[0] & 0xFF) == 128) {
            array = BitAssistant.subArray(array, 1);
        }
        return array;
    }

    public static byte[] encode128Integer(int value) {
        return Asn1Any.encode128(Asn1Any.trim(Binary.toBytes32(value, false)));
    }

    public static byte[] encode128Long(long value) {
        return Asn1Any.encode128(Asn1Any.trim(Binary.toBytes64(value, false)));
    }

    public static byte[] encode128Short(short value) {
        return Asn1Any.encode128(Asn1Any.trim(Binary.toBytes16(value, false)));
    }

    public DataBuffer getBuffer() {
        return Asn1Any.getBuffer(this);
    }

    public static DataBuffer getBuffer(Asn1Any any) {
        int tag = 0;
        int klass = 0;
        boolean isConstructed = false;
        boolean isIndefinite = false;
        IntegerHolder _var0 = new IntegerHolder(tag);
        IntegerHolder _var1 = new IntegerHolder(klass);
        BooleanHolder _var2 = new BooleanHolder(isConstructed);
        BooleanHolder _var3 = new BooleanHolder(isIndefinite);
        any.getProperties(_var0, _var1, _var2, _var3);
        tag = _var0.getValue();
        klass = _var1.getValue();
        isConstructed = _var2.getValue();
        isIndefinite = _var3.getValue();
        byte[] contents = any.getContents();
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Asn1Any.getIdentifier(tag, klass, isConstructed));
        bytes.addRange(Asn1Any.getLength(contents, isIndefinite));
        bytes.addRange(contents);
        if (isIndefinite) {
            bytes.addRange(new byte[2]);
        }
        return DataBuffer.wrap(bytes.toArray());
    }

    public byte[] getBytes() {
        return this.getBuffer().toArray();
    }

    public static byte[] getBytes(Asn1Any any) {
        return Asn1Any.getBuffer(any).toArray();
    }

    public abstract byte[] getContents();

    private static byte[] getIdentifier(int tag, int klass, boolean isConstructed) {
        int num;
        ByteCollection bytes = new ByteCollection();
        int n = num = isConstructed ? 32 : 0;
        if (tag < 31) {
            bytes.add((byte)(klass | tag | num));
        } else {
            bytes.add((byte)(klass | 0x1F | num));
            bytes.addRange(Asn1Any.encode128(new byte[]{(byte)tag}));
        }
        return bytes.toArray();
    }

    private static int getIdentifierLength(byte[] bytes, int offset) {
        if ((bytes[offset] & 0x1F) == 31) {
            return 1 + Asn1Any.getLength128(bytes, offset + 1);
        }
        return 1;
    }

    private static byte[] getLength(byte[] contents, boolean isIndefinite) {
        if (isIndefinite) {
            return new byte[]{(byte)_indefiniteLength};
        }
        ByteCollection bytes = new ByteCollection();
        if (ArrayExtensions.getLength(contents) < 128) {
            bytes.add((byte)ArrayExtensions.getLength(contents));
        } else {
            byte[] buffer = Asn1Any.trim(Binary.toBytes64(ArrayExtensions.getLength(contents), false));
            bytes.add((byte)(0x80 | (byte)ArrayExtensions.getLength(buffer)));
            bytes.addRange(buffer);
        }
        return bytes.toArray();
    }

    public static int getLength128(byte[] encoded, int offset) {
        for (int i = offset; i < ArrayExtensions.getLength(encoded); ++i) {
            if ((encoded[i] & 0x80) != 0) continue;
            return i - offset + 1;
        }
        return 0;
    }

    private static int getLengthLength(byte[] bytes, int offset) {
        if (bytes[offset] != 128 && (bytes[offset] & 0x80) == 128) {
            return (bytes[offset] & 0x7F) + 1;
        }
        return 1;
    }

    public abstract void getProperties(IntegerHolder var1, IntegerHolder var2, BooleanHolder var3, BooleanHolder var4);

    public DataBuffer getSourceData() {
        return this._sourceData;
    }

    private static double intToDouble(int value) {
        return value;
    }

    public static byte[] pad(byte[] bytes, int length, int value) {
        ByteCollection bytes2 = new ByteCollection();
        byte[] buffer = new byte[length - ArrayExtensions.getLength(bytes)];
        for (int i = 0; i < ArrayExtensions.getLength(buffer); ++i) {
            buffer[i] = (byte)value;
        }
        bytes2.addRange(buffer);
        bytes2.addRange(bytes);
        return bytes2.toArray();
    }

    public static byte[] pad(byte[] bytes, int length) {
        return Asn1Any.pad(bytes, length, 0);
    }

    public static Asn1Any parseBuffer(DataBuffer buffer, int offset, IntegerHolder byteCount) {
        Asn1Any _var0 = Asn1Any.parseBytesInternal(buffer.getData(), buffer.getIndex() + offset, byteCount);
        Asn1Any any = _var0;
        if (any != null) {
            any.setSourceData(buffer.subset(offset, byteCount.getValue()));
        }
        return any;
    }

    public static Asn1Any parseBuffer(DataBuffer buffer) {
        int byteCount = 0;
        IntegerHolder _var0 = new IntegerHolder(byteCount);
        Asn1Any _var1 = Asn1Any.parseBuffer(buffer, 0, _var0);
        byteCount = _var0.getValue();
        return _var1;
    }

    public static Asn1Any parseBytes(byte[] bytes, int offset, IntegerHolder byteCount) {
        Asn1Any _var0 = Asn1Any.parseBuffer(DataBuffer.wrap(bytes), offset, byteCount);
        return _var0;
    }

    public static Asn1Any parseBytes(byte[] bytes) {
        int byteCount = 0;
        IntegerHolder _var0 = new IntegerHolder(byteCount);
        Asn1Any _var1 = Asn1Any.parseBytes(bytes, 0, _var0);
        byteCount = _var0.getValue();
        return _var1;
    }

    private static Asn1Any parseBytesInternal(byte[] bytes, int offset, IntegerHolder byteCount) {
        int identifierLength = Asn1Any.getIdentifierLength(bytes, offset);
        int tag = 0;
        int klass = 0;
        boolean isConstructed = false;
        IntegerHolder _var0 = new IntegerHolder(tag);
        IntegerHolder _var1 = new IntegerHolder(klass);
        BooleanHolder _var2 = new BooleanHolder(isConstructed);
        boolean _var3 = Asn1Any.parseIdentifier(bytes, offset, identifierLength, _var0, _var1, _var2);
        tag = _var0.getValue();
        klass = _var1.getValue();
        isConstructed = _var2.getValue();
        if (!_var3) {
            byteCount.setValue(0);
            return null;
        }
        int lengthLength = Asn1Any.getLengthLength(bytes, offset += identifierLength);
        int length = 0;
        boolean isIndefinite = false;
        IntegerHolder _var4 = new IntegerHolder(length);
        BooleanHolder _var5 = new BooleanHolder(isIndefinite);
        boolean _var6 = Asn1Any.parseLength(bytes, offset, lengthLength, _var4, _var5);
        length = _var4.getValue();
        isIndefinite = _var5.getValue();
        if (!_var6) {
            byteCount.setValue(0);
            return null;
        }
        byte[] contents = BitAssistant.subArray(bytes, offset += lengthLength, length);
        offset += length;
        byteCount.setValue(identifierLength + lengthLength + length);
        if (klass == 0) {
            int _var7 = tag;
            if (_var7 == 3) {
                return Asn1BitString.parseContents(contents);
            }
            if (_var7 == 30) {
                return Asn1BmpString.parseContents(contents);
            }
            if (_var7 == 1) {
                return Asn1Boolean.parseContents(contents);
            }
            if (_var7 == 24) {
                return Asn1GeneralizedTime.parseContents(contents);
            }
            if (_var7 == 27) {
                return Asn1GeneralString.parseContents(contents);
            }
            if (_var7 == 25) {
                return Asn1GraphicString.parseContents(contents);
            }
            if (_var7 == 22) {
                return Asn1Ia5String.parseContents(contents);
            }
            if (_var7 == 2) {
                return Asn1Integer.parseContents(contents);
            }
            if (_var7 == 5) {
                return Asn1Null.parseContents(contents);
            }
            if (_var7 == 18) {
                return Asn1NumericString.parseContents(contents);
            }
            if (_var7 == 6) {
                return Asn1ObjectIdentifier.parseContents(contents);
            }
            if (_var7 == 4) {
                return Asn1OctetString.parseContents(contents);
            }
            if (_var7 == 19) {
                return Asn1PrintableString.parseContents(contents);
            }
            if (_var7 == 16) {
                return Asn1Sequence.parseContents(contents);
            }
            if (_var7 == 17) {
                return Asn1Set.parseContents(contents);
            }
            if (_var7 == 28) {
                return Asn1UniversalString.parseContents(contents);
            }
            if (_var7 == 23) {
                return Asn1UtcTime.parseContents(contents);
            }
            if (_var7 == 12) {
                return Asn1Utf8String.parseContents(contents);
            }
            if (_var7 == 26) {
                return Asn1VisibleString.parseContents(contents);
            }
        } else if (klass == 128 || klass == 64 || klass == 192) {
            // empty if block
        }
        return Asn1Unknown.parseContents(tag, klass, isConstructed, isIndefinite, contents);
    }

    private static boolean parseIdentifier(byte[] bytes, int offset, int count, IntegerHolder tag, IntegerHolder klass, BooleanHolder isConstructed) {
        if (ArrayExtensions.getLength(bytes) < offset + count || count < 1 || count > 2) {
            tag.setValue(0);
            klass.setValue(0);
            isConstructed.setValue(false);
            return false;
        }
        if (count == 1) {
            tag.setValue(bytes[offset] & 0x1F);
        } else {
            tag.setValue((int)Asn1Any.decode128Integer(bytes, offset + 1, count - 1));
        }
        klass.setValue(bytes[offset] & 0xC0);
        isConstructed.setValue((bytes[offset] & 0x20) == 32);
        return true;
    }

    private static boolean parseLength(byte[] bytes, int offset, int count, IntegerHolder length, BooleanHolder isIndefinite) {
        if (ArrayExtensions.getLength(bytes) < offset + count || count < 1) {
            length.setValue(0);
            isIndefinite.setValue(false);
            return false;
        }
        if (count != 1) {
            int num2 = bytes[offset] & 0x7F;
            if (count != num2 + 1) {
                length.setValue(0);
                isIndefinite.setValue(false);
                return false;
            }
            byte[] buffer = BitAssistant.subArray(bytes, offset + 1, num2);
            length.setValue((int)Binary.fromBytes64(Asn1Any.pad(buffer, 8), 0, false));
            isIndefinite.setValue(false);
            return true;
        }
        if (bytes[offset] != 128) {
            length.setValue(bytes[offset]);
            isIndefinite.setValue(false);
        } else {
            length.setValue(0);
            for (int i = offset + count; i < ArrayExtensions.getLength(bytes) - 1; ++i) {
                if (bytes[i] != 0 || bytes[i + 1] != 0) continue;
                length.setValue(i - (offset + count));
                break;
            }
            isIndefinite.setValue(true);
        }
        return true;
    }

    public static String serializeTimestamp(Date timestamp, int yearLength, int monthLength, int dayLength, int hourLength, int minuteLength, int secondLength) {
        String str = IntegerExtensions.toString(DateExtensions.getYear(timestamp));
        String str2 = IntegerExtensions.toString(DateExtensions.getMonth(timestamp));
        String str3 = IntegerExtensions.toString(DateExtensions.getDay(timestamp));
        String str4 = IntegerExtensions.toString(DateExtensions.getHour(timestamp));
        String str5 = IntegerExtensions.toString(DateExtensions.getMinute(timestamp));
        String str6 = IntegerExtensions.toString(DateExtensions.getSecond(timestamp));
        while (StringExtensions.getLength(str) < yearLength) {
            str = StringExtensions.concat("0", str);
        }
        while (StringExtensions.getLength(str) > yearLength) {
            str = str.substring(1);
        }
        while (StringExtensions.getLength(str2) < monthLength) {
            str2 = StringExtensions.concat("0", str2);
        }
        while (StringExtensions.getLength(str2) > monthLength) {
            str2 = str2.substring(1);
        }
        while (StringExtensions.getLength(str3) < dayLength) {
            str3 = StringExtensions.concat("0", str3);
        }
        while (StringExtensions.getLength(str3) > dayLength) {
            str3 = str3.substring(1);
        }
        while (StringExtensions.getLength(str4) < hourLength) {
            str4 = StringExtensions.concat("0", str4);
        }
        while (StringExtensions.getLength(str4) > hourLength) {
            str4 = str4.substring(1);
        }
        while (StringExtensions.getLength(str5) < minuteLength) {
            str5 = StringExtensions.concat("0", str5);
        }
        while (StringExtensions.getLength(str5) > minuteLength) {
            str5 = str5.substring(1);
        }
        while (StringExtensions.getLength(str6) < secondLength) {
            str6 = StringExtensions.concat("0", str6);
        }
        while (StringExtensions.getLength(str6) > secondLength) {
            str6 = str6.substring(1);
        }
        return StringExtensions.format("{0}{1}{2}{3}{4}{5}", new Object[]{str, str2, str3, str4, str5, str6});
    }

    private void setSourceData(DataBuffer value) {
        this._sourceData = value;
    }

    public static byte[] trim(byte[] bytes, int minLength, int maxLength) {
        ByteCollection bytes2 = new ByteCollection();
        boolean flag = false;
        for (int i = ArrayExtensions.getLength(bytes) - maxLength; i < ArrayExtensions.getLength(bytes); ++i) {
            int num2 = bytes[i] & 0xFF;
            if (!flag && num2 > 0) {
                flag = true;
            }
            if (!flag && ArrayExtensions.getLength(bytes) - i > minLength) continue;
            bytes2.add((byte)num2);
        }
        return bytes2.toArray();
    }

    public static byte[] trim(byte[] bytes) {
        return Asn1Any.trim(bytes, 0);
    }

    public static byte[] trim(byte[] bytes, int minLength) {
        return Asn1Any.trim(bytes, minLength, ArrayExtensions.getLength(bytes));
    }

    static {
        _indefiniteLength = 128;
        _encode128LowerBytes = new byte[]{-128, -64, -32, -16, -8, -4};
        _encode128UpperBytes = new byte[]{63, 31, 15, 7, 3, 1};
        _decode128LowerBytes = new byte[]{64, 96, 112, 120, 124, 126, 127};
        _decode128UpperBytes = new byte[]{127, 63, 31, 15, 7, 3, 1};
    }
}

