/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.os.Process;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioSource;
import fm.icelink.DataBuffer;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.pcm.Format;
import java.util.Locale;

public class AudioRecordSource
extends AudioSource {
    private int audioSource = Build.VERSION.SDK_INT < 11 ? 1 : 7;
    private boolean useAcousticEchoCanceler = false;
    private boolean useAutomaticGainControl = true;
    private boolean useNoiseSuppressor = true;
    private Context context;
    private HeadsetStateReceiver headsetStateReceiver;
    private AudioRecord audioRecord = null;
    private AcousticEchoCanceler aec = null;
    private AutomaticGainControl agc = null;
    private NoiseSuppressor ns = null;
    private int bufferLength = 0;
    private volatile boolean isCapturing;
    private volatile boolean isStopped;

    public int getAudioSource() {
        return this.audioSource;
    }

    public void setAudioSource(int audioSource) {
        this.audioSource = audioSource;
    }

    public boolean getUseAcousticEchoCanceler() {
        return this.useAcousticEchoCanceler;
    }

    public void setUseAcousticEchoCanceler(boolean useAcousticEchoCanceler) {
        this.useAcousticEchoCanceler = useAcousticEchoCanceler;
    }

    public boolean getUseAutomaticGainControl() {
        return this.useAutomaticGainControl;
    }

    public void setUseAutomaticGainControl(boolean useAutomaticGainControl) {
        this.useAutomaticGainControl = useAutomaticGainControl;
    }

    public boolean getUseNoiseSuppressor() {
        return this.useNoiseSuppressor;
    }

    public void setUseNoiseSuppressor(boolean useNoiseSuppressor) {
        this.useNoiseSuppressor = useNoiseSuppressor;
    }

    public static int getBufferDelay(AudioConfig config) {
        int clockRate = config.getClockRate();
        int channelCount = config.getChannelCount();
        int channelConfig = channelCount == 1 ? 16 : 12;
        int minBufferSizeInBytes = AudioRecord.getMinBufferSize((int)clockRate, (int)channelConfig, (int)2);
        int bytesPerMilli = clockRate * channelCount * 2 / 1000;
        return minBufferSizeInBytes / bytesPerMilli;
    }

    public SourceInput[] getInputs() {
        return new SourceInput[0];
    }

    public String getLabel() {
        return "Android AudioRecord Source";
    }

    public AudioRecordSource(Context context, AudioConfig config) {
        super((AudioFormat)new Format(config));
        if (context == null) {
            throw new RuntimeException("Context cannot be null.");
        }
        if (context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") != 0) {
            throw new RuntimeException("Audio capture permission has not been granted. Please add android.permission.RECORD_AUDIO to your application manifest.");
        }
        this.context = context.getApplicationContext();
        this.headsetStateReceiver = new HeadsetStateReceiver(this);
        this.context.registerReceiver((BroadcastReceiver)this.headsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
    }

    public boolean destroy() {
        if (this.headsetStateReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.headsetStateReceiver);
            this.headsetStateReceiver = null;
        }
        return super.destroy();
    }

    protected Future<Object> doStart() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    int clockRate = ((AudioFormat)AudioRecordSource.this.getOutputFormat()).getClockRate();
                    int channelCount = ((AudioFormat)AudioRecordSource.this.getOutputFormat()).getChannelCount();
                    int channelConfig = channelCount == 1 ? 16 : 12;
                    int minBufferSizeInBytes = AudioRecord.getMinBufferSize((int)clockRate, (int)channelConfig, (int)2);
                    if (minBufferSizeInBytes == 0) {
                        throw new Exception("Audio capture min buffer size must be greater than 0.");
                    }
                    AudioRecordSource.this.bufferLength = minBufferSizeInBytes;
                    if (AudioRecordSource.this.getAudioSource() != 1) {
                        try {
                            AudioRecord ar = new AudioRecord(1, clockRate, channelConfig, 2, AudioRecordSource.this.bufferLength);
                            if (ar.getState() == 1) {
                                ar.startRecording();
                                ar.stop();
                                ar.release();
                            }
                        }
                        catch (Exception ar) {
                            // empty catch block
                        }
                    }
                    AudioRecordSource.this.audioRecord = new AudioRecord(AudioRecordSource.this.getAudioSource(), clockRate, channelConfig, 2, AudioRecordSource.this.bufferLength);
                    if (AudioRecordSource.this.audioRecord.getState() != 1) {
                        throw new Exception("Could not start audio capture using specified configuration.");
                    }
                    if (Build.VERSION.SDK_INT >= 16) {
                        try {
                            if (AudioRecordSource.this.getUseAcousticEchoCanceler() && AcousticEchoCanceler.isAvailable()) {
                                AudioRecordSource.this.aec = AcousticEchoCanceler.create((int)AudioRecordSource.this.audioRecord.getAudioSessionId());
                                if (AudioRecordSource.this.aec != null) {
                                    if (!AudioRecordSource.this.aec.getEnabled()) {
                                        AudioRecordSource.this.aec.setEnabled(true);
                                    }
                                    if (AudioRecordSource.this.aec.getEnabled()) {
                                        Log.info((String)"Acoustic echo canceler is active.");
                                    } else {
                                        Log.warn((String)"Acoustic echo canceler was created, but could not be enabled.");
                                    }
                                } else {
                                    Log.warn((String)"Acoustic echo canceler is available, but could not be created.");
                                }
                            } else {
                                Log.info((String)"Acoustic echo canceler is not available.");
                            }
                        }
                        catch (Exception ex) {
                            Log.error((String)String.format(Locale.getDefault(), "Acoustic echo canceler could not be enabled. %s", ex.getMessage()));
                        }
                        try {
                            if (AudioRecordSource.this.getUseAutomaticGainControl() && AutomaticGainControl.isAvailable()) {
                                AudioRecordSource.this.agc = AutomaticGainControl.create((int)AudioRecordSource.this.audioRecord.getAudioSessionId());
                                if (AudioRecordSource.this.agc != null) {
                                    if (!AudioRecordSource.this.agc.getEnabled()) {
                                        AudioRecordSource.this.agc.setEnabled(true);
                                    }
                                    if (AudioRecordSource.this.agc.getEnabled()) {
                                        Log.info((String)"Automatic gain control is active.");
                                    } else {
                                        Log.warn((String)"Automatic gain control was created, but could not be enabled.");
                                    }
                                } else {
                                    Log.warn((String)"Automatic gain control is available, but could not be created.");
                                }
                            } else {
                                Log.info((String)"Automatic gain control is not available.");
                            }
                        }
                        catch (Exception ex) {
                            Log.error((String)String.format(Locale.getDefault(), "Automatic gain control could not be enabled. %s", ex.getMessage()));
                        }
                        try {
                            if (AudioRecordSource.this.getUseNoiseSuppressor() && NoiseSuppressor.isAvailable()) {
                                AudioRecordSource.this.ns = NoiseSuppressor.create((int)AudioRecordSource.this.audioRecord.getAudioSessionId());
                                if (AudioRecordSource.this.ns != null) {
                                    if (!AudioRecordSource.this.ns.getEnabled()) {
                                        AudioRecordSource.this.ns.setEnabled(true);
                                    }
                                    if (AudioRecordSource.this.ns.getEnabled()) {
                                        Log.info((String)"Noise suppressor is active.");
                                    } else {
                                        Log.warn((String)"Noise suppressor was created, but could not be enabled.");
                                    }
                                } else {
                                    Log.warn((String)"Noise suppressor is available, but could not be created.");
                                }
                            } else {
                                Log.info((String)"Noise suppressor is not available.");
                            }
                        }
                        catch (Exception ex) {
                            Log.error((String)String.format(Locale.getDefault(), "Noise suppressor could not be enabled. %s", ex.getMessage()));
                        }
                    }
                    AudioRecordSource.this.audioRecord.startRecording();
                    AudioRecordSource.this.isCapturing = true;
                    AudioRecordSource.this.isStopped = false;
                    ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

                        public void invoke(ManagedThread thread) {
                            AudioRecordSource.this.captureLoop();
                        }
                    });
                    thread.start();
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    protected Future<Object> doStop() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    AudioRecordSource.this.isCapturing = false;
                    while (!AudioRecordSource.this.isStopped) {
                        ManagedThread.sleep((int)10);
                    }
                    if (AudioRecordSource.this.audioRecord != null) {
                        AudioRecordSource.this.audioRecord.stop();
                    }
                    try {
                        if (AudioRecordSource.this.aec != null) {
                            AudioRecordSource.this.aec.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (AudioRecordSource.this.agc != null) {
                            AudioRecordSource.this.agc.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (AudioRecordSource.this.ns != null) {
                            AudioRecordSource.this.ns.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (AudioRecordSource.this.audioRecord != null) {
                        AudioRecordSource.this.audioRecord.release();
                    }
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    private void captureLoop() {
        int byteLength;
        int clockRate = ((AudioFormat)this.getOutputFormat()).getClockRate();
        int channelCount = ((AudioFormat)this.getOutputFormat()).getChannelCount();
        if (Process.getThreadPriority((int)Process.myTid()) != -19) {
            Process.setThreadPriority((int)-19);
        }
        if ((byteLength = (int)((float)(channelCount * clockRate) * 0.1f * 2.0f)) < this.bufferLength) {
            byteLength = this.bufferLength;
        }
        byte[] captureData = new byte[byteLength];
        int count = 0;
        while (this.isCapturing) {
            count = this.audioRecord.read(captureData, 0, byteLength);
            if (count <= 0) continue;
            try {
                DataBuffer dataBuffer = DataBuffer.wrap((byte[])captureData, (int)0, (int)count);
                dataBuffer.setLittleEndian(true);
                AudioBuffer buffer = new AudioBuffer(dataBuffer, (AudioFormat)this.getOutputFormat());
                this.raiseFrame(new AudioFrame((double)this.calculateDuration(dataBuffer.getLength()), buffer));
            }
            catch (Exception ex) {
                Log.error((String)"Could not raise frame from AudioRecordSource.", (Exception)ex);
            }
        }
        this.isStopped = true;
    }

    class HeadsetStateReceiver
    extends BroadcastReceiver {
        private AudioSource source;

        public HeadsetStateReceiver(AudioSource source) {
            this.source = source;
        }

        public void onReceive(Context arg0, Intent arg1) {
            this.source.setForceTimestampReset(true);
        }
    }
}

