/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.ClassExtensions;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IntegerHolder;
import fm.icelink.stun.AlternateServerAttribute;
import fm.icelink.stun.Attribute;
import fm.icelink.stun.BindingIndication;
import fm.icelink.stun.BindingMessage;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.FingerprintAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.MessageCreationArgs;
import fm.icelink.stun.MessageIntegrityAttribute;
import fm.icelink.stun.MessageRegistration;
import fm.icelink.stun.MessageType;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;
import fm.icelink.stun.SoftwareAttribute;
import fm.icelink.stun.UnknownAttributesAttribute;
import fm.icelink.stun.UsernameAttribute;
import fm.icelink.stun.XorMappedAddressAttribute;
import fm.icelink.stun.ice.ControlledAttribute;
import fm.icelink.stun.ice.ControllingAttribute;
import fm.icelink.stun.ice.PriorityAttribute;
import fm.icelink.stun.ice.UseCandidateAttribute;
import fm.icelink.stun.turn.AllocateMessage;
import fm.icelink.stun.turn.AllocateRequest;
import fm.icelink.stun.turn.AllocateResponse;
import fm.icelink.stun.turn.ChannelBindMessage;
import fm.icelink.stun.turn.ChannelBindRequest;
import fm.icelink.stun.turn.ChannelBindResponse;
import fm.icelink.stun.turn.ChannelNumberAttribute;
import fm.icelink.stun.turn.ConnectMessage;
import fm.icelink.stun.turn.ConnectRequest;
import fm.icelink.stun.turn.ConnectResponse;
import fm.icelink.stun.turn.ConnectionAttemptIndication;
import fm.icelink.stun.turn.ConnectionAttemptMessage;
import fm.icelink.stun.turn.ConnectionBindMessage;
import fm.icelink.stun.turn.ConnectionBindRequest;
import fm.icelink.stun.turn.ConnectionBindResponse;
import fm.icelink.stun.turn.ConnectionIdAttribute;
import fm.icelink.stun.turn.CreatePermissionMessage;
import fm.icelink.stun.turn.CreatePermissionRequest;
import fm.icelink.stun.turn.CreatePermissionResponse;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.DataIndication;
import fm.icelink.stun.turn.DataMessage;
import fm.icelink.stun.turn.DontFragmentAttribute;
import fm.icelink.stun.turn.EvenPortAttribute;
import fm.icelink.stun.turn.LifetimeAttribute;
import fm.icelink.stun.turn.RefreshMessage;
import fm.icelink.stun.turn.RefreshRequest;
import fm.icelink.stun.turn.RefreshResponse;
import fm.icelink.stun.turn.RequestedAddressFamilyAttribute;
import fm.icelink.stun.turn.RequestedTransportAttribute;
import fm.icelink.stun.turn.ReservationTokenAttribute;
import fm.icelink.stun.turn.SendIndication;
import fm.icelink.stun.turn.SendMessage;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import fm.icelink.stun.turn.XorRelayedAddressAttribute;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Message {
    private ArrayList<Attribute> _attributeList;
    private static byte[] _magicCookie;
    private MessageType _messageType;
    private static HashMap<String, MessageRegistration> _registeredMessages;
    private static Object _registeredMessagesLock;
    private byte[] _transactionId;

    private static Message createAllocateMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.SuccessResponse) {
            return new AllocateResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new AllocateResponse(e.getTransactionId(), false);
        }
        return new AllocateRequest();
    }

    private static Message createBindingMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.Indication) {
            return new BindingIndication();
        }
        if (_var0 == MessageType.SuccessResponse) {
            return new BindingResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new BindingResponse(e.getTransactionId(), false);
        }
        return new BindingRequest();
    }

    private static Message createChannelBindMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.SuccessResponse) {
            return new ChannelBindResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new ChannelBindResponse(e.getTransactionId(), false);
        }
        return new ChannelBindRequest();
    }

    private static Message createConnectionAttemptMessage(MessageCreationArgs e) {
        if (Global.equals((Object)e.getMessageType(), (Object)MessageType.Indication)) {
            // empty if block
        }
        return new ConnectionAttemptIndication();
    }

    private static Message createConnectionBindMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.SuccessResponse) {
            return new ConnectionBindResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new ConnectionBindResponse(e.getTransactionId(), false);
        }
        return new ConnectionBindRequest();
    }

    private static Message createConnectMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.SuccessResponse) {
            return new ConnectResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new ConnectResponse(e.getTransactionId(), false);
        }
        return new ConnectRequest();
    }

    private static Message createCreatePermissionMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.SuccessResponse) {
            return new CreatePermissionResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new CreatePermissionResponse(e.getTransactionId(), false);
        }
        return new CreatePermissionRequest();
    }

    private static Message createDataMessage(MessageCreationArgs e) {
        if (Global.equals((Object)e.getMessageType(), (Object)MessageType.Indication)) {
            // empty if block
        }
        return new DataIndication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message createMessage(byte method, MessageType messageType, byte[] transactionId) {
        Object object = _registeredMessagesLock;
        synchronized (object) {
            for (String str : HashMapExtensions.getKeys(_registeredMessages)) {
                MessageRegistration registration = HashMapExtensions.getItem(_registeredMessages).get(str);
                if (registration.getMethod() != method) continue;
                return registration.getCreationDelegate().invoke(new MessageCreationArgs(messageType, transactionId));
            }
        }
        return null;
    }

    private static Message createRefreshMessage(MessageCreationArgs e) {
        MessageType _var0 = e.getMessageType();
        if (_var0 == MessageType.SuccessResponse) {
            return new RefreshResponse(e.getTransactionId(), true);
        }
        if (_var0 == MessageType.ErrorResponse) {
            return new RefreshResponse(e.getTransactionId(), false);
        }
        return new RefreshRequest();
    }

    private static Message createSendMessage(MessageCreationArgs e) {
        if (Global.equals((Object)e.getMessageType(), (Object)MessageType.Indication)) {
            // empty if block
        }
        return new SendIndication();
    }

    public static Message createSiblingMessage(Class type, MessageType messageType, byte[] transactionId) {
        return Message.createMessage(Message.getMethod(type.getSuperclass()), messageType, transactionId);
    }

    protected static byte[] generateTransactionId() {
        return BitAssistant.subArray(Guid.newGuid().toByteArray(), 0, 12);
    }

    public AlternateServerAttribute getAlternateServer() {
        return (AlternateServerAttribute)this.getAttribute(AlternateServerAttribute.class);
    }

    private Attribute getAttribute(Class attributeType) {
        for (Attribute attribute : this.getAttributeList()) {
            if (!Global.equals(attribute.getClass(), attributeType)) continue;
            return attribute;
        }
        return null;
    }

    private ArrayList<Attribute> getAttributeList() {
        return this._attributeList;
    }

    public Attribute[] getAttributes() {
        return this.getAttributeList().toArray(new Attribute[0]);
    }

    public byte[] getBytes() {
        ByteCollection bytes = new ByteCollection();
        byte method = Message.getMethod(super.getClass().getSuperclass());
        if (method == 0) {
            throw new RuntimeException(new Exception("Message method unknown. See Message.RegisterMessage to register the message method."));
        }
        byte[] typeBytes = Message.getTypeBytes(method, this.getMessageType());
        FingerprintAttribute attribute = null;
        MessageIntegrityAttribute attribute2 = null;
        ByteCollection collection = new ByteCollection();
        for (Attribute attribute3 : this.getAttributes()) {
            if (attribute3 instanceof FingerprintAttribute) {
                attribute = (FingerprintAttribute)attribute3;
                continue;
            }
            if (attribute3 instanceof MessageIntegrityAttribute) {
                attribute2 = (MessageIntegrityAttribute)attribute3;
                continue;
            }
            collection.addRange(attribute3.getBytes());
        }
        bytes.addRange(typeBytes);
        int count = collection.getCount();
        byte[] buffer = Binary.toBytes16(count, false);
        bytes.addRange(buffer);
        bytes.addRange(Message.getMagicCookie());
        bytes.addRange(this.getTransactionId());
        bytes.addRange(collection);
        if (attribute2 != null) {
            buffer = Binary.toBytes16(count += 24, false);
            bytes.removeRange(2, 2);
            bytes.insertRange(2, buffer);
            bytes.addRange(attribute2.getBytes(bytes.toArray()));
        }
        if (attribute != null) {
            buffer = Binary.toBytes16(count += 8, false);
            bytes.removeRange(2, 2);
            bytes.insertRange(2, buffer);
            bytes.addRange(attribute.getBytes(bytes.toArray()));
        }
        return bytes.toArray();
    }

    public ChannelNumberAttribute getChannelNumber() {
        return (ChannelNumberAttribute)this.getAttribute(ChannelNumberAttribute.class);
    }

    public ConnectionIdAttribute getConnectionId() {
        return (ConnectionIdAttribute)this.getAttribute(ConnectionIdAttribute.class);
    }

    public DataAttribute getData() {
        return (DataAttribute)this.getAttribute(DataAttribute.class);
    }

    public DontFragmentAttribute getDontFragment() {
        return (DontFragmentAttribute)this.getAttribute(DontFragmentAttribute.class);
    }

    public ErrorCodeAttribute getErrorCode() {
        return (ErrorCodeAttribute)this.getAttribute(ErrorCodeAttribute.class);
    }

    public EvenPortAttribute getEvenPort() {
        return (EvenPortAttribute)this.getAttribute(EvenPortAttribute.class);
    }

    public FingerprintAttribute getFingerprint() {
        return (FingerprintAttribute)this.getAttribute(FingerprintAttribute.class);
    }

    public ControlledAttribute getIceControlled() {
        return (ControlledAttribute)this.getAttribute(ControlledAttribute.class);
    }

    public ControllingAttribute getIceControlling() {
        return (ControllingAttribute)this.getAttribute(ControllingAttribute.class);
    }

    public LifetimeAttribute getLifetime() {
        return (LifetimeAttribute)this.getAttribute(LifetimeAttribute.class);
    }

    public static byte[] getMagicCookie() {
        return _magicCookie;
    }

    public MappedAddressAttribute getMappedAddress() {
        return (MappedAddressAttribute)this.getAttribute(MappedAddressAttribute.class);
    }

    public MessageIntegrityAttribute getMessageIntegrity() {
        return (MessageIntegrityAttribute)this.getAttribute(MessageIntegrityAttribute.class);
    }

    public MessageType getMessageType() {
        return this._messageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte getMethod(Class type) {
        Object object = _registeredMessagesLock;
        synchronized (object) {
            MessageRegistration registration = null;
            Holder<Object> _var0 = new Holder<Object>(registration);
            boolean _var1 = HashMapExtensions.tryGetValue(_registeredMessages, ClassExtensions.getFullName(type), _var0);
            registration = _var0.getValue();
            if (_var1) {
                return registration.getMethod();
            }
        }
        Class baseType = type.getSuperclass();
        if (baseType != null) {
            return Message.getMethod(baseType);
        }
        return 0;
    }

    public NonceAttribute getNonce() {
        return (NonceAttribute)this.getAttribute(NonceAttribute.class);
    }

    public PriorityAttribute getPriority() {
        return (PriorityAttribute)this.getAttribute(PriorityAttribute.class);
    }

    public RealmAttribute getRealm() {
        return (RealmAttribute)this.getAttribute(RealmAttribute.class);
    }

    public RequestedAddressFamilyAttribute getRequestedAddressFamily() {
        return (RequestedAddressFamilyAttribute)this.getAttribute(RequestedAddressFamilyAttribute.class);
    }

    public RequestedTransportAttribute getRequestedTransport() {
        return (RequestedTransportAttribute)this.getAttribute(RequestedTransportAttribute.class);
    }

    public ReservationTokenAttribute getReservationToken() {
        return (ReservationTokenAttribute)this.getAttribute(ReservationTokenAttribute.class);
    }

    public SoftwareAttribute getSoftware() {
        return (SoftwareAttribute)this.getAttribute(SoftwareAttribute.class);
    }

    public byte[] getTransactionId() {
        return this._transactionId;
    }

    private static byte[] getTypeBytes(byte method, MessageType messageType) {
        byte[] buffer = new byte[2];
        buffer[0] = Global.equals((Object)messageType, (Object)MessageType.Request) || Global.equals((Object)messageType, (Object)MessageType.Indication) ? (byte)0 : 1;
        if (Global.equals((Object)messageType, (Object)MessageType.Request) || Global.equals((Object)messageType, (Object)MessageType.SuccessResponse)) {
            buffer[1] = method;
            return buffer;
        }
        buffer[1] = (byte)(method | 0x10);
        return buffer;
    }

    public UnknownAttributesAttribute getUnknownAttributes() {
        return (UnknownAttributesAttribute)this.getAttribute(UnknownAttributesAttribute.class);
    }

    public UseCandidateAttribute getUseCandidate() {
        return (UseCandidateAttribute)this.getAttribute(UseCandidateAttribute.class);
    }

    public UsernameAttribute getUsername() {
        return (UsernameAttribute)this.getAttribute(UsernameAttribute.class);
    }

    public XorMappedAddressAttribute getXorMappedAddress() {
        return (XorMappedAddressAttribute)this.getAttribute(XorMappedAddressAttribute.class);
    }

    public XorPeerAddressAttribute getXorPeerAddress() {
        return (XorPeerAddressAttribute)this.getAttribute(XorPeerAddressAttribute.class);
    }

    public XorRelayedAddressAttribute getXorRelayedAddress() {
        return (XorRelayedAddressAttribute)this.getAttribute(XorRelayedAddressAttribute.class);
    }

    protected Message(MessageType messageType, byte[] transactionId) {
        if (ArrayExtensions.getLength(transactionId) != 12) {
            throw new RuntimeException(new Exception("transactionId must be exactly 12 bytes."));
        }
        this.setMessageType(messageType);
        this.setTransactionId(transactionId);
        this.setAttributeList(new ArrayList<Attribute>());
    }

    public static Message parseBytes(byte[] bytes, IntegerHolder length) {
        if (bytes == null || ArrayExtensions.getLength(bytes) < 20 || BitAssistant.castInteger(bytes[0]) > 1) {
            length.setValue(0);
            return null;
        }
        byte[] buffer = BitAssistant.subArray(bytes, 0, 2);
        byte method = (byte)(buffer[1] & 0xF);
        byte num2 = (byte)(buffer[0] & 1);
        byte num3 = (byte)(buffer[1] & 0x10);
        MessageType request = MessageType.Request;
        if (num2 == 1 && num3 == 0) {
            request = MessageType.SuccessResponse;
        } else if (num2 == 1 && num3 == 16) {
            request = MessageType.ErrorResponse;
        } else if (num2 == 0 && num3 == 16) {
            request = MessageType.Indication;
        }
        int count = Binary.fromBytes16(BitAssistant.subArray(bytes, 2, 2), 0, false);
        length.setValue(20 + count);
        if (length.getValue() > ArrayExtensions.getLength(bytes)) {
            return null;
        }
        byte[] buffer3 = BitAssistant.subArray(bytes, 4, 4);
        for (int i = 0; i < ArrayExtensions.getLength(Message.getMagicCookie()); ++i) {
            if (Message.getMagicCookie()[i] == buffer3[i]) continue;
            return null;
        }
        byte[] transactionId = BitAssistant.subArray(bytes, 8, 12);
        Message message = Message.createMessage(method, request, transactionId);
        message.setTransactionId(transactionId);
        byte[] array = BitAssistant.subArray(bytes, 20, count);
        int offset = 0;
        int num7;
        block1: while ((num7 = Attribute.getLength(BitAssistant.subArray(array, offset))) != -1) {
            int num8 = num7 + 4;
            ByteCollection bytes2 = new ByteCollection(BitAssistant.subArray(bytes, 0, 20 + offset));
            int num9 = offset + num8;
            while (num9 % 4 > 0) {
                ++num9;
            }
            byte[] buffer6 = Binary.toBytes16(num9, false);
            bytes2.removeRange(2, 2);
            bytes2.insertRange(2, buffer6);
            Attribute attribute = Attribute.parseBytes(BitAssistant.subArray(array, offset, num8), transactionId, bytes2.toArray());
            if (attribute != null) {
                message.setAttribute(attribute);
            }
            offset += num8;
            while (true) {
                if (offset % 4 <= 0) continue block1;
                ++offset;
            }
            break;
        }
        return message;
    }

    public static Message parseBytes(byte[] bytes) {
        int length = 0;
        IntegerHolder _var0 = new IntegerHolder(length);
        Message _var1 = Message.parseBytes(bytes, _var0);
        length = _var0.getValue();
        return _var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerMessage(Class type, byte method, IFunction1<MessageCreationArgs, Message> creationDelegate) {
        Object object = _registeredMessagesLock;
        synchronized (object) {
            HashMapExtensions.set(HashMapExtensions.getItem(_registeredMessages), ClassExtensions.getFullName(type), new MessageRegistration(method, creationDelegate));
        }
    }

    public void setAlternateServer(AlternateServerAttribute attribute) {
        this.setAttribute(attribute);
    }

    private <T extends Attribute> void setAttribute(T attribute) {
        for (int i = 0; i < ArrayListExtensions.getCount(this.getAttributeList()); ++i) {
            Attribute attribute2 = ArrayListExtensions.getItem(this.getAttributeList()).get(i);
            if (!Global.equals(attribute2.getClass(), attribute.getClass())) continue;
            ArrayListExtensions.removeAt(this.getAttributeList(), i);
            --i;
        }
        this.getAttributeList().add(attribute);
    }

    private void setAttributeList(ArrayList<Attribute> value) {
        this._attributeList = value;
    }

    public void setChannelNumber(ChannelNumberAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setConnectionId(ConnectionIdAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setData(DataAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setDontFragment(DontFragmentAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setErrorCode(ErrorCodeAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setEvenPort(EvenPortAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setFingerprint(FingerprintAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setIceControlled(ControlledAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setIceControlling(ControllingAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setLifetime(LifetimeAttribute attribute) {
        this.setAttribute(attribute);
    }

    private static void setMagicCookie(byte[] value) {
        _magicCookie = value;
    }

    public void setMappedAddress(MappedAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setMessageIntegrity(MessageIntegrityAttribute attribute) {
        this.setAttribute(attribute);
    }

    private void setMessageType(MessageType value) {
        this._messageType = value;
    }

    public void setNonce(NonceAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setPriority(PriorityAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setRealm(RealmAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setRequestedAddressFamily(RequestedAddressFamilyAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setRequestedTransport(RequestedTransportAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setReservationToken(ReservationTokenAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setSoftware(SoftwareAttribute attribute) {
        this.setAttribute(attribute);
    }

    private void setTransactionId(byte[] value) {
        this._transactionId = value;
    }

    public void setUnknownAttributes(UnknownAttributesAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setUseCandidate(UseCandidateAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setUsername(UsernameAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setXorMappedAddress(XorMappedAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setXorPeerAddress(XorPeerAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    public void setXorRelayedAddress(XorRelayedAddressAttribute attribute) {
        this.setAttribute(attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unregisterMessage(Class type) {
        Object object = _registeredMessagesLock;
        synchronized (object) {
            return HashMapExtensions.remove(_registeredMessages, ClassExtensions.getFullName(type));
        }
    }

    static {
        _registeredMessages = new HashMap();
        _registeredMessagesLock = new Object();
        Message.setMagicCookie(new byte[]{33, 18, -92, 66});
        byte method = 1;
        Message.registerMessage(BindingMessage.class, method, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createBindingMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createBindingMessage(e);
            }
        });
        byte num2 = 3;
        byte num3 = 4;
        byte num4 = 6;
        byte num5 = 7;
        byte num6 = 8;
        byte num7 = 9;
        byte num8 = 10;
        byte num9 = 11;
        byte num10 = 12;
        Message.registerMessage(AllocateMessage.class, num2, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createAllocateMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createAllocateMessage(e);
            }
        });
        Message.registerMessage(RefreshMessage.class, num3, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createRefreshMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createRefreshMessage(e);
            }
        });
        Message.registerMessage(SendMessage.class, num4, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createSendMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createSendMessage(e);
            }
        });
        Message.registerMessage(DataMessage.class, num5, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createDataMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createDataMessage(e);
            }
        });
        Message.registerMessage(CreatePermissionMessage.class, num6, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createCreatePermissionMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createCreatePermissionMessage(e);
            }
        });
        Message.registerMessage(ChannelBindMessage.class, num7, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createChannelBindMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createChannelBindMessage(e);
            }
        });
        Message.registerMessage(ConnectMessage.class, num8, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createConnectMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createConnectMessage(e);
            }
        });
        Message.registerMessage(ConnectionBindMessage.class, num9, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createConnectionBindMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createConnectionBindMessage(e);
            }
        });
        Message.registerMessage(ConnectionAttemptMessage.class, num10, (IFunction1<MessageCreationArgs, Message>)new IFunctionDelegate1<MessageCreationArgs, Message>(){

            @Override
            public String getId() {
                return "fm.icelink.stun.Message.createConnectionAttemptMessage";
            }

            @Override
            public Message invoke(MessageCreationArgs e) {
                return Message.createConnectionAttemptMessage(e);
            }
        });
    }
}

