/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;
import fm.icelink.sdp.CryptoKeyMethod;
import fm.icelink.sdp.CryptoSuite;
import java.util.ArrayList;
import java.util.HashMap;

public class CryptoAttribute
extends Attribute {
    private String _cryptoSuite;
    private HashMap<String, String> _keyParams;
    private ArrayList<String> _sessionParams;
    private int _tag;

    public CryptoAttribute(int tag, String cryptoSuite) {
        super.setAttributeType(AttributeType.CryptoAttribute);
        this.setTag(tag);
        this.setCryptoSuite(cryptoSuite);
        this.setKeyParams(new HashMap<String, String>());
        this.setSessionParams(new ArrayList<String>());
    }

    private CryptoAttribute() {
    }

    public static CryptoAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        int num2 = ParseAssistant.parseIntegerValue(StringExtensions.substring(value, 0, index));
        value = value.substring(index + 1);
        index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        String str = StringExtensions.substring(value, 0, index);
        value = value.substring(index + 1);
        HashMap<String, String> dictionary = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        index = StringExtensions.indexOf(value, " ", StringComparison.InvariantCulture);
        if (index == -1) {
            String[] strArray;
            for (String str2 : strArray = StringExtensions.split(value, new char[]{';'})) {
                Object[] strArray2 = StringExtensions.split(str2, new char[]{':'});
                if (ArrayExtensions.getLength(strArray2) != 2) continue;
                HashMapExtensions.set(HashMapExtensions.getItem(dictionary), strArray2[0], strArray2[1]);
            }
        } else {
            String[] strArray3;
            String[] strArray;
            for (String str2 : strArray = StringExtensions.split(StringExtensions.substring(value, 0, index), new char[]{';'})) {
                Object[] strArray2 = StringExtensions.split(str2, new char[]{':'});
                if (ArrayExtensions.getLength(strArray2) != 2) continue;
                HashMapExtensions.set(HashMapExtensions.getItem(dictionary), strArray2[0], strArray2[1]);
            }
            value = value.substring(index + 1);
            for (String str3 : strArray3 = StringExtensions.split(value, new char[]{' '})) {
                list.add(str3);
            }
        }
        CryptoAttribute attribute = new CryptoAttribute();
        attribute.setTag(num2);
        attribute.setCryptoSuite(str);
        attribute.setKeyParams(dictionary);
        attribute.setSessionParams(list);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getTag()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getCryptoSuite());
        for (String str : HashMapExtensions.getKeys(this.getKeyParams())) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, str);
            StringBuilderExtensions.append(builder, ":");
            StringBuilderExtensions.append(builder, HashMapExtensions.getItem(this.getKeyParams()).get(str));
        }
        for (String str2 : this.getSessionParams()) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, str2);
        }
        return builder.toString();
    }

    public String getCryptoSuite() {
        return this._cryptoSuite;
    }

    public DataBuffer getKey() {
        if (!Global.equals(this.getCryptoSuite(), CryptoSuite.getAesCM128HmacSha180()) && !Global.equals(this.getCryptoSuite(), CryptoSuite.getAesCm128HmacSha132())) {
            throw new RuntimeException(new Exception(StringExtensions.format("Unrecognized crypto-suite: {0}.", this.getCryptoSuite())));
        }
        byte[] array = Base64.decode(HashMapExtensions.getItem(this.getKeyParams()).get(CryptoKeyMethod.getInline()));
        if (ArrayExtensions.getLength(array) != 30) {
            throw new RuntimeException(new Exception("Unexpected key/salt length."));
        }
        return DataBuffer.wrap(BitAssistant.subArray(array, 0, 16));
    }

    public HashMap<String, String> getKeyParams() {
        return this._keyParams;
    }

    public DataBuffer getSalt() {
        if (!Global.equals(this.getCryptoSuite(), CryptoSuite.getAesCM128HmacSha180()) && !Global.equals(this.getCryptoSuite(), CryptoSuite.getAesCm128HmacSha132())) {
            throw new RuntimeException(new Exception(StringExtensions.format("Unrecognized crypto-suite: {0}.", this.getCryptoSuite())));
        }
        byte[] array = Base64.decode(HashMapExtensions.getItem(this.getKeyParams()).get(CryptoKeyMethod.getInline()));
        if (ArrayExtensions.getLength(array) != 30) {
            throw new RuntimeException(new Exception("Unexpected key/salt length."));
        }
        return DataBuffer.wrap(BitAssistant.subArray(array, 16, 14));
    }

    public ArrayList<String> getSessionParams() {
        return this._sessionParams;
    }

    public int getTag() {
        return this._tag;
    }

    private void setCryptoSuite(String value) {
        this._cryptoSuite = value;
    }

    private void setKeyParams(HashMap<String, String> value) {
        this._keyParams = value;
    }

    public CryptoAttribute setKeySalt(byte[] key, byte[] salt) {
        int num;
        byte[] b = new byte[ArrayExtensions.getLength(key) + ArrayExtensions.getLength(salt)];
        for (num = 0; num < ArrayExtensions.getLength(key); ++num) {
            b[num] = key[num];
        }
        for (num = 0; num < ArrayExtensions.getLength(salt); ++num) {
            b[ArrayExtensions.getLength((byte[])key) + num] = salt[num];
        }
        HashMapExtensions.set(HashMapExtensions.getItem(this.getKeyParams()), CryptoKeyMethod.getInline(), Base64.encode(b));
        return this;
    }

    private void setSessionParams(ArrayList<String> value) {
        this._sessionParams = value;
    }

    public void setTag(int value) {
        this._tag = value;
    }
}

