/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.AddressType;
import fm.icelink.sdp.NetworkType;

public class ConnectionData {
    private String _addressType;
    private String _connectionAddress;
    private String _networkType;

    public ConnectionData(String connectionAddress) {
        if (connectionAddress == null) {
            throw new RuntimeException(new Exception("connectionAddress cannot be null."));
        }
        this.update(connectionAddress);
    }

    public String getAddressType() {
        return this._addressType;
    }

    public String getConnectionAddress() {
        return this._connectionAddress;
    }

    public String getNetworkType() {
        return this._networkType;
    }

    public static ConnectionData parse(String s) {
        s = s.substring(2);
        String[] strArray = StringExtensions.split(s, new char[]{' '});
        String connectionAddress = strArray[2];
        ConnectionData data = new ConnectionData(connectionAddress);
        data.setNetworkType(strArray[0]);
        data.setAddressType(strArray[1]);
        return data;
    }

    private void setAddressType(String value) {
        this._addressType = value;
    }

    private void setConnectionAddress(String value) {
        this._connectionAddress = value;
    }

    private void setNetworkType(String value) {
        this._networkType = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, "c=");
        StringBuilderExtensions.append(builder, this.getNetworkType());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getAddressType());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getConnectionAddress());
        return builder.toString();
    }

    public void update(String connectionAddress) {
        this.setNetworkType(NetworkType.getInternet());
        this.setAddressType(AddressType.getAddressTypeForAddress(connectionAddress));
        this.setConnectionAddress(connectionAddress);
    }
}

