/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.FecConfig;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISink;
import fm.icelink.ISource;
import fm.icelink.IVideoElement;
import fm.icelink.IVideoPipe;
import fm.icelink.IVideoSink;
import fm.icelink.IVideoSinkCollection;
import fm.icelink.IVideoSource;
import fm.icelink.IVideoSourceCollection;
import fm.icelink.JitterConfig;
import fm.icelink.MediaStream;
import fm.icelink.NackConfig;
import fm.icelink.StreamType;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferCollection;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFormatCollection;
import fm.icelink.VideoFrame;
import fm.icelink.sdp.rtp.MapAttribute;

public class VideoStream
extends MediaStream<IVideoSource, IVideoSourceCollection, IVideoSink, IVideoSinkCollection, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat, VideoFormatCollection>
implements IVideoPipe,
IVideoSource,
IMediaSource<IVideoSource, IVideoSink, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
ISource<IVideoSource, IVideoSink, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IVideoSink,
IMediaSink<IVideoSource, IVideoSink, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
ISink<IVideoSource, IVideoSink, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IVideoElement,
IMediaElement,
IElement {
    @Override
    protected VideoFormat createFormat(String name, int clockRate, String parameters, int payloadType) {
        VideoFormat format = new VideoFormat(name, clockRate);
        format.setRegisteredPayloadType(payloadType);
        format.setIsPacketized(true);
        return format;
    }

    @Override
    protected VideoFormat createFormat(MapAttribute attribute) {
        return this.createFormat(attribute.getFormatName(), attribute.getClockRate(), attribute.getFormatParameters(), attribute.getPayloadType());
    }

    @Override
    protected VideoFormatCollection createMediaFormatCollection() {
        return new VideoFormatCollection();
    }

    @Override
    protected IVideoSinkCollection createSinkCollection(IVideoSource source) {
        return new IVideoSinkCollection(source);
    }

    @Override
    protected IVideoSourceCollection createSourceCollection(IVideoSink sink) {
        return new IVideoSourceCollection(sink);
    }

    public VideoStream() {
        this(new IVideoSource[0]);
    }

    public VideoStream(IVideoSource[] sources, IVideoSink[] sinks) {
        super(StreamType.Video, new NackConfig(), new JitterConfig(), new FecConfig());
        super.addSources((IMediaSource[])sources);
        super.addSinks((IMediaSink[])sinks);
    }

    public VideoStream(IVideoSource[] sources) {
        this(sources, null);
    }

    public VideoStream(IVideoSource source) {
        IVideoSource[] iVideoSourceArray;
        if (source == null) {
            iVideoSourceArray = null;
        } else {
            IVideoSource[] iVideoSourceArray2 = new IVideoSource[1];
            iVideoSourceArray = iVideoSourceArray2;
            iVideoSourceArray2[0] = source;
        }
        this(iVideoSourceArray);
    }

    public VideoStream(IVideoSink sink) {
        IVideoSink[] iVideoSinkArray;
        if (sink == null) {
            iVideoSinkArray = null;
        } else {
            IVideoSink[] iVideoSinkArray2 = new IVideoSink[1];
            iVideoSinkArray = iVideoSinkArray2;
            iVideoSinkArray2[0] = sink;
        }
        this(iVideoSinkArray);
    }

    public VideoStream(IVideoSource source, IVideoSink sink) {
        IVideoSink[] iVideoSinkArray;
        IVideoSource[] iVideoSourceArray;
        if (source == null) {
            iVideoSourceArray = null;
        } else {
            IVideoSource[] iVideoSourceArray2 = new IVideoSource[1];
            iVideoSourceArray = iVideoSourceArray2;
            iVideoSourceArray2[0] = source;
        }
        if (sink == null) {
            iVideoSinkArray = null;
        } else {
            IVideoSink[] iVideoSinkArray2 = new IVideoSink[1];
            iVideoSinkArray = iVideoSinkArray2;
            iVideoSinkArray2[0] = sink;
        }
        this(iVideoSourceArray, iVideoSinkArray);
    }

    public VideoStream(IVideoSink[] sinks) {
        this(null, sinks);
    }
}

