/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFormat;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBufferColor;
import fm.icelink.VideoFormat;

public class VideoBuffer
extends MediaBuffer<VideoFormat, VideoBuffer> {
    private int __height;
    private boolean __isMuted;
    private int __orientation = 0;
    private int __width;
    private int[] _strides;

    @Override
    public VideoBuffer clone() {
        VideoBuffer buffer = (VideoBuffer)super.clone();
        buffer.setStrides(this.getStrides());
        buffer.setWidth(this.getWidth());
        buffer.setHeight(this.getHeight());
        buffer.setOrientation(this.getOrientation());
        buffer.__isMuted = this.__isMuted;
        return buffer;
    }

    public static VideoBuffer createBlack(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 0, formatName);
    }

    public static VideoBuffer createBlue(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 255, formatName);
    }

    public static VideoBuffer createCustom(int width, int height, int red, int green, int blue, String formatName) {
        if (Global.equals(formatName, VideoFormat.getBgrName())) {
            int num = width * height;
            DataBuffer dataBuffer = DataBuffer.allocate(num * 3);
            int num2 = 0;
            byte num3 = (byte)red;
            byte num4 = (byte)green;
            byte num5 = (byte)blue;
            if (num3 == num4 && num3 == num5) {
                BitAssistant.set(dataBuffer.getData(), 0, dataBuffer.getLength(), num3);
            } else {
                for (int i = 0; i < num; ++i) {
                    dataBuffer.write8(num5, num2++);
                    dataBuffer.write8(num4, num2++);
                    dataBuffer.write8(num3, num2++);
                }
            }
            return new VideoBuffer(width, height, dataBuffer, new VideoFormat(formatName));
        }
        Log.error(StringExtensions.concat("Format not supported: ", formatName));
        return null;
    }

    public static VideoBuffer createCyan(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 255, 255, formatName);
    }

    public static VideoBuffer createDarkBlue(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 128, formatName);
    }

    public static VideoBuffer createDarkGreen(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 128, 0, formatName);
    }

    public static VideoBuffer createDarkRed(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 0, 0, formatName);
    }

    public static VideoBuffer createGray(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 128, 128, formatName);
    }

    public static VideoBuffer createGreen(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 255, 0, formatName);
    }

    @Override
    protected VideoBuffer createInstance() {
        return new VideoBuffer();
    }

    public static VideoBuffer createMagenta(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 0, 255, formatName);
    }

    public static VideoBuffer createOlive(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 128, 0, formatName);
    }

    public static VideoBuffer createPurple(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 0, 128, formatName);
    }

    public static VideoBuffer createRed(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 0, 0, formatName);
    }

    public static VideoBuffer createTeal(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 128, 128, formatName);
    }

    public static VideoBuffer createWhite(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 255, 255, formatName);
    }

    public static VideoBuffer createYellow(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 255, 0, formatName);
    }

    private void drawAbgrPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(0, offset);
        dataBuffer.write8(color.getB(), offset + 1);
        dataBuffer.write8(color.getG(), offset + 2);
        dataBuffer.write8(color.getR(), offset + 3);
    }

    private void drawArgbPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(0, offset);
        dataBuffer.write8(color.getR(), offset + 1);
        dataBuffer.write8(color.getG(), offset + 2);
        dataBuffer.write8(color.getB(), offset + 3);
    }

    private void drawBgraPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(color.getB(), offset);
        dataBuffer.write8(color.getG(), offset + 1);
        dataBuffer.write8(color.getR(), offset + 2);
        dataBuffer.write8(0, offset + 3);
    }

    private void drawBgrPixel(int x, int y, VideoBufferColor color) {
        DataBuffer buffer = super.getDataBuffers()[0];
        int num = this.getStrides()[0];
        if (y * num + x * 3 + 2 >= buffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        buffer.write8(color.getB(), y * num + x * 3);
        buffer.write8(color.getG(), y * num + x * 3 + 1);
        buffer.write8(color.getR(), y * num + x * 3 + 2);
    }

    public void drawEllipse(int x, int y, int width, int height, VideoBufferColor color, boolean fill) {
        this.sanityChecks(x, y, width, height);
        int num = height / 2;
        int num2 = x + width / 2;
        int num3 = y + height / 2;
        double num4 = 2.0 * MathAssistant.getPi() / (double)(width * height / 4);
        for (double i = 0.0; i < 2.0 * MathAssistant.getPi(); i += num4) {
            int num6 = num2 + (int)((double)num * MathAssistant.cos(i));
            int num7 = num3 - (int)((double)num * MathAssistant.sin(i));
            if (fill) {
                int num8;
                if (num2 < num6) {
                    for (num8 = num2; num8 < num6; ++num8) {
                        this.drawPixel(num8, num7, color);
                    }
                    continue;
                }
                for (num8 = num6; num8 < num2; ++num8) {
                    this.drawPixel(num8, num7, color);
                }
                continue;
            }
            this.drawPixel(num6, num7, color);
        }
    }

    private void drawI420Pixel(int x, int y, VideoBufferColor color) {
        DataBuffer yBuffer = super.getDataBuffers()[0];
        DataBuffer uBuffer = super.getDataBuffers()[1];
        DataBuffer vBuffer = super.getDataBuffers()[2];
        int num = this.getStrides()[0];
        int num2 = this.getStrides()[1];
        int num3 = this.getStrides()[2];
        int yIndex = y * num + x;
        int uIndex = y / 2 * num2 + x / 2;
        int vIndex = y / 2 * num3 + x / 2;
        this.drawYuv(color, yBuffer, uBuffer, vBuffer, yIndex, uIndex, vIndex);
    }

    private void drawNv12Pixel(int x, int y, VideoBufferColor color) {
        DataBuffer yBuffer = super.getDataBuffers()[0];
        DataBuffer uBuffer = super.getDataBuffers()[1];
        int num = this.getStrides()[0];
        int num2 = this.getStrides()[1];
        int yIndex = y * num + x;
        int uIndex = y / 2 * num2 + x * 2;
        int vIndex = y / 2 * num2 + x * 2 + 1;
        this.drawYuv(color, yBuffer, uBuffer, uBuffer, yIndex, uIndex, vIndex);
    }

    private void drawNv21Pixel(int x, int y, VideoBufferColor color) {
        DataBuffer yBuffer = super.getDataBuffers()[0];
        DataBuffer uBuffer = super.getDataBuffers()[1];
        int num = this.getStrides()[0];
        int num2 = this.getStrides()[1];
        int yIndex = y * num + x;
        int uIndex = y / 2 * num2 + x * 2 + 1;
        int vIndex = y / 2 * num2 + x * 2;
        this.drawYuv(color, yBuffer, uBuffer, uBuffer, yIndex, uIndex, vIndex);
    }

    private void drawPixel(int x, int y, VideoBufferColor color) {
        if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getI420Name())) {
            this.drawI420Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getYv12Name())) {
            this.drawYv12Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv12Name())) {
            this.drawNv12Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv21Name())) {
            this.drawNv12Pixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgrName())) {
            this.drawBgrPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbName())) {
            this.drawRgbPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbaName())) {
            this.drawRgbaPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getArgbName())) {
            this.drawArgbPixel(x, y, color);
        } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgraName())) {
            this.drawBgraPixel(x, y, color);
        } else {
            if (!Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getAbgrName())) {
                throw new RuntimeException(new Exception("Unsupported video format."));
            }
            this.drawAbgrPixel(x, y, color);
        }
    }

    public void drawRectangle(int x, int y, int width, int height, VideoBufferColor color, boolean fill) {
        this.sanityChecks(x, y, width, height);
        if (fill) {
            for (int num = y; num < y + height; ++num) {
                for (int num2 = x; num2 < x + width; ++num2) {
                    this.drawPixel(num2, num, color);
                }
            }
        } else {
            for (int num = y; num <= y + height; ++num) {
                if (num == y || num == y + height) {
                    for (int num2 = x; num2 <= x + width; ++num2) {
                        this.drawPixel(num2, num, color);
                    }
                    continue;
                }
                this.drawPixel(x, num, color);
                this.drawPixel(x + width, num, color);
            }
        }
    }

    private void drawRgbaPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 3 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 4;
        dataBuffer.write8(color.getR(), offset);
        dataBuffer.write8(color.getG(), offset + 1);
        dataBuffer.write8(color.getB(), offset + 2);
        dataBuffer.write8(0, offset + 3);
    }

    private void drawRgbPixel(int x, int y, VideoBufferColor color) {
        DataBuffer dataBuffer = super.getDataBuffer();
        int stride = this.getStride();
        if (y * stride + x * 3 + 2 >= dataBuffer.getLength() || x >= this.getWidth()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        int offset = y * stride + x * 3;
        dataBuffer.write8(color.getR(), offset);
        dataBuffer.write8(color.getG(), offset + 1);
        dataBuffer.write8(color.getB(), offset + 2);
    }

    private void drawYuv(VideoBufferColor color, DataBuffer yBuffer, DataBuffer uBuffer, DataBuffer vBuffer, int yIndex, int uIndex, int vIndex) {
        if (yIndex >= yBuffer.getLength() || uIndex >= uBuffer.getLength() || vIndex >= vBuffer.getLength()) {
            throw new RuntimeException(new Exception("X and Y are outside the bounds of the VideoBuffer."));
        }
        yBuffer.write8(VideoBuffer.rgbToY(color.getR(), color.getG(), color.getB()), yIndex);
        uBuffer.write8(VideoBuffer.rgbToU(color.getR(), color.getG(), color.getB()), uIndex);
        vBuffer.write8(VideoBuffer.rgbToV(color.getR(), color.getG(), color.getB()), vIndex);
    }

    private void drawYv12Pixel(int x, int y, VideoBufferColor color) {
        DataBuffer yBuffer = super.getDataBuffers()[0];
        DataBuffer uBuffer = super.getDataBuffers()[2];
        DataBuffer vBuffer = super.getDataBuffers()[1];
        int num = this.getStrides()[0];
        int num2 = this.getStrides()[2];
        int num3 = this.getStrides()[1];
        int yIndex = y * num + x;
        int uIndex = y / 2 * num2 + x / 2;
        int vIndex = y / 2 * num3 + x / 2;
        this.drawYuv(color, yBuffer, uBuffer, vBuffer, yIndex, uIndex, vIndex);
    }

    private int[] getDefaultStrides(int width, VideoFormat format) {
        if (Global.equals(format.getName(), VideoFormat.getBgrName()) || Global.equals(format.getName(), VideoFormat.getRgbName())) {
            return new int[]{width * 3};
        }
        if (Global.equals(format.getName(), VideoFormat.getAbgrName()) || Global.equals(format.getName(), VideoFormat.getArgbName()) || Global.equals(format.getName(), VideoFormat.getBgraName()) || Global.equals(format.getName(), VideoFormat.getRgbaName())) {
            return new int[]{width * 4};
        }
        if (Global.equals(format.getName(), VideoFormat.getI420Name()) || Global.equals(format.getName(), VideoFormat.getYv12Name())) {
            return new int[]{width, width / 2, width / 2};
        }
        if (Global.equals(format.getName(), VideoFormat.getNv12Name()) || Global.equals(format.getName(), VideoFormat.getNv21Name())) {
            return new int[]{width, width};
        }
        if (!(Global.equals(format.getName(), VideoFormat.getVp8Name()) || Global.equals(format.getName(), VideoFormat.getVp9Name()) || Global.equals(format.getName(), VideoFormat.getH264Name()) || Global.equals(format.getName(), MediaFormat.getRedName()) || Global.equals(format.getName(), MediaFormat.getUlpFecName()))) {
            throw new RuntimeException(new Exception(StringExtensions.concat("Unsupported video format '", format.getName(), "'.")));
        }
        return new int[1];
    }

    public int getHeight() {
        return this.__height;
    }

    @Override
    public boolean getIsMuted() {
        return this.__isMuted;
    }

    public int getOrientation() {
        return this.__orientation;
    }

    public int getStride() {
        int[] strides = this.getStrides();
        if (strides == null) {
            return 0;
        }
        return strides[0];
    }

    public int[] getStrides() {
        return this._strides;
    }

    public int getWidth() {
        return this.__width;
    }

    @Override
    public boolean mute() {
        if (!this.__isMuted) {
            if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgrName()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbName())) {
                super.getDataBuffer().set((byte)0);
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getBgraName()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getRgbaName())) {
                DataBuffer dataBuffer = super.getDataBuffer();
                for (int num = 0; num < dataBuffer.getLength(); num += 4) {
                    dataBuffer.set((byte)0, num, 3);
                    dataBuffer.set(BitAssistant.castByte(255), num + 3, 1);
                }
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getAbgrName()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getArgbName())) {
                DataBuffer dataBuffer = super.getDataBuffer();
                for (int num = 0; num < dataBuffer.getLength(); num += 4) {
                    dataBuffer.set(BitAssistant.castByte(255), num, 1);
                    dataBuffer.set((byte)0, num + 1, 3);
                }
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getI420Name()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getYv12Name())) {
                DataBuffer[] dataBuffers = super.getDataBuffers();
                dataBuffers[0].set((byte)0);
                dataBuffers[1].set(BitAssistant.castByte(128));
                dataBuffers[2].set(BitAssistant.castByte(128));
            } else if (Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv12Name()) || Global.equals(((VideoFormat)super.getFormat()).getName(), VideoFormat.getNv21Name())) {
                DataBuffer[] dataBuffers = super.getDataBuffers();
                dataBuffers[0].set((byte)0);
                dataBuffers[1].set(BitAssistant.castByte(128));
            } else {
                return false;
            }
            this.__isMuted = true;
        }
        return true;
    }

    private static byte rgbToU(int R, int G, int B) {
        return (byte)(-0.147 * (double)R - 0.289 * (double)G + 0.436 * (double)B);
    }

    private static byte rgbToV(int R, int G, int B) {
        return (byte)(0.615 * (double)R - 0.515 * (double)G - 0.1 * (double)B);
    }

    private static byte rgbToY(int R, int G, int B) {
        return (byte)(0.299 * (double)R + 0.587 * (double)G + 0.114 * (double)B);
    }

    private void sanityChecks(int x, int y, int width, int height) {
        if (x < 0 || x + width >= this.getWidth()) {
            throw new RuntimeException(new Exception("Invalid X"));
        }
        if (y < 0 || y + height >= this.getHeight()) {
            throw new RuntimeException(new Exception("Invalid Y"));
        }
    }

    public void setHeight(int value) {
        if (value != -1 && value % 2 > 0) {
            --value;
        }
        this.__height = value;
    }

    public void setOrientation(int value) {
        if (value != 0 && value != 90 && value != 180 && value != 270) {
            throw new RuntimeException(new Exception("Video orientation can only be 0, 90, 180 or 270."));
        }
        this.__orientation = value;
    }

    public void setStride(int value) {
        this.setStrides(new int[]{value});
    }

    public void setStrides(int[] value) {
        this._strides = value;
    }

    public void setWidth(int value) {
        if (value != -1 && value % 2 > 0) {
            --value;
        }
        this.__width = value;
    }

    public VideoBuffer(int width, int height, DataBuffer dataBuffer, VideoFormat format) {
        super(dataBuffer, format);
        this.setWidth(width);
        this.setHeight(height);
        this.setStrides(this.getDefaultStrides(width, format));
    }

    public VideoBuffer(int width, int height, DataBuffer[] dataBuffers, VideoFormat format) {
        super(dataBuffers, format);
        this.setWidth(width);
        this.setHeight(height);
        this.setStrides(this.getDefaultStrides(width, format));
    }

    private VideoBuffer() {
    }
}

