/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.Crypto;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerHolder;

class SctpStateCookie {
    private int _destinationPort;
    private long _lastReceivedTsnFromPeer;
    private long _myVerificationTag;
    private int _numberOfOutboundStreams;
    private long _peerReceiverWindowCredit;
    private long _peerVerificationTag;
    private byte[] _secretKey;
    private long _timestamp;

    public static byte[] getBytes(SctpStateCookie cookie) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes64(cookie.getTimestamp(), false));
        bytes.addRange(Binary.toBytes32(cookie.getMyVerificationTag(), false));
        bytes.addRange(Binary.toBytes32(cookie.getPeerVerificationTag(), false));
        bytes.addRange(Binary.toBytes32(cookie.getPeerReceiverWindowCredit(), false));
        bytes.addRange(Binary.toBytes32(cookie.getLastReceivedTsnFromPeer(), false));
        bytes.addRange(Binary.toBytes16(cookie.getNumberOfOutboundStreams(), false));
        bytes.addRange(Binary.toBytes16(cookie.getDestinationPort(), false));
        bytes.addRange(Crypto.getHmacMd5(cookie.getSecretKey(), DataBuffer.wrap(bytes.toArray())));
        return bytes.toArray();
    }

    public byte[] getBytes() {
        return SctpStateCookie.getBytes(this);
    }

    public int getDestinationPort() {
        return this._destinationPort;
    }

    public long getLastReceivedTsnFromPeer() {
        return this._lastReceivedTsnFromPeer;
    }

    public long getMyVerificationTag() {
        return this._myVerificationTag;
    }

    public int getNumberOfOutboundStreams() {
        return this._numberOfOutboundStreams;
    }

    public long getPeerReceiverWindowCredit() {
        return this._peerReceiverWindowCredit;
    }

    public long getPeerVerificationTag() {
        return this._peerVerificationTag;
    }

    public byte[] getSecretKey() {
        return this._secretKey;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public static SctpStateCookie parseBytes(byte[] value, int startIndex, IntegerHolder offsetPlus, byte[] secretKey) {
        byte[] destination = new byte[ArrayExtensions.getLength(value) - startIndex];
        BitAssistant.copy(value, startIndex, destination, 0, ArrayExtensions.getLength(destination));
        SctpStateCookie _var0 = SctpStateCookie.parseBytes(destination, offsetPlus, secretKey);
        return _var0;
    }

    public static SctpStateCookie parseBytes(byte[] bytes, IntegerHolder offsetPlus, byte[] secretKey) {
        long timestamp = Binary.fromBytes64(bytes, 0, false);
        long myVTag = Binary.fromBytes32(bytes, 8, false);
        long peerVTag = Binary.fromBytes32(bytes, 12, false);
        long peerReceiverWindowCredit = Binary.fromBytes32(bytes, 16, false);
        long lastReceivedTsnFromPeer = Binary.fromBytes32(bytes, 20, false);
        int outboundStreams = Binary.fromBytes16(bytes, 24, false);
        int destinationPort = Binary.fromBytes16(bytes, 26, false);
        byte[] destination = new byte[28];
        BitAssistant.copy(bytes, 0, destination, 0, ArrayExtensions.getLength(destination));
        byte[] buffer2 = Crypto.getHmacMd5(secretKey, DataBuffer.wrap(destination));
        int length = ArrayExtensions.getLength(buffer2);
        destination = new byte[length];
        BitAssistant.copy(bytes, 28, destination, 0, ArrayExtensions.getLength(destination));
        if (BitAssistant.sequencesAreEqualConstantTime(destination, buffer2)) {
            offsetPlus.setValue(28 + length);
            return new SctpStateCookie(myVTag, peerVTag, peerReceiverWindowCredit, lastReceivedTsnFromPeer, outboundStreams, timestamp, secretKey, destinationPort);
        }
        offsetPlus.setValue(0);
        return null;
    }

    public SctpStateCookie(long myVTag, long peerVTag, long peerReceiverWindowCredit, long lastReceivedTsnFromPeer, int outboundStreams, long timestamp, byte[] secretKey, int destinationPort) {
        this.setMyVerificationTag(myVTag);
        this.setPeerVerificationTag(peerVTag);
        this.setPeerReceiverWindowCredit(peerReceiverWindowCredit);
        this.setLastReceivedTsnFromPeer(lastReceivedTsnFromPeer);
        this.setNumberOfOutboundStreams(outboundStreams);
        this.setTimestamp(timestamp);
        this.setSecretKey(secretKey);
        this.setDestinationPort(destinationPort);
    }

    public void setDestinationPort(int value) {
        this._destinationPort = value;
    }

    public void setLastReceivedTsnFromPeer(long value) {
        this._lastReceivedTsnFromPeer = value;
    }

    public void setMyVerificationTag(long value) {
        this._myVerificationTag = value;
    }

    public void setNumberOfOutboundStreams(int value) {
        this._numberOfOutboundStreams = value;
    }

    public void setPeerReceiverWindowCredit(long value) {
        this._peerReceiverWindowCredit = value;
    }

    public void setPeerVerificationTag(long value) {
        this._peerVerificationTag = value;
    }

    public void setSecretKey(byte[] value) {
        this._secretKey = value;
    }

    public void setTimestamp(long value) {
        this._timestamp = value;
    }
}

