/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AecContext;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioConfig;
import fm.icelink.AudioEncoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioPipe;
import fm.icelink.AudioSink;
import fm.icelink.AudioSource;
import fm.icelink.AudioTrack;
import fm.icelink.Global;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioSource;
import fm.icelink.IVideoSource;
import fm.icelink.LocalMedia;
import fm.icelink.Log;
import fm.icelink.SoundConverter;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoSource;
import fm.icelink.VideoTrack;
import fm.icelink.ViewSink;
import fm.icelink.pcma.Format;
import fm.icelink.pcmu.Encoder;
import fm.icelink.vp8.Packetizer;
import java.util.ArrayList;

public abstract class RtcLocalMedia<TView>
extends LocalMedia {
    private ArrayList<AudioSink> __audioRecorders;
    private AudioConfig __opusConfig = new AudioConfig(48000, 2);
    private AudioConfig __pcmaConfig;
    private AudioConfig __pcmuConfig = new AudioConfig(8000, 1);
    private ArrayList<VideoSink> __videoRecorders;
    private AecContext _aecContext;
    private boolean _audioDisabled;
    private Object _audioRecordingLock;
    private boolean _videoDisabled;
    private Object _videoRecordingLock;
    private ViewSink<TView> _viewSink;

    private void audioRecorderSource_OnDisabledChange(AudioPipe recorderSource) {
        if (super.getIsRecordingAudio() && !recorderSource.getDisabled()) {
            for (AudioSink sink : this.__audioRecorders) {
                sink.setDisabled(!recorderSource.hasSink(sink));
            }
        }
    }

    protected abstract AudioSink createAudioRecorder(AudioFormat var1);

    protected abstract AudioSource createAudioSource(AudioConfig var1);

    protected abstract VideoEncoder createH264Encoder();

    protected abstract VideoPipe createImageConverter(VideoFormat var1);

    protected abstract VideoPipe createImageScaler();

    protected abstract AudioEncoder createOpusEncoder(AudioConfig var1);

    protected AudioEncoder createPcmaEncoder(AudioConfig config) {
        return new fm.icelink.pcma.Encoder(config);
    }

    protected AudioEncoder createPcmuEncoder(AudioConfig config) {
        return new Encoder(config);
    }

    protected abstract VideoSink createVideoRecorder(VideoFormat var1);

    protected abstract VideoSource createVideoSource();

    protected abstract ViewSink<TView> createViewSink();

    protected abstract VideoEncoder createVp8Encoder();

    protected abstract VideoEncoder createVp9Encoder();

    @Override
    public void destroy() {
        if (!this.getAecDisabled()) {
            this.getAecContext().destroy();
        }
        for (AudioSink sink : this.__audioRecorders) {
            sink.destroy();
        }
        for (VideoSink sink2 : this.__videoRecorders) {
            sink2.destroy();
        }
        super.destroy();
    }

    public AecContext getAecContext() {
        return this._aecContext;
    }

    public boolean getAecDisabled() {
        return this.getAecContext() == null || this.getAudioDisabled();
    }

    public boolean getAudioDisabled() {
        return this._audioDisabled;
    }

    public IAudioSource[] getAudioOutputs() {
        return (IAudioSource[])super.getAudioTrack().getOutputs();
    }

    private AudioSink getAudioRecorder(AudioFormat inputFormat) {
        AudioSink item = this.createAudioRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__audioRecorders.add(item);
        }
        return item;
    }

    public boolean getVideoDisabled() {
        return this._videoDisabled;
    }

    public IVideoSource[] getVideoOutputs() {
        return (IVideoSource[])super.getVideoTrack().getOutputs();
    }

    private VideoSink getVideoRecorder(VideoFormat inputFormat) {
        VideoSink item = this.createVideoRecorder(inputFormat);
        if (item != null) {
            item.setDisabled(true);
            this.__videoRecorders.add(item);
        }
        return item;
    }

    public TView getView() {
        return this.getViewSink() == null ? null : (TView)this.getViewSink().getView();
    }

    public ViewSink<TView> getViewSink() {
        return this._viewSink;
    }

    public void initialize() {
        try {
            VideoTrack videoTrack;
            AudioTrack audioTrack;
            this.setViewSink(this.createViewSink());
            AudioEncoder next = this.createOpusEncoder(this.__opusConfig);
            AudioEncoder encoder2 = this.createPcmaEncoder(this.__pcmaConfig);
            AudioEncoder encoder3 = this.createPcmuEncoder(this.__pcmuConfig);
            AudioSink audioRecorder = this.getAudioRecorder(new fm.icelink.opus.Format(this.__opusConfig));
            AudioSink element = this.getAudioRecorder(new Format(this.__pcmaConfig));
            AudioSink sink3 = this.getAudioRecorder(new fm.icelink.pcmu.Format(this.__pcmuConfig));
            if (this.getAudioDisabled()) {
                audioTrack = new AudioTrack();
            } else {
                AudioTrack[] audioTrackArray = new AudioTrack[3];
                AudioTrack audioTrack2 = next != null ? (AudioTrack)((AudioTrack)new AudioTrack(new SoundConverter(this.__opusConfig)).next(next)).next(new AudioTrack[]{audioRecorder != null ? new AudioTrack(audioRecorder) : new AudioTrack(), new AudioTrack(new fm.icelink.opus.Packetizer(this.__opusConfig))}) : (audioTrackArray[0] = new AudioTrack());
                AudioTrack audioTrack3 = encoder3 != null ? (AudioTrack)((AudioTrack)new AudioTrack(new SoundConverter(this.__pcmuConfig)).next(encoder3)).next(new AudioTrack[]{sink3 != null ? new AudioTrack(sink3) : new AudioTrack(), new AudioTrack(new fm.icelink.pcmu.Packetizer(this.__pcmuConfig))}) : (audioTrackArray[1] = new AudioTrack());
                audioTrackArray[2] = encoder2 != null ? (AudioTrack)((AudioTrack)new AudioTrack(new SoundConverter(this.__pcmaConfig)).next(encoder2)).next(new AudioTrack[]{element != null ? new AudioTrack(element) : new AudioTrack(), new AudioTrack(new fm.icelink.pcma.Packetizer(this.__pcmaConfig))}) : new AudioTrack();
                audioTrack = (AudioTrack)((AudioTrack)((AudioTrack)new AudioTrack(this.createAudioSource(this.__opusConfig)).next(this.getAecDisabled() ? null : new SoundConverter(this.getAecContext().getProcessor().getConfig()))).next(this.getAecDisabled() ? null : this.getAecContext().getProcessor())).next(audioTrackArray);
            }
            this.addAudioTrack(audioTrack);
            VideoEncoder encoder4 = this.createVp8Encoder();
            VideoEncoder encoder5 = this.createVp9Encoder();
            VideoEncoder encoder6 = this.createH264Encoder();
            VideoSink videoRecorder = this.getVideoRecorder(new fm.icelink.vp8.Format());
            VideoSink sink5 = this.getVideoRecorder(new fm.icelink.vp9.Format());
            VideoSink sink6 = this.getVideoRecorder(new fm.icelink.h264.Format());
            if (this.getVideoDisabled()) {
                videoTrack = new VideoTrack();
            } else {
                VideoTrack[] videoTrackArray = new VideoTrack[4];
                VideoTrack videoTrack2 = videoTrackArray[0] = this.getViewSink() != null ? (VideoTrack)new VideoTrack(this.createImageConverter((VideoFormat)this.getViewSink().getInputFormat())).next(new VideoTrack[]{new VideoTrack(this.getViewSink())}) : new VideoTrack();
                VideoTrack videoTrack3 = encoder4 != null ? (VideoTrack)new VideoTrack(this.createImageConverter((VideoFormat)encoder4.getInputFormat())).next(new VideoTrack[]{(VideoTrack)new VideoTrack(encoder4).next(new VideoTrack[]{videoRecorder != null ? new VideoTrack(videoRecorder) : new VideoTrack(), new VideoTrack(new Packetizer())})}) : (videoTrackArray[1] = new VideoTrack());
                VideoTrack videoTrack4 = encoder6 != null ? (VideoTrack)new VideoTrack(this.createImageConverter((VideoFormat)encoder6.getInputFormat())).next(new VideoTrack[]{(VideoTrack)new VideoTrack(encoder6).next(new VideoTrack[]{sink6 != null ? new VideoTrack(sink6) : new VideoTrack(), new VideoTrack(new fm.icelink.h264.Packetizer())})}) : (videoTrackArray[2] = new VideoTrack());
                videoTrackArray[3] = encoder5 != null ? (VideoTrack)new VideoTrack(this.createImageConverter((VideoFormat)encoder5.getInputFormat())).next(new VideoTrack[]{(VideoTrack)new VideoTrack(encoder5).next(new VideoTrack[]{sink5 != null ? new VideoTrack(sink5) : new VideoTrack(), new VideoTrack(new fm.icelink.vp9.Packetizer())})}) : new VideoTrack();
                videoTrack = (VideoTrack)new VideoTrack(this.createVideoSource()).next(videoTrackArray);
            }
            this.addVideoTrack(videoTrack);
            for (AudioSink sink7 : this.__audioRecorders) {
                AudioPipe source = Global.tryCast(sink7.getSource(), AudioPipe.class);
                if (source == null) continue;
                source.addOnDisabledChange(new IActionDelegate1<AudioPipe>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.RtcLocalMedia<TView>.audioRecorderSource_OnDisabledChange";
                    }

                    @Override
                    public void invoke(AudioPipe recorderSource) {
                        RtcLocalMedia.this.audioRecorderSource_OnDisabledChange(recorderSource);
                    }
                });
            }
            for (VideoSink sink8 : this.__videoRecorders) {
                VideoPipe pipe2 = Global.tryCast(sink8.getSource(), VideoPipe.class);
                if (pipe2 == null) continue;
                pipe2.addOnDisabledChange(new IActionDelegate1<VideoPipe>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.RtcLocalMedia<TView>.videoRecorderSource_OnDisabledChange";
                    }

                    @Override
                    public void invoke(VideoPipe recorderSource) {
                        RtcLocalMedia.this.videoRecorderSource_OnDisabledChange(recorderSource);
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.error("Error initializing local media.", exception);
            throw new RuntimeException(exception);
        }
    }

    public RtcLocalMedia(boolean disableAudio, boolean disableVideo) {
        this(disableAudio, disableVideo, null);
    }

    public RtcLocalMedia(boolean disableAudio, boolean disableVideo, AecContext aecContext) {
        this.__pcmaConfig = new AudioConfig(8000, 1);
        this.__audioRecorders = new ArrayList();
        this.__videoRecorders = new ArrayList();
        this._audioRecordingLock = new Object();
        this._videoRecordingLock = new Object();
        this.setAudioDisabled(disableAudio);
        this.setVideoDisabled(disableVideo);
        this.setAecContext(aecContext);
    }

    public RtcLocalMedia() {
        this(false, false);
    }

    private void setAecContext(AecContext value) {
        this._aecContext = value;
    }

    private void setAudioDisabled(boolean value) {
        this._audioDisabled = value;
    }

    private void setVideoDisabled(boolean value) {
        this._videoDisabled = value;
    }

    private void setViewSink(ViewSink<TView> value) {
        this._viewSink = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleAudioRecording() {
        Object object = this._audioRecordingLock;
        synchronized (object) {
            super.setIsRecordingAudio(!super.getIsRecordingAudio());
            if (this.getViewSink() != null) {
                this.getViewSink().setIsRecording(super.getIsRecordingAudio() || super.getIsRecordingVideo());
            }
            if (ArrayExtensions.getLength(super.getAudioTrack().getOutputs()) > 0 && ((IAudioSource[])super.getAudioTrack().getOutputs())[0].getSink() != null) {
                if (super.getIsRecordingAudio()) {
                    for (AudioSink sink : this.__audioRecorders) {
                        if (Global.tryCast(sink.getSource(), AudioPipe.class).getDisabled()) continue;
                        sink.setDisabled(false);
                        break;
                    }
                } else {
                    for (AudioSink sink : this.__audioRecorders) {
                        sink.setDisabled(true);
                    }
                }
            } else {
                ArrayListExtensions.getItem(this.__audioRecorders).get(0).setDisabled(!super.getIsRecordingAudio());
            }
            return super.getIsRecordingAudio();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleVideoRecording() {
        Object object = this._videoRecordingLock;
        synchronized (object) {
            super.setIsRecordingVideo(!super.getIsRecordingVideo());
            if (this.getViewSink() != null) {
                this.getViewSink().setIsRecording(super.getIsRecordingAudio() || super.getIsRecordingVideo());
            }
            if (ArrayExtensions.getLength(super.getVideoTrack().getOutputs()) > 0 && ((IVideoSource[])super.getVideoTrack().getOutputs())[0].getSink() != null) {
                if (super.getIsRecordingVideo()) {
                    for (VideoSink sink : this.__videoRecorders) {
                        if (sink.getSource() == null || Global.tryCast(sink.getSource(), VideoPipe.class).getDisabled()) continue;
                        sink.setDisabled(false);
                        break;
                    }
                } else {
                    for (VideoSink sink : this.__videoRecorders) {
                        sink.setDisabled(true);
                    }
                }
            } else {
                ArrayListExtensions.getItem(this.__videoRecorders).get(0).setDisabled(!super.getIsRecordingVideo());
            }
            return super.getIsRecordingVideo();
        }
    }

    private void videoRecorderSource_OnDisabledChange(VideoPipe recorderSource) {
        if (super.getIsRecordingVideo() && !recorderSource.getDisabled()) {
            for (VideoSink sink : this.__videoRecorders) {
                sink.setDisabled(!recorderSource.hasSink(sink));
            }
        }
    }
}

