/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.ReliableChannelState;
import fm.icelink.ReliableReliableChannelType;
import fm.icelink.ReliableRtcDcepDataChannelAck;
import fm.icelink.ReliableRtcDcepDataChannelOpen;
import fm.icelink.ReliableRtcDcepMessage;
import fm.icelink.ReliableSctpRtcPayloadProtocolIdentifier;
import fm.icelink.SctpMessage;
import fm.icelink.SctpTransport;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import java.util.ArrayList;
import java.util.List;

class ReliableChannel {
    private List<IAction1<Exception>> __onError = new ArrayList<IAction1<Exception>>();
    private List<IAction1<DataBuffer>> __onReceiveBinary = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<String>> __onReceiveString = new ArrayList<IAction1<String>>();
    private List<IAction1<ReliableChannel>> __onStateChange = new ArrayList<IAction1<ReliableChannel>>();
    private ArrayList<SctpMessage> __outgoingBuffer;
    private ReliableChannelState __state;
    private Object __stateLock;
    private Error _error;
    private SctpTransport _innerTransport;
    private int _innerTransportStreamId;
    private String _label;
    private IAction1<Exception> _onError = new IAction1<Exception>(){

        @Override
        public void invoke(Exception p0) {
            for (IAction1 action : new ArrayList(ReliableChannel.this.__onError)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<DataBuffer> _onReceiveBinary = new IAction1<DataBuffer>(){

        @Override
        public void invoke(DataBuffer p0) {
            for (IAction1 action : new ArrayList(ReliableChannel.this.__onReceiveBinary)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<String> _onReceiveString = new IAction1<String>(){

        @Override
        public void invoke(String p0) {
            for (IAction1 action : new ArrayList(ReliableChannel.this.__onReceiveString)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<ReliableChannel> _onStateChange = new IAction1<ReliableChannel>(){

        @Override
        public void invoke(ReliableChannel p0) {
            for (IAction1 action : new ArrayList(ReliableChannel.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private boolean _ordered;
    private String _subProtocol;
    public static int _unset = -1;

    public void addOnError(IAction1<Exception> value) {
        this.__onError.add(value);
    }

    public void addOnReceiveBinary(IAction1<DataBuffer> value) {
        this.__onReceiveBinary.add(value);
    }

    public void addOnReceiveString(IAction1<String> value) {
        this.__onReceiveString.add(value);
    }

    public void addOnStateChange(IAction1<ReliableChannel> value) {
        this.__onStateChange.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.__stateLock;
        synchronized (object) {
            this.setState(ReliableChannelState.Closing);
            this.setState(ReliableChannelState.Closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error dispatch(DataBuffer buffer, long ppi, IAction0 onSuccess, IAction1<Exception> onFailure) {
        SctpMessage message2 = new SctpMessage(buffer, this.getInnerTransportStreamId());
        message2.setUnordered(!this.getOrdered());
        message2.setOnSuccess(onSuccess);
        message2.setOnFailure(onFailure);
        message2.setPayloadType(ppi);
        SctpMessage item = message2;
        Object object = this.__stateLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ReliableChannelState.New)) {
                this.__outgoingBuffer.add(item);
                item.setUnordered(false);
            } else if (Global.equals((Object)this.getState(), (Object)ReliableChannelState.Opening)) {
                item.setUnordered(false);
            } else if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.Open)) {
                String str = StringExtensions.format("Reliable Data: Attempting to send data on a channel in state {0}.", this.getState().toString());
                Log.error(StringExtensions.format(str, new Object[0]));
                Error error2 = new Error(ErrorCode.ReliableDataChannelSendError);
                error2.setException(new Exception(str));
                return error2;
            }
        }
        try {
            Error error;
            SctpTransport innerTransport = this.getInnerTransport();
            if (innerTransport != null && (error = innerTransport.sendData(item)) != null) {
                return error;
            }
            return null;
        }
        catch (Exception exception) {
            String str = StringExtensions.format("Reliable Data: could not send data: {0}", exception.getMessage());
            Log.error(StringExtensions.format(str, new Object[0]));
            Error error3 = new Error(ErrorCode.ReliableDataChannelSendError);
            error3.setException(new Exception(str));
            this.setError(error3);
            return this.getError();
        }
    }

    public Error getError() {
        return this._error;
    }

    public SctpTransport getInnerTransport() {
        return this._innerTransport;
    }

    public int getInnerTransportStreamId() {
        return this._innerTransportStreamId;
    }

    public String getLabel() {
        return this._label;
    }

    static long getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier ppi) {
        if (Global.equals((Object)ppi, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcBinary)) {
            return 53L;
        }
        if (Global.equals((Object)ppi, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep)) {
            return 50L;
        }
        if (Global.equals((Object)ppi, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyBinary)) {
            return 57L;
        }
        if (Global.equals((Object)ppi, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyString)) {
            return 56L;
        }
        if (!Global.equals((Object)ppi, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcString)) {
            throw new RuntimeException(new Exception("Reliable Data: Unknown SCTP WebRTC ppi"));
        }
        return 51L;
    }

    public boolean getOrdered() {
        return this._ordered;
    }

    static ReliableSctpRtcPayloadProtocolIdentifier getPPIFromLong(long num) {
        if (num == 53L) {
            return ReliableSctpRtcPayloadProtocolIdentifier.WebRtcBinary;
        }
        if (num == 50L) {
            return ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep;
        }
        if (num == 57L) {
            return ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyBinary;
        }
        if (num == 56L) {
            return ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyString;
        }
        if (num != 51L) {
            throw new RuntimeException(new Exception("Reliable Data: Unknown SCTP WebRTC ppi"));
        }
        return ReliableSctpRtcPayloadProtocolIdentifier.WebRtcString;
    }

    public ReliableChannelState getState() {
        return this.__state;
    }

    public String getSubProtocol() {
        return this._subProtocol;
    }

    ReliableReliableChannelType getType() {
        if (this.getOrdered()) {
            return ReliableReliableChannelType.DataChannelReliable;
        }
        return ReliableReliableChannelType.DataChannelReliableUnordered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Log.debug(StringExtensions.format("Reliable Data: requesting to open channel {0}.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.New)) {
                String str = "Reliable Data: Attempting to open a channel that is not closed.";
                Log.error(str);
            } else {
                this.setState(ReliableChannelState.Opening);
                SctpTransport innerTransport = this.getInnerTransport();
                ReliableRtcDcepDataChannelOpen open = new ReliableRtcDcepDataChannelOpen(this.getOrdered() ? ReliableReliableChannelType.DataChannelReliable : ReliableReliableChannelType.DataChannelReliableUnordered, this.getLabel(), this.getSubProtocol());
                if (innerTransport != null && !innerTransport.getIsClosed()) {
                    SctpMessage message3 = new SctpMessage(DataBuffer.wrap(open.getBytes()), this.getInnerTransportStreamId());
                    message3.setUnordered(false);
                    message3.setPayloadType(ReliableChannel.getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep));
                    SctpMessage message = message3;
                    try {
                        Error error = innerTransport.sendData(message);
                        for (SctpMessage message2 : this.__outgoingBuffer) {
                            message2.setStreamId(this.getInnerTransportStreamId());
                            error = innerTransport.sendData(message2);
                        }
                        this.__outgoingBuffer.clear();
                        if (error != null) {
                            this.setError(error);
                            this.setState(ReliableChannelState.Failed);
                        }
                    }
                    catch (Exception exception) {
                        Error error2 = new Error(ErrorCode.ReliableDataChannelOpenError);
                        error2.setException(exception);
                        this.setError(error2);
                        this.setState(ReliableChannelState.Failed);
                    }
                } else {
                    Log.error("Reliable Data: Inner Sctp transport is either not initialized or is closed.");
                    this.setState(ReliableChannelState.Failed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChannelOpenAck(ReliableRtcDcepDataChannelAck ack) {
        SctpTransport innerTransport = null;
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.Opening)) {
                Log.error(StringExtensions.format("Reliable Data: Received channel open acknowledgement on channel {0}, but this channel is not in the channel requested state.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
            } else {
                innerTransport = this.getInnerTransport();
                if (innerTransport == null || innerTransport.getIsClosed()) {
                    Log.error(StringExtensions.format("Reliable Data: inner Sctp transport is either not initialized or closed. Cannot process Channel Open Ack message on channel {0}.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
                    this.setState(ReliableChannelState.Failed);
                } else {
                    this.__outgoingBuffer.clear();
                    this.setState(ReliableChannelState.Open);
                    Log.debug(StringExtensions.format("Reliable Data: remote party confirmed opening channel {0}.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
                }
            }
        }
    }

    private void raiseError(Exception exception) {
        IAction1<Exception> onError = this._onError;
        if (onError != null) {
            onError.invoke(exception);
        }
    }

    private void raiseReceiveBinary(DataBuffer buffer) {
        IAction1<DataBuffer> onReceiveBinary = this._onReceiveBinary;
        if (onReceiveBinary != null) {
            onReceiveBinary.invoke(buffer);
        }
    }

    private void raiseReceiveString(String msg) {
        IAction1<String> onReceiveString = this._onReceiveString;
        if (onReceiveString != null) {
            onReceiveString.invoke(msg);
        }
    }

    private void raiseStateChange() {
        IAction1<ReliableChannel> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this);
        }
    }

    public void receiveSctpMessage(SctpMessage msg) {
        ReliableSctpRtcPayloadProtocolIdentifier pPIFromLong = ReliableChannel.getPPIFromLong(msg.getPayloadType());
        try {
            if (Global.equals((Object)this.getState(), (Object)ReliableChannelState.Open) || !Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep)) {
                String str = null;
                DataBuffer payload = null;
                if (Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyString)) {
                    str = StringExtensions.empty;
                } else if (Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcString)) {
                    str = msg.getPayload().readUtf8String(0);
                } else if (Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyBinary)) {
                    payload = DataBuffer.wrap(new byte[0]);
                } else if (Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcBinary)) {
                    payload = msg.getPayload();
                } else {
                    if (Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep)) {
                        throw new RuntimeException(new Exception("Reliable Data: received a webrtc dcep message on an open channel. This scenario is not supported."));
                    }
                    throw new RuntimeException(new Exception("Reliable Data: received a reliable data message of an unknown type."));
                }
                if (str != null) {
                    this.raiseReceiveString(str);
                } else {
                    this.raiseReceiveBinary(payload);
                }
            } else if (Global.equals((Object)pPIFromLong, (Object)ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep)) {
                ReliableRtcDcepMessage message = ReliableRtcDcepMessage.parseBytes(msg.getPayload());
                if (message == null) {
                    throw new RuntimeException(new Exception("Reliable Data: received an invalid webrtc message"));
                }
                if (message.getMessageType() == 3) {
                    try {
                        this.respondToOpenRequest((ReliableRtcDcepDataChannelOpen)message);
                    }
                    catch (Exception exception1) {
                        Exception exception = exception1;
                        Log.error(StringExtensions.format("Reliable Data: could not process incoming channel open request: {0}", exception.getMessage()));
                    }
                } else {
                    if (message.getMessageType() != 2) {
                        throw new RuntimeException(new Exception("Reliable Data: received an invalid webrtc message."));
                    }
                    try {
                        this.processChannelOpenAck((ReliableRtcDcepDataChannelAck)message);
                    }
                    catch (Exception exception2) {
                        Exception exception = exception2;
                        Log.error(StringExtensions.format("Reliable Data: could not process incoming channel open acknowledgement: {0}", exception.getMessage()));
                    }
                }
            }
        }
        catch (Exception exception3) {
            Exception exception = exception3;
            Log.error("Reliable Data: Could not process new data.", exception);
        }
    }

    public ReliableChannel() {
        this(StringExtensions.empty);
    }

    public ReliableChannel(String label) {
        this(label, true);
    }

    public ReliableChannel(String label, boolean ordered) {
        this(label, ordered, StringExtensions.empty);
    }

    public ReliableChannel(String label, boolean ordered, String subprotocol) {
        this.__stateLock = new Object();
        this.__outgoingBuffer = new ArrayList();
        this.setLabel(label);
        this.setOrdered(ordered);
        this.setSubProtocol(subprotocol);
        this.setInnerTransportStreamId(_unset);
        this.setState(ReliableChannelState.New);
    }

    public void removeOnError(IAction1<Exception> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onError, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onError.remove(value);
    }

    public void removeOnReceiveBinary(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveBinary, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveBinary.remove(value);
    }

    public void removeOnReceiveString(IAction1<String> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveString, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveString.remove(value);
    }

    public void removeOnStateChange(IAction1<ReliableChannel> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean respondToOpenRequest(ReliableRtcDcepDataChannelOpen channelOpenRequest) {
        var2_2 = this.__stateLock;
        synchronized (var2_2) {
            if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.New)) {
                Log.error(StringExtensions.format("Reliable Data: Received channel open request on channel {0}, which is not in new state. Check channel ownership convention.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
                this.setState(ReliableChannelState.Failed);
                return false;
            }
            Log.debug(StringExtensions.format("Reliable Data: opening channel {0} on request.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
            innerTransport = this.getInnerTransport();
            ack = new ReliableRtcDcepDataChannelAck();
            if (innerTransport != null) {
                message2 = new SctpMessage(DataBuffer.wrap(ack.getBytes()), this.getInnerTransportStreamId());
                message2.setUnordered(false);
                message2.setPayloadType(ReliableChannel.getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier.WebRtcDcep));
                message = message2;
                try {
                    error = innerTransport.sendData(message);
                    if (error == null) ** GOTO lbl36
                    this.setError(error);
                    this.setState(ReliableChannelState.Failed);
                }
                catch (Exception exception1) {
                    exception = exception1;
                    error2 = new Error(ErrorCode.ReliableDataChannelOpenError);
                    error2.setException(exception);
                    this.setError(error2);
                    this.setState(ReliableChannelState.Failed);
                    return false;
                }
            } else {
                str = "Reliable Data: Inner Sctp transport is not initialized.";
                Log.error(str);
                error3 = new Error(ErrorCode.ReliableDataChannelOpenError);
                error3.setException(new Exception(str));
                this.setError(error3);
                this.setState(ReliableChannelState.Failed);
                return false;
            }
lbl36:
            // 3 sources

            for (SctpMessage message3 : this.__outgoingBuffer) {
                try {
                    message3.setStreamId(this.getInnerTransportStreamId());
                    error = innerTransport.sendData(message3);
                    if (error == null) continue;
                    this.setError(error);
                    this.setState(ReliableChannelState.Failed);
                    return false;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    error4 = new Error(ErrorCode.ReliableDataChannelOpenError);
                    error4.setException(exception);
                    this.setError(error4);
                    this.setState(ReliableChannelState.Failed);
                    return false;
                }
            }
            this.__outgoingBuffer.clear();
            this.setState(ReliableChannelState.Opening);
            this.setState(ReliableChannelState.Open);
        }
        return true;
    }

    public void sendBytes(DataBuffer buffer, IAction0 onSuccess, IAction1<Exception> onFailure) {
        Error error = null;
        if (buffer == null | buffer.getLength() == 0) {
            long longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyBinary);
            error = this.dispatch(DataBuffer.wrap(new byte[1]), longFromSctpPPI, onSuccess, onFailure);
        } else {
            long longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier.WebRtcBinary);
            error = this.dispatch(buffer, longFromSctpPPI, onSuccess, onFailure);
        }
        if (error != null) {
            IAction1<Exception> action = onFailure;
            action.invoke(error.getException());
            this.setError(error);
            this.setState(ReliableChannelState.Failed);
        }
    }

    public void sendBytes(DataBuffer buffer) {
        this.sendBytes(buffer, null, null);
    }

    public void sendString(String message) {
        this.sendString(message, null, null);
    }

    public void sendString(String message, IAction0 onSuccess, IAction1<Exception> onFailure) {
        Error error = null;
        if (message == null | StringExtensions.getLength(message) == 0) {
            long longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier.WebRtcEmptyString);
            error = this.dispatch(DataBuffer.wrap(new byte[1]), longFromSctpPPI, onSuccess, onFailure);
        } else {
            long longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpRtcPayloadProtocolIdentifier.WebRtcString);
            error = this.dispatch(DataBuffer.wrap(Utf8.encode(message)), longFromSctpPPI, onSuccess, onFailure);
        }
        if (error != null) {
            IAction1<Exception> action = onFailure;
            if (action != null) {
                action.invoke(error.getException());
            }
            this.setError(error);
            this.setState(ReliableChannelState.Failed);
        }
    }

    private void setError(Error value) {
        this._error = value;
    }

    public void setInnerTransport(SctpTransport value) {
        this._innerTransport = value;
    }

    void setInnerTransportStreamId(int value) {
        this._innerTransportStreamId = value;
    }

    private void setLabel(String value) {
        this._label = value;
    }

    private void setOrdered(boolean value) {
        this._ordered = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ReliableChannelState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)value, (Object)this.getState())) {
                this.__state = value;
                this.raiseStateChange();
            }
        }
    }

    private void setSubProtocol(String value) {
        this._subProtocol = value;
    }
}

