/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.Build;
import fm.icelink.DateExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IntegerExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.Log;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableLong;
import fm.icelink.RsaCrypto;
import fm.icelink.RsaKey;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import java.util.Date;
import java.util.HashMap;

public class License {
    private static License __license;
    private static String __licenseKey;
    private static RsaKey __publicKey;
    private String _id;
    private Date _issuedAt = new Date();
    private boolean _isTrial;
    private String _productCode;
    private byte[] _signature;
    private Date _validFrom = new Date();
    private Date _validTo = new Date();

    public static void checkKey() {
        if (Build.getYear() != 0 && Build.getMonth() != 0 && Build.getDay() != 0) {
            if (StringExtensions.isNullOrEmpty(__licenseKey)) {
                String str = StringExtensions.format("License key not set.", new Object[0]);
                Log.error(str);
                throw new RuntimeException(new Exception(str));
            }
            boolean flag = false;
            if (__license == null) {
                flag = true;
                __license = License.parseKey(__licenseKey);
            }
            if (flag) {
                Log.info(StringExtensions.format("Build version is {1} ({2}-{3}-{4}).", new Object[]{"IceLink", "3.0.9.0", IntegerExtensions.toString(Build.getYear()), IntegerExtensions.toString(Build.getMonth()), IntegerExtensions.toString(Build.getDay())}));
            }
            if (__license == null) {
                String str = "Invalid license key.";
                if (flag) {
                    Log.error(str);
                }
                throw new RuntimeException(new Exception(str));
            }
            if (!Global.equals(__license.getProductCode(), "IceLink")) {
                if (__license.getIsTrial()) {
                    if (__license.getIsValid()) {
                        String str = StringExtensions.format("Valid {0} trial license key detected, but expected a license key for {1}.", __license.getProductCode(), "IceLink");
                        if (flag) {
                            Log.error(str);
                        }
                        throw new RuntimeException(new Exception(str));
                    }
                    String str = StringExtensions.format("Expired {0} trial license key detected, and expected a license key for {1}. Contact sales@frozenmountain.com for more information.", __license.getProductCode(), "IceLink");
                    if (flag) {
                        Log.error(str);
                    }
                    throw new RuntimeException(new Exception(str));
                }
                if (__license.getIsValid()) {
                    String str = StringExtensions.format("Valid {0} license key detected, but expected a license key for {1}.", __license.getProductCode(), "IceLink");
                    if (flag) {
                        Log.error(str);
                    }
                    throw new RuntimeException(new Exception(str));
                }
                String str = StringExtensions.format("{0} license key is invalid for this build, and expected a license key for {1}. Visit www.frozenmountain.com to generate an updated license key.", __license.getProductCode(), "IceLink");
                if (flag) {
                    Log.error(str);
                }
                throw new RuntimeException(new Exception(str));
            }
            if (!__license.getIsTrial()) {
                if (!__license.getIsValid()) {
                    String str = StringExtensions.format("{0} license key is invalid for this build. Visit www.frozenmountain.com to generate an updated license key.", __license.getProductCode());
                    if (flag) {
                        Log.error(str);
                    }
                    throw new RuntimeException(new Exception(str));
                }
                if (flag) {
                    Log.info(StringExtensions.format("Valid {0} license key detected.", __license.getProductCode()));
                }
            } else {
                if (!__license.getIsValid()) {
                    String str = StringExtensions.format("Expired {0} trial license key detected. Contact sales@frozenmountain.com for more information.", __license.getProductCode());
                    if (flag) {
                        Log.error(str);
                    }
                    throw new RuntimeException(new Exception(str));
                }
                if (flag) {
                    Log.info(StringExtensions.format("Valid {0} trial license key detected.", __license.getProductCode()));
                }
            }
        }
    }

    private static License fromJson(String json) {
        return JsonSerializer.deserializeObject(json, new IFunction0<License>(){

            @Override
            public License invoke() {
                return new License();
            }
        }, new IAction3<License, String, String>(){

            @Override
            public void invoke(License license, String key, String valueJson) {
                String str = key;
                if (str != null) {
                    if (!Global.equals(str, "id")) {
                        NullableLong nullable4;
                        if (Global.equals(str, "pc")) {
                            license.setProductCode(JsonSerializer.deserializeString(valueJson));
                        } else if (Global.equals(str, "it")) {
                            NullableBoolean nullable = JsonSerializer.deserializeBoolean(valueJson);
                            if (nullable.getHasValue()) {
                                license.setIsTrial(nullable.getValue());
                            }
                        } else if (Global.equals(str, "ia")) {
                            NullableLong nullable2 = JsonSerializer.deserializeLong(valueJson);
                            if (nullable2.getHasValue()) {
                                license.setIssuedAt(DateExtensions.createDate(nullable2.getValue()));
                            }
                        } else if (Global.equals(str, "vf")) {
                            NullableLong nullable3 = JsonSerializer.deserializeLong(valueJson);
                            if (nullable3.getHasValue()) {
                                license.setValidFrom(DateExtensions.createDate(nullable3.getValue()));
                            }
                        } else if (Global.equals(str, "vt") && (nullable4 = JsonSerializer.deserializeLong(valueJson)).getHasValue()) {
                            license.setValidTo(DateExtensions.createDate(nullable4.getValue()));
                        }
                    } else {
                        license.setId(JsonSerializer.deserializeString(valueJson));
                    }
                }
            }
        });
    }

    private String getId() {
        return this._id;
    }

    private Date getIssuedAt() {
        return this._issuedAt;
    }

    private boolean getIsTrial() {
        return this._isTrial;
    }

    private boolean getIsValid() {
        long ticks = DateExtensions.getTicks(this.getValidFrom());
        long num2 = DateExtensions.getTicks(this.getValidTo());
        if (this.getIsTrial()) {
            long num3 = DateExtensions.getTicks(DateExtensions.getUtcNow());
            return num3 >= ticks && num3 <= num2;
        }
        return DateExtensions.getTicks(Build.getDate()) <= num2;
    }

    public String getKey() {
        return StringExtensions.concat("fm", Base64.encode(Utf8.encode(this.toJson())), ".", Base64.encode(this.getSignature()));
    }

    private String getProductCode() {
        return this._productCode;
    }

    private byte[] getSignature() {
        return this._signature;
    }

    private Date getValidFrom() {
        return this._validFrom;
    }

    private Date getValidTo() {
        return this._validTo;
    }

    private License(String id, String productCode, boolean isTrial, Date validFrom, Date validTo) {
        this();
        this.setId(id);
        this.setProductCode(productCode);
        this.setIsTrial(isTrial);
        this.setValidFrom(validFrom);
        this.setValidTo(validTo);
    }

    private License() {
        this.setIssuedAt(DateExtensions.getUtcNow());
    }

    private static License parseKey(String key) {
        if (!StringExtensions.isNullOrEmpty(key)) {
            Object[] strArray = StringExtensions.split(key, new char[]{'.'});
            if (ArrayExtensions.getLength(strArray) != 2) {
                return null;
            }
            Object str = strArray[0];
            if (StringExtensions.getLength((String)str) >= StringExtensions.getLength("fm")) {
                if (StringExtensions.isNullOrEmpty((String)(str = ((String)str).substring(StringExtensions.getLength("fm"))))) {
                    return null;
                }
                byte[] decoded = null;
                Holder<Object> _var0 = new Holder<Object>(decoded);
                boolean _var1 = Base64.tryDecode((String)str, _var0);
                decoded = _var0.getValue();
                if (!_var1) {
                    return null;
                }
                String json = Utf8.decode(decoded);
                if (json == null) {
                    return null;
                }
                License license = License.fromJson(json);
                if (license == null) {
                    return null;
                }
                Object str3 = strArray[1];
                if (StringExtensions.isNullOrEmpty((String)str3)) {
                    return null;
                }
                byte[] buffer2 = null;
                Holder<Object> _var2 = new Holder<Object>(buffer2);
                boolean _var3 = Base64.tryDecode((String)str3, _var2);
                buffer2 = _var2.getValue();
                if (!_var3) {
                    return null;
                }
                if (!RsaCrypto.verifyRsaSha256(Utf8.encode((String)str), buffer2, __publicKey)) {
                    return null;
                }
                license.setSignature(buffer2);
                return license;
            }
        }
        return null;
    }

    private void setId(String value) {
        this._id = value;
    }

    private void setIssuedAt(Date value) {
        this._issuedAt = value;
    }

    private void setIsTrial(boolean value) {
        this._isTrial = value;
    }

    public static void setKey(String key) {
        __licenseKey = key.trim();
        __licenseKey = __licenseKey.replace(" ", StringExtensions.empty);
        __licenseKey = __licenseKey.replace("\t", StringExtensions.empty);
        __licenseKey = __licenseKey.replace("\r", StringExtensions.empty);
        __licenseKey = __licenseKey.replace("\n", StringExtensions.empty);
        License.checkKey();
    }

    private void setProductCode(String value) {
        this._productCode = value;
    }

    private void setSignature(byte[] value) {
        this._signature = value;
    }

    private void setValidFrom(Date value) {
        this._validFrom = value;
    }

    private void setValidTo(Date value) {
        this._validTo = value;
    }

    private String toJson() {
        return JsonSerializer.serializeObject(this, new IAction2<License, HashMap<String, String>>(){

            @Override
            public void invoke(License license, HashMap<String, String> jsonObj) {
                if (License.this.getId() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "id", JsonSerializer.serializeString(License.this.getId()));
                }
                if (License.this.getProductCode() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "pc", JsonSerializer.serializeString(License.this.getProductCode()));
                }
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "it", JsonSerializer.serializeBoolean(new NullableBoolean(License.this.getIsTrial())));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "ia", JsonSerializer.serializeLong(new NullableLong(DateExtensions.getTicks(License.this.getIssuedAt()))));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "vf", JsonSerializer.serializeLong(new NullableLong(DateExtensions.getTicks(License.this.getValidFrom()))));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "vt", JsonSerializer.serializeLong(new NullableLong(DateExtensions.getTicks(License.this.getValidTo()))));
            }
        });
    }

    static {
        __publicKey = RsaKey.parseBytes(Base64.decode("MIGJAoGBALf/wUlxLUmBEMqd4QHTc+/CP5P3t/BKD+mBNGkRv6CDNreyMuPPGzh3ijr6j//ikY2YzWDCaVuO5SRnZo4+6DwoLQI7nC/m7hcetvYSJhf4mjCeoH8JG1ks1YQeWSbsLp7KjYr5Dan93LIvk6lcjqzv8xO+8msJZ4X9kzW8tO8ZAgMBAAE="));
    }
}

