/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;
import fm.icelink.FileStream;
import fm.icelink.FileStreamAccess;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.HttpMethod;
import fm.icelink.HttpRequestArgs;
import fm.icelink.HttpResponseArgs;
import fm.icelink.HttpTransferFactory;
import fm.icelink.IAction1;
import fm.icelink.IFunction1;
import fm.icelink.Promise;
import fm.icelink.PromiseBase;
import fm.icelink.bzip2.Decompressor;

public class HttpFileTransfer {
    private static Future<DataBuffer> downloadFile(final Promise<DataBuffer> promise, String url) {
        HttpRequestArgs requestArgs = new HttpRequestArgs();
        requestArgs.setMethod(HttpMethod.Get);
        requestArgs.setUrl(url);
        HttpTransferFactory.getHttpTransfer().sendAsync(requestArgs, new IAction1<HttpResponseArgs>(){

            @Override
            public void invoke(HttpResponseArgs response) {
                if (response.getException() != null) {
                    promise.reject(response.getException());
                } else if (Global.equals(HashMapExtensions.getItem(response.getHeaders()).get("Content-Type"), "application/x-bzip2")) {
                    Decompressor decompressor = new Decompressor(DataBuffer.wrap(response.getBinaryContent()));
                    DataBufferStream stream = new DataBufferStream(ArrayExtensions.getLength(response.getBinaryContent()));
                    byte[] buffer = new byte[2048];
                    int j = decompressor.read(buffer, 0, ArrayExtensions.getLength(buffer));
                    while (j > 0) {
                        stream.writeBytes(buffer, 0, j);
                        j = decompressor.read(buffer, 0, ArrayExtensions.getLength(buffer));
                    }
                    promise.resolve(stream.getBuffer());
                } else {
                    promise.resolve(DataBuffer.wrap(response.getBinaryContent()));
                }
            }
        });
        return promise;
    }

    public static Future<DataBuffer> downloadFile(String url) {
        return HttpFileTransfer.downloadFile(new Promise<DataBuffer>(), url);
    }

    public static Future<Object> downloadFile(String url, final String filePath) {
        return HttpFileTransfer.downloadFile(url).then(new IFunction1<DataBuffer, Future<Object>>(){

            @Override
            public Future<Object> invoke(DataBuffer buffer) {
                FileStream stream = new FileStream(filePath);
                stream.open(FileStreamAccess.Write);
                stream.write(buffer.getData(), buffer.getIndex(), buffer.getLength());
                stream.close();
                return PromiseBase.resolveNow();
            }
        });
    }
}

