/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DtlsContentType;
import fm.icelink.DtlsHandshakeType;
import fm.icelink.IntegerHolder;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class DtlsMessage {
    private int _contentType;
    private int _epoch;
    private int _handshakeFragmentLength;
    private int _handshakeFragmentOffset;
    private int _handshakeLength;
    private int _handshakeMessageSequence;
    private byte[] _handshakePayload;
    private int _handshakeType;
    private int _length;
    private DataBuffer _payload;
    private int _protocolVersionMajor;
    private int _protocolVersionMinor;
    private DataBuffer _raw;
    private long _sequenceNumber;

    public int getContentType() {
        return this._contentType;
    }

    public int getEpoch() {
        return this._epoch;
    }

    public int getHandshakeFragmentLength() {
        return this._handshakeFragmentLength;
    }

    public int getHandshakeFragmentOffset() {
        return this._handshakeFragmentOffset;
    }

    public int getHandshakeLength() {
        return this._handshakeLength;
    }

    public int getHandshakeMessageSequence() {
        return this._handshakeMessageSequence;
    }

    public byte[] getHandshakePayload() {
        return this._handshakePayload;
    }

    public int getHandshakeType() {
        return this._handshakeType;
    }

    public int getLength() {
        return this._length;
    }

    public DataBuffer getPayload() {
        return this._payload;
    }

    public int getProtocolVersionMajor() {
        return this._protocolVersionMajor;
    }

    public int getProtocolVersionMinor() {
        return this._protocolVersionMinor;
    }

    public DataBuffer getRaw() {
        return this._raw;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public static DtlsMessage parse(DataBuffer data, int offset, IntegerHolder offsetPlus) {
        if (data.getLength() < offset + 13) {
            offsetPlus.setValue(offset);
            return null;
        }
        int length = 13 + data.read16(offset + 11);
        if (data.getLength() < offset + length) {
            offsetPlus.setValue(offset);
            return null;
        }
        DtlsMessage message = new DtlsMessage();
        message.setRaw(data.subset(offset, length));
        IntegerHolder _var0 = new IntegerHolder(offset);
        int _var1 = data.read8(offset, _var0);
        offset = _var0.getValue();
        message.setContentType(_var1);
        IntegerHolder _var2 = new IntegerHolder(offset);
        int _var3 = data.read8(offset, _var2);
        offset = _var2.getValue();
        message.setProtocolVersionMajor(_var3);
        IntegerHolder _var4 = new IntegerHolder(offset);
        int _var5 = data.read8(offset, _var4);
        offset = _var4.getValue();
        message.setProtocolVersionMinor(_var5);
        IntegerHolder _var6 = new IntegerHolder(offset);
        int _var7 = data.read16(offset, _var6);
        offset = _var6.getValue();
        message.setEpoch(_var7);
        IntegerHolder _var8 = new IntegerHolder(offset);
        long _var9 = data.read48(offset, _var8);
        offset = _var8.getValue();
        message.setSequenceNumber(_var9);
        IntegerHolder _var10 = new IntegerHolder(offset);
        int _var11 = data.read16(offset, _var10);
        offset = _var10.getValue();
        message.setLength(_var11);
        message.setPayload(data.subset(offset, message.getLength()));
        offset += message.getLength();
        if (message.getContentType() == DtlsContentType.getHandshake()) {
            DataBuffer payload = message.getPayload();
            int num2 = 0;
            IntegerHolder _var12 = new IntegerHolder(num2);
            int _var13 = payload.read8(num2, _var12);
            num2 = _var12.getValue();
            message.setHandshakeType(_var13);
        } else {
            message.setHandshakeType(-1);
        }
        offsetPlus.setValue(offset);
        return message;
    }

    public static DtlsMessage[] parseMultiple(DataBuffer data) {
        int offset = 0;
        ArrayList<DtlsMessage> list = new ArrayList<DtlsMessage>();
        while (true) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            DtlsMessage _var1 = DtlsMessage.parse(data, offset, _var0);
            offset = _var0.getValue();
            DtlsMessage item = _var1;
            if (item == null) {
                return list.toArray(new DtlsMessage[0]);
            }
            list.add(item);
        }
    }

    public void setContentType(int value) {
        this._contentType = value;
    }

    public void setEpoch(int value) {
        this._epoch = value;
    }

    public void setHandshakeFragmentLength(int value) {
        this._handshakeFragmentLength = value;
    }

    public void setHandshakeFragmentOffset(int value) {
        this._handshakeFragmentOffset = value;
    }

    public void setHandshakeLength(int value) {
        this._handshakeLength = value;
    }

    public void setHandshakeMessageSequence(int value) {
        this._handshakeMessageSequence = value;
    }

    public void setHandshakePayload(byte[] value) {
        this._handshakePayload = value;
    }

    public void setHandshakeType(int value) {
        this._handshakeType = value;
    }

    public void setLength(int value) {
        this._length = value;
    }

    public void setPayload(DataBuffer value) {
        this._payload = value;
    }

    public void setProtocolVersionMajor(int value) {
        this._protocolVersionMajor = value;
    }

    public void setProtocolVersionMinor(int value) {
        this._protocolVersionMinor = value;
    }

    public void setRaw(DataBuffer value) {
        this._raw = value;
    }

    public void setSequenceNumber(long value) {
        this._sequenceNumber = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, DtlsContentType.getDisplayName(this.getContentType()));
        if (this.getContentType() == DtlsContentType.getHandshake()) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(" - ", DtlsHandshakeType.getDisplayName(this.getHandshakeType())));
        }
        StringBuilderExtensions.append(builder, StringExtensions.concat(new Object[]{" (epoch: ", this.getEpoch(), "; sequence number: ", this.getSequenceNumber(), "; length: ", this.getLength(), ")"}));
        return builder.toString();
    }
}

