/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioDepacketizer;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.IAudioSource;
import fm.icelink.RtpPacket;

public class BasicAudioDepacketizer
extends AudioDepacketizer {
    public BasicAudioDepacketizer(AudioFormat format) {
        super(format);
    }

    public BasicAudioDepacketizer(IAudioSource source) {
        super(source);
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        Object[] dataBuffers = inputBuffer.getDataBuffers();
        DataBuffer[] bufferArray2 = new DataBuffer[ArrayExtensions.getLength(dataBuffers)];
        for (int i = 0; i < ArrayExtensions.getLength(dataBuffers); ++i) {
            RtpPacket packet = RtpPacket.wrap(inputBuffer.getDataBuffers()[i]);
            if (packet == null) {
                throw new RuntimeException(new Exception("Cannot depacketize audio. Frame contains malformed RTP packets."));
            }
            bufferArray2[i] = packet.getPayload();
        }
        AudioBuffer buffer = inputBuffer.clone();
        buffer.setDataBuffers(bufferArray2);
        buffer.setFormat(super.getOutputFormat());
        frame.addBuffer(buffer);
        this.raiseFrame(frame);
    }

    @Override
    public String getLabel() {
        return "Basic Audio Depacketizer";
    }
}

