/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Architecture {
    Unknown(1),
    X86(2),
    X64(3),
    Armv7(4),
    Armv8(5),
    Arm64(6);

    private final int value;
    private static final Map<Integer, Architecture> lookup;

    private Architecture(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static Architecture getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, Architecture>();
        for (Architecture s : EnumSet.allOf(Architecture.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

