/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vpx;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.vpx.Codec;
import java.util.Arrays;

class Native
extends fm.icelink.Native {
    long _decoderState;
    long _encoderState;
    boolean _isEncoder;
    Codec _codec;

    public void setNeedsKeyFrame(boolean value) {
        Native.VpxFMDecoderSetNeedsKeyFrame(this._decoderState, value ? 1 : 0);
    }

    public boolean getNeedsKeyFrame() {
        return Native.VpxFMDecoderGetNeedsKeyFrame(this._decoderState) != 0;
    }

    public void setForceKeyFrame(boolean value) {
        Native.VpxFMEncoderSetForceKeyFrame(this._encoderState, value ? 1 : 0);
    }

    public boolean getForceKeyFrame() {
        return Native.VpxFMEncoderGetForceKeyFrame(this._encoderState) != 0;
    }

    public void setBitrate(int value) {
        Native.VpxFMEncoderSetBitrate(this._encoderState, value);
    }

    public int getBitrate() {
        return Native.VpxFMEncoderGetBitrate(this._encoderState);
    }

    public void setQuality(double value) {
        Native.VpxFMEncoderSetQuality(this._encoderState, value);
    }

    public double getQuality() {
        return Native.VpxFMEncoderGetQuality(this._encoderState);
    }

    public Native(boolean encoder) {
        this._isEncoder = encoder;
        this._codec = Codec.Vp9;
        if (this._isEncoder) {
            this._encoderState = Native.VpxFMEncoderCreate(0L, 0L, 0L, 0L);
        } else {
            this._decoderState = Native.VpxFMDecoderCreate(0L, 0L, 0L, 0L);
        }
    }

    public Codec getCodec() {
        return this._codec;
    }

    public void setCodec(Codec codec) {
        this._codec = codec;
        if (this._isEncoder) {
            Native.VpxFMEncoderSetVP9(this._encoderState, this._codec == Codec.Vp9 ? 1 : 0);
        } else {
            Native.VpxFMDecoderSetVP9(this._decoderState, this._codec == Codec.Vp9 ? 1 : 0);
        }
    }

    public void destroy() {
        if (this._isEncoder) {
            Native.VpxFMEncoderDestroy(this._encoderState);
        } else {
            Native.VpxFMDecoderDestroy(this._decoderState);
        }
    }

    public VideoBuffer encode(VideoBuffer buffer, VideoFormat outputFormat) {
        byte[][] planeDatas = new byte[4][];
        int[] planeStrides = new int[4];
        int[] planeIndexes = new int[4];
        int[] planeLengths = new int[4];
        for (int i = 0; i < buffer.getDataBuffers().length; ++i) {
            DataBuffer plane = buffer.getDataBuffers()[i];
            planeDatas[i] = plane.getData();
            planeStrides[i] = buffer.getStrides()[i];
            planeIndexes[i] = plane.getIndex();
            planeLengths[i] = plane.getLength();
        }
        int[] encodedLengthArray = new int[1];
        byte[] outputData = Native.VpxFMEncoderEncodei420(this._encoderState, buffer.getWidth(), buffer.getHeight(), planeDatas, planeStrides, planeIndexes, planeLengths, encodedLengthArray);
        if (outputData != null) {
            return new VideoBuffer(buffer.getWidth(), buffer.getHeight(), DataBuffer.wrap((byte[])outputData), outputFormat);
        }
        return null;
    }

    public VideoBuffer decode(VideoBuffer encodedFrame, VideoFormat outputFormat) {
        try {
            int[] widthArray = new int[1];
            int[] heightArray = new int[1];
            int[] planeStrides = new int[4];
            int[] planeIndexes = new int[4];
            int[] planeLengths = new int[4];
            int[] planeCountArray = new int[1];
            DataBuffer buffer = encodedFrame.getDataBuffers()[0];
            byte[] outputData = Native.VpxFMDecoderDecode(this._decoderState, Arrays.copyOfRange(buffer.getData(), buffer.getIndex(), buffer.getLength()), encodedFrame.getDataBuffers()[0].getLength(), widthArray, heightArray, planeStrides, planeIndexes, planeLengths, planeCountArray);
            if (outputData != null) {
                int width = widthArray[0];
                int height = heightArray[0];
                final int[] strides = new int[planeStrides.length];
                buffer = DataBuffer.wrap((byte[])outputData);
                int planeCount = planeCountArray[0];
                DataBuffer[] planes = new DataBuffer[planeCount];
                int offset = 0;
                for (int i = 0; i < planeCount; ++i) {
                    strides[i] = planeStrides[i];
                    planes[i] = buffer.subset(offset, planeLengths[i]);
                    offset += planeLengths[i];
                }
                return new VideoBuffer(width, height, planes, outputFormat){
                    {
                        super(x0, x1, x2, x3);
                        this.setStrides(strides);
                    }
                };
            }
        }
        catch (Exception ex) {
            Log.error((String)"Decode failed with exception. Attempting to recover with keyframe request.", (Exception)ex);
            this.setNeedsKeyFrame(true);
        }
        return null;
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibVpxFM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibVpxFM: " + msg));
    }

    private static native int VpxFMEncoderGetBitrate(long var0);

    private static native void VpxFMEncoderSetBitrate(long var0, int var2);

    private static native double VpxFMEncoderGetQuality(long var0);

    private static native void VpxFMEncoderSetQuality(long var0, double var2);

    private static native int VpxFMEncoderGetForceKeyFrame(long var0);

    private static native void VpxFMEncoderSetForceKeyFrame(long var0, int var2);

    private static native long VpxFMEncoderCreate(long var0, long var2, long var4, long var6);

    private static native void VpxFMEncoderDestroy(long var0);

    private static native byte[] VpxFMEncoderEncodei420(long var0, int var2, int var3, byte[][] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    private static native void VpxFMEncoderSetVP9(long var0, int var2);

    private static native long VpxFMDecoderCreate(long var0, long var2, long var4, long var6);

    private static native void VpxFMDecoderDestroy(long var0);

    private static native byte[] VpxFMDecoderDecode(long var0, byte[] var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    private static native int VpxFMDecoderGetNeedsKeyFrame(long var0);

    private static native void VpxFMDecoderSetNeedsKeyFrame(long var0, int var2);

    private static native void VpxFMDecoderSetVP9(long var0, int var2);

    static {
        Global.loadLibrary((String)"vpx");
        Global.loadLibrary((String)"vpxfmJNI");
    }
}

