/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vpx;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFrame;
import fm.icelink.PliControlFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.vp8.Utility;
import fm.icelink.vpx.Codec;
import fm.icelink.vpx.Native;

public abstract class Encoder
extends VideoEncoder {
    private Native __encoder = Global.equals((Object)((VideoFormat)super.getOutputFormat()).getName(), (Object)VideoFormat.getVp9Name()) ? new Native(true) : new Native(true);

    protected void doDestroy() {
        this.__encoder.destroy();
        this.__encoder = null;
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        for (MediaControlFrame frame : controlFrames) {
            if (!(frame instanceof PliControlFrame)) continue;
            this.setForceKeyFrame(true);
        }
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer = this.__encoder.encode(inputBuffer, (VideoFormat)super.getOutputFormat());
        if (buffer != null) {
            if (Utility.isKeyFrame((DataBuffer)buffer.getDataBuffer())) {
                Log.debug((String)"Encoder generated VP8 keyframe.");
            }
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame((MediaFrame)frame);
            buffer.releaseBuffers();
        }
    }

    public Encoder(VideoFormat outputFormat) {
        super(VideoFormat.getI420(), outputFormat);
    }

    public int getBitrate() {
        return this.__encoder.getBitrate();
    }

    public Codec getCodec() {
        return this.__encoder.getCodec();
    }

    public boolean getForceKeyFrame() {
        return this.__encoder.getForceKeyFrame();
    }

    public double getQuality() {
        return this.__encoder.getQuality();
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    public void setBitrate(int value) {
        this.__encoder.setBitrate(value);
    }

    public void setCodec(Codec value) {
        this.__encoder.setCodec(value);
    }

    public void setForceKeyFrame(boolean value) {
        this.__encoder.setForceKeyFrame(value);
    }

    public void setQuality(double value) {
        this.__encoder.setQuality(value);
    }
}

