/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Crypto;
import fm.Holder;
import fm.NullableDate;
import fm.Serializer;
import fm.websync.Extensible;

public abstract class BaseMessage
extends Extensible {
    byte[] __dataBytes;
    String __dataJson;
    private String __error;
    private boolean __successful;
    private NullableDate __timestamp = new NullableDate();
    private boolean _validate;

    public BaseMessage() {
        this.setValidate(true);
    }

    public byte[] getDataBytes() throws Exception {
        byte[] decoded = this.__dataBytes;
        String valueJson = this.__dataJson;
        if (decoded != null) {
            return decoded;
        }
        if (valueJson != null) {
            Holder _var0 = new Holder((Object)decoded);
            boolean _var1 = Crypto.tryBase64Decode((String)Serializer.deserializeString((String)valueJson), (Holder)_var0);
            decoded = (byte[])_var0.getValue();
            if (!_var1) {
                decoded = null;
            }
            this.__dataBytes = decoded;
            return decoded;
        }
        return null;
    }

    public String getDataJson() {
        String str = this.__dataJson;
        byte[] b = this.__dataBytes;
        if (str != null) {
            return str;
        }
        if (b != null) {
            this.__dataJson = str = Serializer.serializeString((String)Crypto.base64Encode((byte[])b));
            return str;
        }
        return null;
    }

    public String getError() {
        return this.__error;
    }

    public boolean getIsBinary() throws Exception {
        return this.getDataBytes() != null;
    }

    public boolean getSuccessful() {
        return this.__successful;
    }

    public NullableDate getTimestamp() {
        return this.__timestamp;
    }

    public boolean getValidate() {
        return this._validate;
    }

    public void setDataBytes(byte[] value) {
        this.__dataJson = null;
        this.__dataBytes = value;
        super.setIsDirty(true);
    }

    public void setDataJson(String value) throws Exception {
        if (this.getValidate() && value != null && !Serializer.isValidJson((String)value)) {
            throw new Exception("The value is not valid JSON.");
        }
        this.__dataJson = value;
        this.__dataBytes = null;
        super.setIsDirty(true);
    }

    public void setError(String value) {
        this.__error = value;
        super.setIsDirty(true);
    }

    public void setSuccessful(boolean value) {
        this.__successful = value;
        super.setIsDirty(true);
    }

    public void setTimestamp(NullableDate value) {
        this.__timestamp = value;
        super.setIsDirty(true);
    }

    public void setValidate(boolean value) {
        this._validate = value;
    }
}

