/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Encoding;
import fm.HttpRequestArgs;
import fm.HttpRequestCreatedArgs;
import fm.HttpResponseArgs;
import fm.HttpResponseReceivedArgs;
import fm.HttpTransfer;
import fm.ManagedCondition;
import fm.SingleAction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class HttpWebRequestTransfer
extends HttpTransfer {
    private ExecutorService exec = Executors.newCachedThreadPool();
    private String callbackKey = "fm.httpWebRequestTransfer.sendTextAsync.callback";

    public static String getPlatformCode() {
        return "java";
    }

    private static HttpURLConnection createRequest(HttpRequestArgs args) throws Exception {
        HttpURLConnection request = (HttpURLConnection)new URL(args.getUrl()).openConnection();
        request.setRequestMethod("POST");
        switch (args.getMethod()) {
            case Get: {
                request.setRequestMethod("GET");
                break;
            }
            case Head: {
                request.setRequestMethod("HEAD");
                break;
            }
            case Post: {
                request.setRequestMethod("POST");
                break;
            }
            case Put: {
                request.setRequestMethod("PUT");
                break;
            }
            case Patch: {
                request.setRequestMethod("PATCH");
                break;
            }
            case Delete: {
                request.setRequestMethod("DELETE");
            }
        }
        for (Map.Entry<String, String> header : args.getHeaders().entrySet()) {
            request.setRequestProperty(header.getKey(), header.getValue());
        }
        request.setRequestProperty("Accept-Encoding", "gzip,deflate");
        request.setConnectTimeout(args.getTimeout());
        request.setReadTimeout(args.getTimeout());
        request.setUseCaches(false);
        request.setDoInput(true);
        if (args.getBinaryContent() != null) {
            request.setDoOutput(true);
        }
        if (args.getOnRequestCreated() != null) {
            HttpRequestCreatedArgs rcargs = new HttpRequestCreatedArgs();
            rcargs.setSender(args.getSender());
            rcargs.setRequest(request);
            rcargs.setRequestArgs(args);
            args.getOnRequestCreated().invoke(rcargs);
        }
        return request;
    }

    @Override
    public void shutdown() {
        this.exec.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponseArgs sendBinary(final HttpRequestArgs requestArgs) throws Exception {
        final HttpResponseArgs responseArgs = new HttpResponseArgs(requestArgs);
        final HttpURLConnection request = HttpWebRequestTransfer.createRequest(requestArgs);
        final ManagedCondition condition = new ManagedCondition();
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        final boolean[] completedOut = new boolean[1];
        final Exception[] exceptionOut = new Exception[1];
        completedOut[0] = false;
        exceptionOut[0] = null;
        boolean completed = false;
        Exception exception = null;
        ManagedCondition managedCondition = condition;
        synchronized (managedCondition) {
            this.exec.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Exception exception = null;
                    try {
                        byte[] binaryContent = requestArgs.getBinaryContent();
                        if (binaryContent != null) {
                            OutputStream os = request.getOutputStream();
                            os.write(requestArgs.getBinaryContent());
                            os.flush();
                        }
                        InputStream is = null;
                        try {
                            try {
                                is = request.getInputStream();
                            }
                            catch (IOException ex) {
                                is = request.getErrorStream();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (is != null) {
                            String encoding = request.getContentEncoding();
                            if ("gzip".equalsIgnoreCase(encoding)) {
                                is = new GZIPInputStream(is);
                            } else if ("deflate".equalsIgnoreCase(encoding)) {
                                Inflater inflater = new Inflater(true);
                                is = new InflaterInputStream(is, inflater);
                            }
                        }
                        responseArgs.setStatusCode(request.getResponseCode());
                        int i = 0;
                        while (true) {
                            String headerName = request.getHeaderFieldKey(i);
                            String headerValue = request.getHeaderField(i);
                            if (headerName == null && headerValue == null) break;
                            responseArgs.getHeaders().put(headerName, headerValue);
                            ++i;
                        }
                        if (is != null) {
                            int nRead;
                            byte[] data = new byte[16384];
                            while ((nRead = is.read(data, 0, data.length)) != -1) {
                                buffer.write(data, 0, nRead);
                            }
                            buffer.flush();
                        }
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                    ManagedCondition managedCondition = condition;
                    synchronized (managedCondition) {
                        completedOut[0] = true;
                        exceptionOut[0] = exception;
                        condition.pulse();
                    }
                }
            });
            condition.halt(requestArgs.getTimeout());
            exception = exceptionOut[0];
            completed = completedOut[0];
        }
        if (exception != null) {
            throw exception;
        }
        if (completed) {
            responseArgs.setBinaryContent(buffer.toByteArray());
        }
        if (requestArgs.getOnResponseReceived() != null) {
            HttpResponseReceivedArgs rcargs = new HttpResponseReceivedArgs();
            rcargs.setSender(requestArgs.getSender());
            rcargs.setResponse(request);
            rcargs.setRequestArgs(requestArgs);
            requestArgs.getOnResponseReceived().invoke(rcargs);
        }
        return responseArgs;
    }

    @Override
    public void sendBinaryAsync(HttpRequestArgs requestArgs, SingleAction<HttpResponseArgs> callback) {
        final HttpWebRequestTransfer self = this;
        final HttpRequestArgs selfRequestArgs = requestArgs;
        final SingleAction<HttpResponseArgs> selfCallback = callback;
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpResponseArgs responseArgs = self.sendBinary(selfRequestArgs);
                    selfCallback.invoke(responseArgs);
                }
                catch (Exception e) {
                    HttpResponseArgs responseArgs = new HttpResponseArgs(selfRequestArgs);
                    responseArgs.setException(e);
                    selfCallback.invoke(responseArgs);
                }
            }
        });
    }

    @Override
    public HttpResponseArgs sendText(HttpRequestArgs requestArgs) throws Exception {
        if (requestArgs.getTextContent() != null) {
            requestArgs.setBinaryContent(Encoding.getUTF8().getBytes(requestArgs.getTextContent()));
        }
        HttpResponseArgs responseArgs = this.sendBinary(requestArgs);
        String contentTypeKey = null;
        for (String headerKey : responseArgs.getHeaders().keySet()) {
            if (!headerKey.equalsIgnoreCase("content-type")) continue;
            contentTypeKey = headerKey;
            break;
        }
        if (responseArgs.getBinaryContent() != null && contentTypeKey != null && !responseArgs.getHeaders().get(contentTypeKey).equals("application/octet-stream")) {
            try {
                responseArgs.setTextContent(Encoding.getUTF8().getString(responseArgs.getBinaryContent(), 0, responseArgs.getBinaryContent().length));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return responseArgs;
    }

    @Override
    public void sendTextAsync(HttpRequestArgs requestArgs, SingleAction<HttpResponseArgs> callback) {
        if (requestArgs.getTextContent() != null) {
            requestArgs.setBinaryContent(Encoding.getUTF8().getBytes(requestArgs.getTextContent()));
        }
        requestArgs.setDynamicValue(this.callbackKey, callback);
        final HttpWebRequestTransfer self = this;
        this.sendBinaryAsync(requestArgs, new SingleAction<HttpResponseArgs>(){

            @Override
            public void invoke(HttpResponseArgs responseArgs) {
                self.sendTextAsyncCallback(responseArgs);
            }
        });
    }

    private void sendTextAsyncCallback(HttpResponseArgs responseArgs) {
        SingleAction callback = (SingleAction)responseArgs.getRequestArgs().getDynamicValue(this.callbackKey);
        if (responseArgs.getBinaryContent() != null && !responseArgs.getHeaders().get("Content-Type").equals("application/octet-stream")) {
            try {
                responseArgs.setTextContent(Encoding.getUTF8().getString(responseArgs.getBinaryContent(), 0, responseArgs.getBinaryContent().length));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        callback.invoke(responseArgs);
    }
}

