/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.AddressType;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.stun.AddressFamily;
import fm.icelink.stun.Attribute;

public class AlternateServerAttribute
extends Attribute {
    private String _ipAddress;
    private int _port;

    public AlternateServerAttribute(String ipAddress, int port) {
        this.setIPAddress(TransportAddress.sanitizeIPAddress(ipAddress));
        this.setPort(port);
    }

    private AlternateServerAttribute() {
    }

    public static AlternateServerAttribute fromValueBytes(byte[] valueBytes) {
        AddressType type;
        if (valueBytes[1] == AddressFamily.getIPv4()) {
            type = AddressType.IPv4;
        } else if (valueBytes[1] == AddressFamily.getIPv6()) {
            type = AddressType.IPv6;
        } else {
            return null;
        }
        int num = Binary.fromBytes16(valueBytes, 2, false);
        int count = Global.equals((Object)type, (Object)AddressType.IPv4) ? 4 : 16;
        byte[] addressBytes = BitAssistant.subArray(valueBytes, 4, count);
        String str = StringExtensions.empty;
        try {
            str = TransportAddress.sanitizeIPAddress(LocalNetwork.getAddress(addressBytes));
        }
        catch (Exception exception1) {
            str = Global.equals((Object)type, (Object)AddressType.IPv4) ? Attribute.getBlankIPv4Address() : Attribute.getBlankIPv6Address();
        }
        AlternateServerAttribute attribute = new AlternateServerAttribute();
        attribute.setPort(num);
        attribute.setIPAddress(str);
        return attribute;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    @Override
    protected byte[] getValueBytes() {
        byte[] addressBytes;
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)0);
        AddressType addressType = LocalNetwork.getAddressType(this.getIPAddress());
        if (Global.equals((Object)addressType, (Object)AddressType.IPv4)) {
            bytes.add((byte)1);
        } else if (Global.equals((Object)addressType, (Object)AddressType.IPv6)) {
            bytes.add((byte)2);
        }
        byte[] buffer = Binary.toBytes16(this.getPort(), false);
        bytes.addRange(buffer);
        try {
            addressBytes = LocalNetwork.getAddressBytes(this.getIPAddress());
        }
        catch (Exception exception1) {
            addressBytes = Global.equals((Object)addressType, (Object)AddressType.IPv4) ? Attribute.getBlankIPv4AddressBytes() : Attribute.getBlankIPv6AddressBytes();
        }
        bytes.addRange(addressBytes);
        return bytes.toArray();
    }

    public void setIPAddress(String value) {
        this._ipAddress = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    public String toString() {
        return StringExtensions.format("ALTERNATE-SERVER {0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }
}

