/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IMediaSource;
import fm.icelink.IVideoSource;
import fm.icelink.LayoutScale;
import fm.icelink.ManagedStopwatch;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferColor;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoSink;

public abstract class ViewSink<T>
extends VideoSink {
    private ManagedStopwatch __stopwatch;
    private boolean _isRecording;

    @Override
    protected void doDestroy() {
        if (this.__stopwatch != null) {
            this.__stopwatch.stop();
            this.__stopwatch = null;
        }
    }

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer;
        if (this.__stopwatch == null) {
            this.__stopwatch = new ManagedStopwatch();
            this.__stopwatch.start();
        }
        if (this.getIsRecording() && this.__stopwatch.getElapsedTicks() / ManagedStopwatch.getFrequency() % 4L >= 2L) {
            buffer = inputBuffer.clone();
            buffer.setDataBuffers(new DataBuffer[ArrayExtensions.getLength(inputBuffer.getDataBuffers())]);
            for (int i = 0; i < ArrayExtensions.getLength(inputBuffer.getDataBuffers()); ++i) {
                buffer.getDataBuffers()[i] = DataBuffer.allocate(inputBuffer.getDataBuffers()[i].getLength());
                buffer.getDataBuffers()[i].write(inputBuffer.getDataBuffers()[i], 0);
            }
            if (this.getViewMirror()) {
                buffer.drawEllipse(inputBuffer.getWidth() - 40, inputBuffer.getHeight() - 40, 20, 20, VideoBufferColor.getRed(), true);
            } else {
                buffer.drawEllipse(20, inputBuffer.getHeight() - 40, 20, 20, VideoBufferColor.getRed(), true);
            }
        } else {
            buffer = inputBuffer;
        }
        this.renderBuffer(buffer);
    }

    public boolean getIsRecording() {
        return this._isRecording;
    }

    public abstract T getView();

    public abstract boolean getViewMirror();

    public abstract LayoutScale getViewScale();

    protected abstract void renderBuffer(VideoBuffer var1);

    public void setIsRecording(boolean value) {
        this._isRecording = value;
    }

    public abstract void setViewMirror(boolean var1);

    public abstract void setViewScale(LayoutScale var1);

    public ViewSink(VideoFormat inputFormat) {
        super(inputFormat);
    }

    public ViewSink() {
    }

    public ViewSink(IVideoSource source) {
        this((VideoFormat)source.getOutputFormat());
        super.addSource(source);
    }

    public ViewSink(IVideoSource[] sources) {
        this((VideoFormat)sources[0].getOutputFormat());
        super.addSources((IMediaSource[])sources);
    }
}

