/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.SessionDescriptionType;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.Origin;
import java.util.HashMap;

public class SessionDescription {
    private boolean _renegotiation;
    private Message _sdpMessage;
    private String _tieBreaker;
    private SessionDescriptionType _type;

    public static SessionDescription fromJson(String sessionDescriptionJson) {
        return JsonSerializer.deserializeObject(sessionDescriptionJson, new IFunction0<SessionDescription>(){

            @Override
            public SessionDescription invoke() {
                return new SessionDescription();
            }
        }, new IAction3<SessionDescription, String, String>(){

            @Override
            public void invoke(SessionDescription sessionDescription, String name, String valueJson) {
                String str = name;
                if (str != null) {
                    if (!Global.equals(str, "sdpMessage")) {
                        if (Global.equals(str, "tieBreaker")) {
                            sessionDescription.setTieBreaker(JsonSerializer.deserializeString(valueJson));
                        } else if (Global.equals(str, "isOffer")) {
                            sessionDescription.setType(JsonSerializer.deserializeBoolean(valueJson).hasValue() && JsonSerializer.deserializeBoolean(valueJson).getValue() ? SessionDescriptionType.Offer : SessionDescriptionType.Answer);
                        }
                    } else {
                        sessionDescription.setSdpMessage(Message.parse(JsonSerializer.deserializeString(valueJson)));
                    }
                }
            }
        });
    }

    public boolean getIsOffer() {
        return Global.equals((Object)this.getType(), (Object)SessionDescriptionType.Offer);
    }

    boolean getRenegotiation() {
        return this._renegotiation;
    }

    public Message getSdpMessage() {
        return this._sdpMessage;
    }

    public long getSessionId() {
        Origin origin;
        if (this.getSdpMessage() != null && (origin = this.getSdpMessage().getOrigin()) != null) {
            return origin.getSessionId();
        }
        return -1L;
    }

    public long getSessionVersion() {
        Origin origin;
        if (this.getSdpMessage() != null && (origin = this.getSdpMessage().getOrigin()) != null) {
            return origin.getSessionVersion();
        }
        return -1L;
    }

    public String getTieBreaker() {
        return this._tieBreaker;
    }

    public SessionDescriptionType getType() {
        return this._type;
    }

    void setRenegotiation(boolean value) {
        this._renegotiation = value;
    }

    public void setSdpMessage(Message value) {
        this._sdpMessage = value;
    }

    public void setTieBreaker(String value) {
        this._tieBreaker = value;
    }

    public void setType(SessionDescriptionType value) {
        this._type = value;
    }

    public String toJson() {
        return SessionDescription.toJson(this);
    }

    public static String toJson(final SessionDescription sessionDescription) {
        return JsonSerializer.serializeObject(sessionDescription, new IAction2<SessionDescription, HashMap<String, String>>(){

            @Override
            public void invoke(SessionDescription sd, HashMap<String, String> jsonObject) {
                if (sessionDescription.getSdpMessage() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "sdpMessage", JsonSerializer.serializeString(sessionDescription.getSdpMessage().toString()));
                }
                if (sessionDescription.getTieBreaker() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "tieBreaker", JsonSerializer.serializeString(sessionDescription.getTieBreaker()));
                }
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "isOffer", JsonSerializer.serializeBoolean(new NullableBoolean(sessionDescription.getIsOffer())));
            }
        });
    }
}

