/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.FecConfig;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISink;
import fm.icelink.ISource;
import fm.icelink.IceCandidate;
import fm.icelink.IceCandidatePair;
import fm.icelink.IceTransport;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterConfig;
import fm.icelink.JsonSerializer;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaSinkCollection;
import fm.icelink.MediaSourceCollection;
import fm.icelink.MediaStreamBase;
import fm.icelink.MediaTransportState;
import fm.icelink.NackConfig;
import fm.icelink.PliControlFrame;
import fm.icelink.RtpParameters;
import fm.icelink.RtpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.DirectionAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.rtcp.Attribute;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttributeType;
import fm.icelink.sdp.rtcp.MuxAttribute;
import fm.icelink.sdp.rtp.MapAttribute;
import fm.icelink.sdp.rtp.Media;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.rtp.SsrcAttributeName;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaStream<TISource extends IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISourceCollection extends MediaSourceCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISourceCollection>, TISink extends IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISinkCollection extends MediaSinkCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISinkCollection>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaStreamBase
implements ISource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
ISink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
IElement {
    private TFormatCollection __localFormatRegistry;
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private ArrayList<TFormat> __payloadTypeRegistry;
    private ArrayList<String> __payloadTypesRegisteredByOtherStreams;
    private TFormatCollection __remoteFormatRegistry;
    private boolean __remoteSupportsPli = false;
    private int __rtpPayloadTypeDynamicOffset = 96;
    private int __rtpPayloadTypeMaxOffset = 127;
    private TISinkCollection __sinks;
    private TISourceCollection __sources;
    private boolean _disableAutomaticReports;
    private FecConfig _fecConfig;
    private TFormat _inputFormat;
    private JitterConfig _jitterConfig;
    private boolean _multiplexingSupported;
    private NackConfig _nackConfig;
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onProcessControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onProcessFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onProcessFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onRaiseControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onRaiseFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaStream.this.__onRaiseFrame)) {
                action.invoke(p0);
            }
        }
    };
    private TFormat _outputFormat;
    private RtpParameters<TFormat, TFormatCollection> _rtpParameters;
    private RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> _rtpTransport;

    private void addLocalFormat(TFormat format) {
        TFormat equivalent;
        int registeredPayloadType = ((MediaFormat)format).getRegisteredPayloadType();
        if (((Collection)this.__remoteFormatRegistry).getCount() > 0 && (equivalent = ((MediaFormatCollection)this.__remoteFormatRegistry).getEquivalent(format)) != null) {
            ((MediaFormat)format).setRegisteredPayloadType(((MediaFormat)equivalent).getRegisteredPayloadType());
            registeredPayloadType = ((MediaFormat)equivalent).getRegisteredPayloadType();
        }
        if (((MediaFormat)format).getRegisteredPayloadType() >= 0) {
            ((Collection)this.__localFormatRegistry).add(format);
            if (!this.payloadTypeIsRegistered(registeredPayloadType) && ((MediaFormat)format).getRegisteredPayloadType() >= 0) {
                this.__payloadTypeRegistry.add(format);
            }
        }
    }

    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onProcessControlFrames.add(value);
    }

    public void addOnProcessFrame(IAction1<TFrame> value) {
        this.__onProcessFrame.add(value);
    }

    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onRaiseControlFrames.add(value);
    }

    public void addOnRaiseFrame(IAction1<TFrame> value) {
        this.__onRaiseFrame.add(value);
    }

    @Override
    public void addSink(TISink sink) {
        ((Collection)this.__sinks).add(sink);
    }

    @Override
    public void addSinks(TISink[] sinks) {
        ((Collection)this.__sinks).addMany(sinks);
    }

    @Override
    public void addSource(TISource source) {
        ((Collection)this.__sources).add(source);
    }

    @Override
    public void addSources(TISource[] sources) {
        ((Collection)this.__sources).addMany(sources);
    }

    void cleanup() {
        ((MediaSinkCollection)this.__sinks).destroy();
        ((MediaSourceCollection)this.__sources).destroy();
    }

    protected abstract TFormat createFormat(MapAttribute var1);

    protected abstract TFormat createFormat(String var1, int var2, String var3, int var4);

    protected abstract TFormatCollection createMediaFormatCollection();

    @Override
    public MediaDescription createSdpMediaDescription(Message sdpMessage, boolean supportSdes, boolean isOffer, boolean renegotiation) {
        StreamDirection localDirection;
        this.getRtpParameters().setCanonicalName(super.getCanonicalName());
        MediaDescription description = super.createSdpMediaDescription(sdpMessage, supportSdes, isOffer, renegotiation);
        if (this.getMultiplexingSupported() && !Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.Inactive)) {
            description.addMediaAttribute(new MuxAttribute());
            String connectionAddress = "0.0.0.0";
            int port = 9;
            if (super.getCoreTransportRtcp() != null) {
                Object activeCandidatePair;
                IceTransport iceTransport = super.getCoreTransportRtcp().getIceTransport();
                if (iceTransport != null && (activeCandidatePair = iceTransport.getActiveCandidatePair()) != null) {
                    IceCandidate candidate = ((IceCandidatePair)activeCandidatePair).getLocal();
                    connectionAddress = candidate.getIPAddress();
                    port = candidate.getPort();
                }
            } else {
                port = 0;
            }
            description.addMediaAttribute(new Attribute(super.getDisabled() ? 0 : port, connectionAddress));
        }
        StreamDirection streamDirection = localDirection = isOffer && super.getRenegotiationPending() ? super.getPendingLocalDirection() : this.getDirection();
        if (!renegotiation) {
            if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.Unset)) {
                this.setLocalDirection(this.getDirectionCapabilities());
            }
            localDirection = isOffer ? this.getLocalDirection() : this.getDirection();
        }
        StreamDirection direction2 = localDirection;
        DirectionAttribute attribute = DirectionAttribute.generateDirectionAttribute(direction2);
        description.addMediaAttribute(attribute);
        for (MediaDescription description2 : sdpMessage.getMediaDescriptions()) {
            fm.icelink.sdp.Attribute[] rtpMapAttributes;
            for (fm.icelink.sdp.Attribute attribute2 : rtpMapAttributes = description2.getRtpMapAttributes()) {
                MapAttribute attribute3 = (MapAttribute)attribute2;
                this.__payloadTypesRegisteredByOtherStreams.add(IntegerExtensions.toString(attribute3.getPayloadType()));
            }
        }
        this.registerPayloadTypes();
        description.getMedia().setMediaType(MediaType.fromStreamType(super.getType()));
        description.getMedia().setTransportProtocol(super.getUseDtls() ? Media.getUdpTlsRtpSavpfTransportProtocol() : Media.getRtpSavpfTransportProtocol());
        description.getMedia().setFormatDescription(this.obtainFormatDescriptions());
        MapAttribute attribute4 = null;
        for (MediaFormat local : (MediaFormat[])((Collection)this.__localFormatRegistry).getValues()) {
            boolean flag = this.formatIsFec(local);
            if (!this.payloadTypeIsRegistered(local.getRegisteredPayloadType())) continue;
            attribute4 = new MapAttribute(local.getRegisteredPayloadType(), local.getName(), local.getClockRate(), local.getParameters());
            description.addMediaAttribute(attribute4);
            if (this.getNackConfig().getDisableBuffering() || flag) continue;
            FeedbackAttribute attribute5 = new FeedbackAttribute(local.getRegisteredPayloadType(), FeedbackAttributeType.getNack());
            attribute4.addRelatedRtcpFeedbackAttribute(attribute5);
        }
        return description;
    }

    protected abstract TISinkCollection createSinkCollection(TISource var1);

    protected abstract TISourceCollection createSourceCollection(TISink var1);

    private MediaControlFrame[] filterUnsupportedControlFrames(MediaControlFrame[] controlFrames) {
        ArrayList<MediaControlFrame> list = new ArrayList<MediaControlFrame>();
        for (MediaControlFrame frame : controlFrames) {
            if (!this.__remoteSupportsPli && frame instanceof PliControlFrame) continue;
            list.add(frame);
        }
        return list.toArray(new MediaControlFrame[0]);
    }

    private boolean formatIsFec(TFormat format) {
        return Global.equals(((MediaFormat)format).getName(), MediaFormat.getRedName()) || Global.equals(((MediaFormat)format).getName(), MediaFormat.getUlpFecName());
    }

    @Override
    StreamDirection getDirectionCapabilities() {
        boolean flag2;
        boolean flag = ArrayExtensions.getLength(this.getSources()) > 0;
        boolean bl = flag2 = ArrayExtensions.getLength(this.getSinks()) > 0;
        if (flag && flag2) {
            return StreamDirection.SendReceive;
        }
        if (flag) {
            return StreamDirection.SendOnly;
        }
        if (flag2) {
            return StreamDirection.ReceiveOnly;
        }
        return StreamDirection.Inactive;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    public FecConfig getFecConfig() {
        return this._fecConfig;
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public boolean getMultiplexed() {
        return super.getCoreTransportRtcp() == null;
    }

    public boolean getMultiplexingSupported() {
        return this._multiplexingSupported;
    }

    public NackConfig getNackConfig() {
        return this._nackConfig;
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSources(), ", ", this.getPipelineJsonSinks(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput(), ", ", this.getPipelineJsonOutput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", super.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromSink() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSources(), " }"});
    }

    @Override
    public String getPipelineJsonFromSource() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSinks(), " }"});
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"input\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"output\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    private String getPipelineJsonSinks() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaSink local : this.getSinks()) {
            list.add(local.getPipelineJsonFromSource());
        }
        return StringExtensions.concat("\"sinks\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonSources() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaSource local : this.getSources()) {
            list.add(local.getPipelineJsonFromSink());
        }
        return StringExtensions.concat("\"sources\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    TFormat getPreferredFormat() {
        if (((Collection)this.getRtpParameters().getNegotiatedFormats()).getCount() == 0) {
            return null;
        }
        return (TFormat)((MediaFormat[])((Collection)this.getRtpParameters().getNegotiatedFormats()).getValues())[0];
    }

    private TFormat getRegisteredFormat(int payloadType) {
        for (MediaFormat local : this.__payloadTypeRegistry) {
            if (local.getRegisteredPayloadType() != payloadType) continue;
            return (TFormat)local;
        }
        return null;
    }

    RtpParameters<TFormat, TFormatCollection> getRtpParameters() {
        return this._rtpParameters;
    }

    RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getRtpTransport() {
        return this._rtpTransport;
    }

    @Override
    public TISink getSink() {
        return (TISink)((IMediaSink)((Collection)this.__sinks).getValue());
    }

    @Override
    public TISink[] getSinks() {
        return (IMediaSink[])((Collection)this.__sinks).getValues();
    }

    @Override
    public TISource getSource() {
        return (TISource)((IMediaSource)((Collection)this.__sources).getValue());
    }

    @Override
    public TISource[] getSources() {
        return (IMediaSource[])((Collection)this.__sources).getValues();
    }

    public MediaStream(StreamType type, NackConfig nackConfig, JitterConfig jitterConfig, FecConfig fecConfig) {
        super(type);
        this.__payloadTypeRegistry = new ArrayList();
        this.__payloadTypesRegisteredByOtherStreams = new ArrayList();
        this.setMultiplexingSupported(true);
        this.setNackConfig(nackConfig);
        this.setJitterConfig(jitterConfig);
        this.setFecConfig(fecConfig);
        this.setRtpParameters(new RtpParameters(this.createMediaFormatCollection()));
        this.__sinks = this.createSinkCollection((IMediaSource)((Object)this));
        this.__sources = this.createSourceCollection((IMediaSink)((Object)this));
        this.__localFormatRegistry = this.createMediaFormatCollection();
        this.__remoteFormatRegistry = this.createMediaFormatCollection();
    }

    private String obtainFormatDescriptions() {
        StringBuilder builder = new StringBuilder();
        for (MediaFormat local : this.__payloadTypeRegistry) {
            if (local.getRegisteredPayloadType() < 0) continue;
            StringBuilderExtensions.append(builder, IntegerExtensions.toString(local.getRegisteredPayloadType()));
            StringBuilderExtensions.append(builder, " ");
        }
        return builder.toString();
    }

    private TFormatCollection obtainLocalRemoteFormatsUnion() {
        TFormatCollection local = this.createMediaFormatCollection();
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            for (MediaFormat local2 : (MediaFormat[])((Collection)this.__remoteFormatRegistry).getValues()) {
                ((Collection)local).add((MediaFormat)local2);
            }
            return local;
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendOnly)) {
            for (MediaFormat local2 : (MediaFormat[])((Collection)this.__localFormatRegistry).getValues()) {
                ((Collection)local).add((MediaFormat)local2);
            }
            return local;
        }
        for (MediaFormat local3 : (MediaFormat[])((Collection)this.__remoteFormatRegistry).getValues()) {
            if (!((MediaFormatCollection)this.__localFormatRegistry).hasEquivalent((MediaFormat)local3)) continue;
            ((Collection)local).add((MediaFormat)local3);
        }
        return local;
    }

    private TFormatCollection obtainSinkFormats() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaSink local2 : this.getSinks()) {
            if (((MediaFormatCollection)local).hasEquivalent(local2.getInputFormat())) continue;
            ((Collection)local).add(local2.getInputFormat());
        }
        return local;
    }

    private TFormatCollection obtainSourceFormats() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaSource local2 : this.getSources()) {
            if (((MediaFormatCollection)local).hasEquivalent(local2.getOutputFormat())) continue;
            ((Collection)local).add(local2.getOutputFormat());
        }
        return local;
    }

    private TFormatCollection obtainSourceSinkFormatsUnion() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaSource iMediaSource : this.getSources()) {
            if (((MediaFormatCollection)local).hasEquivalent(iMediaSource.getOutputFormat())) continue;
            ((Collection)local).add(iMediaSource.getOutputFormat());
        }
        for (IMediaElement iMediaElement : this.getSinks()) {
            if (((MediaFormatCollection)local).hasEquivalent(iMediaElement.getInputFormat())) continue;
            ((Collection)local).add(iMediaElement.getInputFormat());
        }
        return local;
    }

    private boolean payloadTypeIsRegistered(int payloadType) {
        return this.getRegisteredFormat(payloadType) != null;
    }

    @Override
    protected void processCachedSettings() {
        super.processCachedSettings();
        if (super.getRenegotiationPending()) {
            this.setLocalDirection(super.getPendingLocalDirection());
        }
    }

    public void processControlFrames(MediaControlFrame[] controlFrames) {
        if (!this.__remoteSupportsPli) {
            controlFrames = this.filterUnsupportedControlFrames(controlFrames);
        }
        if (ArrayExtensions.getLength(controlFrames) > 0) {
            RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport;
            IAction1<MediaControlFrame[]> onProcessControlFrames = this._onProcessControlFrames;
            if (onProcessControlFrames != null) {
                onProcessControlFrames.invoke(controlFrames);
            }
            if ((rtpTransport = this.getRtpTransport()) != null) {
                rtpTransport.sendControlFrames(controlFrames);
            }
        }
    }

    public boolean processFrame(TFrame frame) {
        RtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport;
        IAction1<TFrame> onProcessFrame = this._onProcessFrame;
        if (onProcessFrame != null) {
            onProcessFrame.invoke(frame);
        }
        if ((rtpTransport = this.getRtpTransport()) == null || !Global.equals((Object)rtpTransport.getState(), (Object)MediaTransportState.Started)) {
            return false;
        }
        Object local = ((MediaFrame)frame).clone();
        ((MediaFrame)local).setTimestamp(((MediaFrame)frame).getTimestamp());
        ((MediaFrame)local).setDuration(((MediaFrame)frame).getDuration());
        ((MediaFrame)local).removeBuffers();
        for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
            MediaBuffer buffer = frame.getBuffers()[i];
            if (!((MediaFormat)buffer.getFormat()).getIsPacketized()) continue;
            ((MediaFrame)local).addBuffer(buffer);
            break;
        }
        if (ArrayExtensions.getLength(local.getBuffers()) == 0) {
            Log.error("No packetized formats in frame for stream to send.");
        }
        rtpTransport.sendFrame(local);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        Error error = super.processSdpMediaDescription(sdpMessage, sdpMediaDescription, isLocalDescription, isOffer, isRenegotiation);
        if (error == null) {
            StreamDirection direction2;
            fm.icelink.sdp.Attribute[] ssrcAttributes;
            TFormat local3;
            fm.icelink.sdp.Attribute[] rtpMapAttributes;
            boolean supportsRtcpMultiplexing;
            StreamDirection streamDirection = sdpMediaDescription.getStreamDirection();
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = sdpMessage.getSessionLevelDirection();
            }
            if (!(supportsRtcpMultiplexing = sdpMediaDescription.getSupportsRtcpMultiplexing())) {
                supportsRtcpMultiplexing = sdpMessage.getSessionLevelRtcpMultiplexingSupport();
            }
            this.setMultiplexingSupported(this.getMultiplexingSupported() & supportsRtcpMultiplexing);
            if (isLocalDescription) {
                if (!Global.equals((Object)streamDirection, (Object)this.getDirection())) {
                    if (!isOffer) {
                        Log.debug("Local Stream direction was modified in outgoing SDP Answer message. This action may cause unintended consequences. Consider using Stream.ChangeDirection() interface instead.");
                    }
                    this.setLocalDirection(streamDirection);
                }
                for (IMediaSource iMediaSource : this.getSources()) {
                    iMediaSource.processSdpMediaDescriptionFromSink(sdpMediaDescription, isOffer, isLocalDescription);
                }
                for (IMediaSink iMediaSink : this.getSinks()) {
                    iMediaSink.processSdpMediaDescriptionFromSource(sdpMediaDescription, isOffer, isLocalDescription);
                }
                if (!isRenegotiation) {
                    rtpMapAttributes = sdpMediaDescription.getRtpMapAttributes();
                    for (fm.icelink.sdp.Attribute attribute : rtpMapAttributes) {
                        local3 = this.createFormat((MapAttribute)attribute);
                        if (this.validateMapAttribute(local3, isLocalDescription)) continue;
                        Log.error("Invalid local map attribute.");
                        return new Error(ErrorCode.LocalDescriptionError);
                    }
                }
                ssrcAttributes = sdpMediaDescription.getSsrcAttributes();
                for (fm.icelink.sdp.Attribute attribute : ssrcAttributes) {
                    this.validateSsrcAttribute((SsrcAttribute)attribute, isLocalDescription);
                }
            } else {
                this.setRemoteDirection(streamDirection);
                if (!isRenegotiation) {
                    ((MediaFormatCollection)this.__remoteFormatRegistry).removeAll();
                    rtpMapAttributes = sdpMediaDescription.getRtpMapAttributes();
                    for (fm.icelink.sdp.Attribute attribute : rtpMapAttributes) {
                        local3 = this.createFormat((MapAttribute)attribute);
                        if (!this.validateMapAttribute(local3, isLocalDescription)) continue;
                        ((Collection)this.__remoteFormatRegistry).add(local3);
                    }
                }
                ssrcAttributes = sdpMediaDescription.getSsrcAttributes();
                for (fm.icelink.sdp.Attribute attribute : ssrcAttributes) {
                    if (this.validateSsrcAttribute((SsrcAttribute)attribute, isLocalDescription)) continue;
                    Log.error("Remote description contains an invalid SSRC.");
                    return new Error(ErrorCode.RemoteDescriptionError);
                }
                for (IMediaSource iMediaSource : this.getSources()) {
                    iMediaSource.processSdpMediaDescriptionFromSink(sdpMediaDescription, isOffer, isLocalDescription);
                }
                for (IMediaSink iMediaSink : this.getSinks()) {
                    iMediaSink.processSdpMediaDescriptionFromSource(sdpMediaDescription, isOffer, isLocalDescription);
                }
            }
            if (!isRenegotiation) {
                fm.icelink.sdp.Attribute[] attributeArray4;
                void var15_33;
                fm.icelink.sdp.Attribute[] attributeArray3;
                fm.icelink.sdp.Attribute[] attributeArray = attributeArray3 = sdpMediaDescription.getRtpMapAttributes();
                int n = attributeArray.length;
                boolean bl = false;
                while (var15_33 < n) {
                    fm.icelink.sdp.Attribute attribute2 = attributeArray[var15_33];
                    if (isLocalDescription) {
                        FeedbackAttribute relatedNackPliFeedbackAttribute;
                        if (!isOffer && !this.__remoteSupportsPli && (relatedNackPliFeedbackAttribute = ((MapAttribute)attribute2).getRelatedNackPliFeedbackAttribute()) != null) {
                            ((MapAttribute)attribute2).removeRelatedRtcpFeedbackAttribute(relatedNackPliFeedbackAttribute);
                        }
                    } else if (((MapAttribute)attribute2).getRelatedNackPliFeedbackAttribute() != null) {
                        this.__remoteSupportsPli = true;
                    }
                    ++var15_33;
                }
                fm.icelink.sdp.Attribute[] attributeArray2 = attributeArray4 = sdpMediaDescription.getSsrcAttributes();
                int n2 = attributeArray2.length;
                for (int i = 0; i < n2; ++i) {
                    fm.icelink.sdp.Attribute attribute5 = attributeArray2[i];
                    if (isLocalDescription) {
                        this.getRtpParameters().addLocalSynchronizationSource(((SsrcAttribute)attribute5).getSynchronizationSource());
                    } else {
                        this.getRtpParameters().addRemoteSynchronizationSource(((SsrcAttribute)attribute5).getSynchronizationSource());
                    }
                    StreamDirection _var0 = streamDirection;
                    if (_var0 != StreamDirection.ReceiveOnly && _var0 != StreamDirection.ReceiveOnly) continue;
                    sdpMediaDescription.removeMediaAttribute(attribute5);
                }
            }
            StreamDirection streamDirection2 = direction2 = isOffer && isLocalDescription ? this.getLocalDirection() : this.getDirection();
            if (!isRenegotiation) {
                this.setNegotiatedFormats(sdpMediaDescription);
                boolean flag2 = true;
                for (MediaFormat local4 : (MediaFormat[])((Collection)this.getRtpParameters().getNegotiatedFormats()).getValues()) {
                    if (!this.formatIsFec(local4)) continue;
                    flag2 = false;
                }
                this.getFecConfig().setDisabled(flag2);
            }
            if (Global.equals((Object)direction2, (Object)StreamDirection.ReceiveOnly)) {
                this.setInputFormat(null);
                this.setOutputFormat(this.getPreferredFormat());
            } else {
                if (Global.equals((Object)direction2, (Object)StreamDirection.SendOnly)) {
                    this.setInputFormat(this.getPreferredFormat());
                    this.setOutputFormat(null);
                    return error;
                }
                if (Global.equals((Object)direction2, (Object)StreamDirection.SendReceive)) {
                    this.setInputFormat(this.getPreferredFormat());
                    this.setOutputFormat(this.getPreferredFormat());
                } else {
                    TFormat local6 = null;
                    this.setInputFormat(local6);
                    this.setOutputFormat(null);
                }
            }
        }
        return error;
    }

    public Error processSdpMediaDescriptionFromSink(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    public Error processSdpMediaDescriptionFromSource(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    private void raiseControlFrames(MediaControlFrame[] controlFrames) {
        IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
        if (onRaiseControlFrames != null) {
            onRaiseControlFrames.invoke(controlFrames);
        }
        for (IMediaSource local : this.getSources()) {
            local.processControlFrames(controlFrames);
        }
    }

    private void raiseFrame(TFrame frame) {
        IAction1<TFrame> onRaiseFrame = this._onRaiseFrame;
        if (onRaiseFrame != null) {
            onRaiseFrame.invoke(frame);
        }
        boolean flag = false;
        for (IMediaSink local : this.getSinks()) {
            if (local.getDisabled() || !((MediaFrame)frame).hasBuffer(local.getInputFormat()) || !local.processFrame(frame)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            Log.debug("Stream could not raise frame to any sinks.");
        }
    }

    void receiveControlFrames(MediaControlFrame[] controlFrames) {
        this.raiseControlFrames(controlFrames);
    }

    void receiveFrame(TFrame frame) {
        this.raiseFrame(frame);
    }

    private void registerPayloadTypes() {
        int staticPayloadType;
        if (((Collection)this.__remoteFormatRegistry).getCount() == 0) {
            this.__payloadTypeRegistry.clear();
        }
        ((MediaFormatCollection)this.__localFormatRegistry).removeAll();
        int clockRate = 0;
        StreamDirection directionCapabilities = this.getDirectionCapabilities();
        TFormatCollection local = Global.equals((Object)directionCapabilities, (Object)StreamDirection.SendOnly) ? this.obtainSourceFormats() : (Global.equals((Object)directionCapabilities, (Object)StreamDirection.ReceiveOnly) ? this.obtainSinkFormats() : this.obtainSourceSinkFormatsUnion());
        for (int i = 0; i < ((Collection)local).getCount(); ++i) {
            staticPayloadType = -1;
            MediaFormat format = ((MediaFormat[])((Collection)local).getValues())[i];
            if (((Collection)this.__remoteFormatRegistry).getCount() == 0) {
                if (format.getStaticPayloadType() >= 0) {
                    String item = IntegerExtensions.toString(format.getStaticPayloadType());
                    if (this.__payloadTypesRegisteredByOtherStreams.contains(item)) {
                        Log.error(StringExtensions.format("Payload type {0} for {1} is already registered by another stream.", item, format.getFullName()));
                    } else {
                        staticPayloadType = format.getStaticPayloadType();
                    }
                } else {
                    staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                    while (this.__payloadTypesRegisteredByOtherStreams.contains(IntegerExtensions.toString(staticPayloadType))) {
                        ++this.__rtpPayloadTypeDynamicOffset;
                    }
                    if (staticPayloadType > this.__rtpPayloadTypeMaxOffset) {
                        Log.error(StringExtensions.format("Cannot add format {0}. Maximum dynamic payload types exceeded.", format.toString()));
                        staticPayloadType = -1;
                    }
                }
            }
            format.setRegisteredPayloadType(staticPayloadType);
            this.addLocalFormat(format);
            if (format.getRegisteredPayloadType() < 0 || clockRate != 0) continue;
            clockRate = format.getClockRate();
        }
        if (!this.getFecConfig().getDisabled() && clockRate > 0) {
            if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                this.addLocalFormat(this.createFormat(MediaFormat.getRedName(), clockRate, null, staticPayloadType));
                staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                this.addLocalFormat(this.createFormat(MediaFormat.getUlpFecName(), clockRate, null, staticPayloadType));
            } else {
                Log.error("FEC is only supported for video streams.");
            }
        }
    }

    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
    }

    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
    }

    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
    }

    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
    }

    @Override
    public boolean removeSink(TISink sink) {
        return ((Collection)this.__sinks).remove(sink);
    }

    @Override
    public boolean removeSinks(TISink[] sinks) {
        return ((Collection)this.__sinks).removeMany(sinks);
    }

    @Override
    public void removeSinks() {
        ((Collection)this.__sinks).removeAll();
    }

    @Override
    public boolean removeSource(TISource source) {
        return ((Collection)this.__sources).remove(source);
    }

    @Override
    public boolean removeSources(TISource[] sources) {
        return ((Collection)this.__sources).removeMany(sources);
    }

    @Override
    public void removeSources() {
        ((Collection)this.__sources).removeAll();
    }

    @Override
    void reset() {
        super.reset();
        this.setRtpTransport(null);
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    private void setFecConfig(FecConfig value) {
        this._fecConfig = value;
    }

    protected void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    void setMultiplexingSupported(boolean value) {
        this._multiplexingSupported = value;
    }

    private void setNackConfig(NackConfig value) {
        this._nackConfig = value;
    }

    private void setNegotiatedFormats(MediaDescription mediaDescription) {
        String formatDescription = mediaDescription.getMedia().getFormatDescription();
        if (!StringExtensions.isNullOrEmpty(formatDescription)) {
            int[] payloadTypes = Media.getPayloadTypes(formatDescription);
            TFormatCollection local = this.obtainLocalRemoteFormatsUnion();
            for (int num : payloadTypes) {
                TFormat equivalent;
                TFormat registeredFormat = this.getRegisteredFormat(num);
                if (registeredFormat == null || (equivalent = ((MediaFormatCollection)local).getEquivalent(registeredFormat)) == null) continue;
                if (!this.getRtpParameters().getPayloadTypeRegistry().containsKey(IntegerExtensions.toString(num))) {
                    HashMapExtensions.add(this.getRtpParameters().getPayloadTypeRegistry(), IntegerExtensions.toString(num), equivalent);
                }
                ((Collection)this.getRtpParameters().getNegotiatedFormats()).add(equivalent);
            }
        }
    }

    protected void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    private void setRtpParameters(RtpParameters<TFormat, TFormatCollection> value) {
        this._rtpParameters = value;
    }

    void setRtpTransport(RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        this._rtpTransport = value;
    }

    private boolean validateMapAttribute(TFormat mapAttributeFormat, boolean isLocalDescription) {
        if (mapAttributeFormat != null) {
            int registeredPayloadType = ((MediaFormat)mapAttributeFormat).getRegisteredPayloadType();
            TFormat registeredFormat = this.getRegisteredFormat(registeredPayloadType);
            if (registeredFormat == null || !((MediaFormat)registeredFormat).isEquivalent(mapAttributeFormat) || ((MediaFormat)registeredFormat).getRegisteredPayloadType() != registeredPayloadType) {
                if (((Collection)this.__localFormatRegistry).getCount() <= 0) {
                    return true;
                }
                registeredFormat = ((MediaFormatCollection)this.__localFormatRegistry).getEquivalent(mapAttributeFormat);
                if (registeredFormat == null) {
                    return false;
                }
                if (isLocalDescription) {
                    int num2 = ((MediaFormat)mapAttributeFormat).getRegisteredPayloadType();
                    int num3 = ((MediaFormat)registeredFormat).getRegisteredPayloadType();
                    ((MediaFormat)registeredFormat).setRegisteredPayloadType(num2);
                } else {
                    ((Collection)this.__remoteFormatRegistry).add(registeredFormat);
                }
            }
            return true;
        }
        return false;
    }

    private boolean validateSsrcAttribute(SsrcAttribute attribute, boolean isLocalDescription) {
        if (isLocalDescription) {
            if (Global.equals(attribute.getName(), SsrcAttributeName.getCName())) {
                if (attribute.getValue() == null) {
                    attribute.setValue(this.getRtpParameters().getCanonicalName());
                } else if (!Global.equals(attribute.getValue(), this.getRtpParameters().getCanonicalName())) {
                    Log.error("Canonical name of a stream must match Connection.Id");
                    return false;
                }
            }
            this.getRtpParameters().addLocalSynchronizationSource(attribute.getSynchronizationSource());
        } else if (Global.equals(attribute.getName(), SsrcAttributeName.getCName())) {
            this.getRtpParameters().addRemoteSynchronizationSource(attribute.getSynchronizationSource());
        }
        return true;
    }
}

