/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.Error;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IFunction1;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISource;
import fm.icelink.JsonSerializer;
import fm.icelink.License;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaSinkCollection;
import fm.icelink.MediaSourceBase;
import fm.icelink.MediaSourceState;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.Stream;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.rtp.SsrcAttributeName;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaSource<TISource extends IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISink extends IMediaSink<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>, TISinkCollection extends MediaSinkCollection<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat, TISinkCollection>, TSource extends MediaSource<TISource, TISink, TISinkCollection, TSource, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends MediaSourceBase
implements IMediaSource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
ISource<TISource, TISink, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private SourceInput __input = null;
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<TSource>> __onStateChange = new ArrayList<IAction1<TSource>>();
    private volatile boolean __processingControlFrames = false;
    private volatile boolean __raisingFrame = false;
    private TISinkCollection __sinks;
    private MediaSourceState __state;
    private Object __stateLock;
    private boolean _muted;
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

        @Override
        public void invoke(MediaControlFrame[] p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onProcessControlFrames)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TFrame> _onRaiseFrame = new IAction1<TFrame>(){

        @Override
        public void invoke(TFrame p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onRaiseFrame)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TSource> _onStateChange = new IAction1<TSource>(){

        @Override
        public void invoke(TSource p0) {
            for (IAction1 action : new ArrayList(MediaSource.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private TFormat _outputFormat;
    private long _synchronizationSource;

    @Override
    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        this.__onProcessControlFrames.add(value);
    }

    public void addOnRaiseFrame(IAction1<TFrame> value) {
        this.__onRaiseFrame.add(value);
    }

    public void addOnStateChange(IAction1<TSource> value) {
        this.__onStateChange.add(value);
    }

    @Override
    public void addSink(TISink sink) {
        this.validateSink(sink);
        ((Collection)this.__sinks).add(sink);
    }

    @Override
    public void addSinks(TISink[] sinks) {
        for (TISink local : sinks) {
            this.validateSink(local);
        }
        ((Collection)this.__sinks).addMany(sinks);
    }

    public Future<Object> changeInput(SourceInput input) {
        return this.doChangeInput(new Promise<Object>(), input);
    }

    protected abstract TISinkCollection createSinkCollection(TISource var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() {
        MediaSourceState state;
        Object obj2;
        Object object = obj2 = this.__stateLock;
        synchronized (object) {
            MediaSourceState _var0 = this.getState();
            if (_var0 == MediaSourceState.Starting) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is being started."));
            }
            if (_var0 == MediaSourceState.Started) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is started. (Stop the media source first.)"));
            }
            if (_var0 == MediaSourceState.Stopping) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is being stopped."));
            }
            if (_var0 == MediaSourceState.Destroying) {
                throw new RuntimeException(new Exception("A media source cannot be destroyed while it is being destroyed on a different thread."));
            }
            if (_var0 == MediaSourceState.Destroyed) {
                return true;
            }
            state = this.getState();
            this.setState(MediaSourceState.Destroying);
        }
        Log.debug(StringExtensions.format("Media source ({0}) is being destroyed.", this.getLabel()));
        try {
            this.doDestroy();
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.setState(MediaSourceState.Destroyed);
            }
            ((MediaSinkCollection)this.__sinks).destroy();
            return true;
        }
        catch (Exception obj1) {
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                this.setState(state);
            }
            return false;
        }
    }

    private Future<Object> doChangeInput(final Promise<Object> promise, final SourceInput input) {
        IAction0 action = null;
        IAction1<Object> resolveAction = null;
        IAction1<Exception> rejectAction = null;
        IFunction1<Object, Future<Object>> resolveFunction = null;
        IAction1<Exception> action4 = null;
        IAction0 action5 = null;
        if (Global.equals(input, this.__input)) {
            if (action == null) {
                action = new IAction0(){

                    @Override
                    public void invoke() {
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action);
        } else if (Global.equals((Object)this.getState(), (Object)MediaSourceState.Started)) {
            if (resolveFunction == null) {
                resolveFunction = new IFunction1<Object, Future<Object>>(){

                    @Override
                    public Future<Object> invoke(Object result) {
                        MediaSource.this.setInput(input);
                        return MediaSource.this.start();
                    }
                };
            }
            if (action4 == null) {
                action4 = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        promise.reject(exception);
                    }
                };
            }
            if (resolveAction == null) {
                resolveAction = new IAction1<Object>(){

                    @Override
                    public void invoke(Object result) {
                        promise.resolve(null);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        promise.reject(exception);
                    }
                };
            }
            this.stop().then(resolveFunction, action4).then(resolveAction, rejectAction);
        } else {
            if (action5 == null) {
                action5 = new IAction0(){

                    @Override
                    public void invoke() {
                        MediaSource.this.setInput(input);
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action5);
        }
        return promise;
    }

    protected void doDestroy() {
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription && ArrayExtensions.getLength(mediaDescription.getSsrcAttributes(this.getSynchronizationSource(), SsrcAttributeName.getCName())) == 0) {
            mediaDescription.addMediaAttribute(new SsrcAttribute(this.getSynchronizationSource(), SsrcAttributeName.getCName()));
        }
        return null;
    }

    protected abstract Future<Object> doStart();

    protected abstract Future<Object> doStop();

    public SourceInput getInput() {
        return this.__input;
    }

    public SourceInput[] getInputs() {
        return new SourceInput[0];
    }

    @Override
    public boolean getMuted() {
        return this._muted;
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonSinks(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonOutput()});
    }

    @Override
    public String getPipelineJsonFromSink() {
        return StringExtensions.concat("{ ", this.getPipelineJsonBase(), " }");
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"output\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    private String getPipelineJsonSinks() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaSink local : this.getSinks()) {
            list.add(local.getPipelineJsonFromSource());
        }
        return StringExtensions.concat("\"sinks\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    @Override
    public TISink getSink() {
        return (TISink)((IMediaSink)((Collection)this.__sinks).getValue());
    }

    @Override
    public TISink[] getSinks() {
        return (IMediaSink[])((Collection)this.__sinks).getValues();
    }

    public MediaSourceState getState() {
        return this.__state;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    public boolean hasSink(TISink sink) {
        for (IMediaSink local : this.getSinks()) {
            if (local != sink) continue;
            return true;
        }
        return false;
    }

    public MediaSource(TFormat outputFormat) {
        this.__state = MediaSourceState.New;
        this.__stateLock = new Object();
        License.checkKey();
        this.setOutputFormat(outputFormat);
        this.setSynchronizationSource(Utility.generateSynchronizationSource());
        this.__sinks = this.createSinkCollection(this);
    }

    @Override
    public void processControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
            this.__processingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
                    IAction1<MediaControlFrame[]> onProcessControlFrames = this._onProcessControlFrames;
                    if (onProcessControlFrames != null) {
                        onProcessControlFrames.invoke(controlFrames);
                    }
                    this.doProcessControlFrames(controlFrames);
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media source ({0}) could not process control frames.", this.getLabel()), exception);
            }
            finally {
                this.__processingControlFrames = false;
            }
        }
    }

    @Override
    public Error processSdpMediaDescriptionFromSink(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
            this.__raisingFrame = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaSourceState.Started)) {
                    Object[] sinks;
                    IAction1<TFrame> onRaiseFrame;
                    for (MediaBuffer local : frame.getBuffers()) {
                        if (StringExtensions.isNullOrEmpty(local.getSourceId())) {
                            local.setSourceId(super.getId());
                        }
                        if (!this.getMuted()) continue;
                        local.mute();
                    }
                    if (((MediaFrame)frame).getSynchronizationSource() == -1L) {
                        ((MediaFrame)frame).setSynchronizationSource(this.getSynchronizationSource());
                    }
                    if ((onRaiseFrame = this._onRaiseFrame) != null) {
                        onRaiseFrame.invoke(frame);
                    }
                    if (ArrayExtensions.getLength(sinks = this.getSinks()) > 0) {
                        for (Object local2 : sinks) {
                            if (local2.getDisabled()) continue;
                            local2.processFrame(frame);
                        }
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media source ({0}) could not raise frame.", this.getLabel()), exception);
            }
            finally {
                this.__raisingFrame = false;
            }
        }
    }

    @Override
    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
    }

    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
    }

    public void removeOnStateChange(IAction1<TSource> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    @Override
    public boolean removeSink(TISink sink) {
        return ((Collection)this.__sinks).remove(sink);
    }

    @Override
    public void removeSinks() {
        ((Collection)this.__sinks).removeAll();
    }

    @Override
    public boolean removeSinks(TISink[] sinks) {
        return ((Collection)this.__sinks).removeMany(sinks);
    }

    protected void setInput(SourceInput value) {
        this.__input = value;
    }

    @Override
    public void setMuted(boolean value) {
        this._muted = value;
    }

    private void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    public void setSink(TISink value) {
        this.removeSinks();
        this.addSink(value);
    }

    public void setSinks(TISink[] value) {
        this.removeSinks();
        this.addSinks((IMediaSink[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MediaSourceState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TSource> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    public void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    @Override
    public Future<Object> start() {
        return this.startInternal(new Promise<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Object> startInternal(final Promise<Object> promise) {
        Object object = this.__stateLock;
        synchronized (object) {
            MediaSourceState _var0 = this.getState();
            if (_var0 == MediaSourceState.Starting) {
                promise.reject(new Exception("A media source cannot be started while it is being started on a different thread."));
                return promise;
            }
            if (_var0 == MediaSourceState.Started) {
                promise.resolve(null);
                return promise;
            }
            if (_var0 == MediaSourceState.Stopping) {
                promise.reject(new Exception("A media source cannot be started while it is being stopped."));
                return promise;
            }
            if (_var0 == MediaSourceState.Destroying) {
                promise.reject(new Exception("A media source cannot be started while it is being destroyed."));
                return promise;
            }
            if (_var0 == MediaSourceState.Destroyed) {
                promise.reject(new Exception("A media source cannot be started while it is destroyed."));
                return promise;
            }
            this.setState(MediaSourceState.Starting);
        }
        Log.debug(StringExtensions.format("Media source ({0}) is being started.", this.getLabel()));
        this.doStart().then(new IAction1<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Object result) {
                Log.debug(StringExtensions.format("Media source ({0}) has successfully started.", MediaSource.this.getLabel()));
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Started);
                    promise.resolve(result);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception exception) {
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Stopped);
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    @Override
    public Future<Object> stop() {
        return this.stopInternal(new Promise<Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Object> stopInternal(final Promise<Object> promise) {
        Object object = this.__stateLock;
        synchronized (object) {
            MediaSourceState _var0 = this.getState();
            if (_var0 == MediaSourceState.New) {
                promise.resolve(null);
                return promise;
            }
            if (_var0 == MediaSourceState.Starting) {
                promise.reject(new Exception("A media source cannot be stopped while it is being started."));
                return promise;
            }
            if (_var0 == MediaSourceState.Stopping) {
                promise.reject(new Exception("A media source cannot be stopped while it is being stopped on a different thread."));
                return promise;
            }
            if (_var0 == MediaSourceState.Stopped) {
                promise.resolve(null);
                return promise;
            }
            if (_var0 == MediaSourceState.Destroying) {
                promise.reject(new Exception("A media source cannot be stopped while it is being destroyed."));
                return promise;
            }
            if (_var0 == MediaSourceState.Destroyed) {
                promise.reject(new Exception("A media source cannot be stopped while it is destroyed."));
                return promise;
            }
            this.setState(MediaSourceState.Stopping);
        }
        Log.debug(StringExtensions.format("Media source ({0}) is being stopped.", this.getLabel()));
        while (this.__raisingFrame || this.__processingControlFrames) {
            ManagedThread.sleep(10);
        }
        this.doStop().then(new IAction1<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Object result) {
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Stopped);
                    promise.resolve(result);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception exception) {
                Object object = MediaSource.this.__stateLock;
                synchronized (object) {
                    MediaSource.this.setState(MediaSourceState.Started);
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    public String toString() {
        return this.getLabel();
    }

    private void validateSink(TISink sink) {
        if (!(sink instanceof Stream) && sink.getInputFormat() != null && !((MediaFormat)sink.getInputFormat()).isEquivalent(this.getOutputFormat())) {
            throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Input format [", ((MediaFormat)sink.getInputFormat()).toString(), "] of sink (", sink.getLabel(), ") does not match output format [", ((MediaFormat)this.getOutputFormat()).toString(), "] of source (", this.getLabel(), ")."})));
        }
    }
}

