/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.CompareResult;
import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.Sort;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class JitterBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private ArrayList<TFrame> __frameBuffer = new ArrayList();
    private Object __frameBufferLock = new Object();
    private int __increaseMillis = 10;
    private long __lastIncreaseTimestamp = -1L;
    private long __lastReturnedFrameIndex = -1L;
    private int __minIncreaseInterval = Constants.getTicksPerSecond();
    private int _clockRate;
    private int _length;
    private int _maxLength;
    private int _minLength;
    private String _name;
    private int _retransmissionTimeout;

    private boolean canIncreaseLength() {
        return this.__lastIncreaseTimestamp == -1L || DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__lastIncreaseTimestamp > (long)this.__minIncreaseInterval;
    }

    private CompareResult compareFrameIndexes(TFrame frame1, TFrame frame2) {
        long num = ((MediaBuffer)((MediaFrame)frame1).getBuffer()).getSequenceNumber() - ((MediaBuffer)((MediaFrame)frame2).getBuffer()).getSequenceNumber();
        if (num > 0L) {
            return CompareResult.Positive;
        }
        if (num < 0L) {
            return CompareResult.Negative;
        }
        return CompareResult.Equal;
    }

    public int getClockRate() {
        return this._clockRate;
    }

    private int getDeltaMillis() {
        long num3;
        if (ArrayListExtensions.getCount(this.__frameBuffer) == 0) {
            return -1;
        }
        int num = ArrayListExtensions.getCount(this.__frameBuffer) - 1;
        MediaFrame local = (MediaFrame)ArrayListExtensions.getItem(this.__frameBuffer).get(num);
        long timestamp = local.getTimestamp();
        int num4 = (int)((timestamp - (num3 = (local = (MediaFrame)ArrayListExtensions.getItem(this.__frameBuffer).get(0)).getTimestamp())) * 1000L / (long)this.getClockRate());
        if (num4 < 0) {
            Log.debug("Timestamp reset detected on the remote stream.");
            return this.getLength() + 1;
        }
        return num4;
    }

    public int getLength() {
        return this._length;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public String getName() {
        return this._name;
    }

    public int getRetransmissionTimeout() {
        return this._retransmissionTimeout;
    }

    private void increaseLength() {
        int num = MathAssistant.min(this.getLength() + this.__increaseMillis, this.getMaxLength());
        if (num != this.getLength()) {
            Log.info(StringExtensions.format("Increasing {0} jitter buffer length to {1} ms.", this.getName(), IntegerExtensions.toString(num)));
            this.setLength(num);
        }
        this.__lastIncreaseTimestamp = DateExtensions.getTicks(DateExtensions.getUtcNow());
    }

    public JitterBuffer(String name, int clockRate, int length, int maxLength) {
        this.setName(name);
        this.setLength(length);
        this.setMaxLength(maxLength);
        this.setClockRate(clockRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TFrame> pull() {
        ArrayList<TFrame> list = new ArrayList<TFrame>();
        Object object = this.__frameBufferLock;
        synchronized (object) {
            while (this.getDeltaMillis() > this.getLength()) {
                MediaFrame local = (MediaFrame)ArrayListExtensions.getItem(this.__frameBuffer).get(0);
                this.__lastReturnedFrameIndex = ((MediaBuffer)local.getBuffer()).getSequenceNumber();
                list.add(ArrayListExtensions.getItem(this.__frameBuffer).get(0));
                ArrayListExtensions.removeAt(this.__frameBuffer, 0);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(TFrame frame) {
        long num;
        if (!((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getIsPacketized()) {
            throw new RuntimeException(new Exception("The first Buffer of a Frame stored in a Jitter.Buffer must be of packetized format."));
        }
        if (ArrayExtensions.getLength(((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffers()) != 1) {
            throw new RuntimeException(new Exception("Jitter.Buffer only supports a Frame.Buffer.DataBuffers.Length of one."));
        }
        if (this.__lastReturnedFrameIndex != -1L && (num = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() - this.__lastReturnedFrameIndex) < 0L) {
            if (this.canIncreaseLength()) {
                this.increaseLength();
            }
            return false;
        }
        Object object = this.__frameBufferLock;
        synchronized (object) {
            this.__frameBuffer.add(frame);
            Sort.quickSort(this.__frameBuffer, new IFunctionDelegate2<TFrame, TFrame, CompareResult>(){

                @Override
                public String getId() {
                    return "fm.icelink.JitterBuffer<TFrame,TBuffer,TBufferCollection,TFormat>.compareFrameIndexes";
                }

                @Override
                public CompareResult invoke(TFrame frame1, TFrame frame2) {
                    return JitterBuffer.this.compareFrameIndexes(frame1, frame2);
                }
            });
        }
        return true;
    }

    private void setClockRate(int value) {
        this._clockRate = value;
    }

    private void setLength(int value) {
        this._length = value;
    }

    private void setMaxLength(int value) {
        this._maxLength = value;
    }

    private void setMinLength(int value) {
        this._minLength = value;
    }

    private void setName(String value) {
        this._name = value;
    }

    public void setRetransmissionTimeout(int value) {
        this._retransmissionTimeout = value;
    }
}

