/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.FecContext;
import fm.icelink.FecProtectionParameters;
import fm.icelink.FecRedPacket;
import java.util.ArrayList;

class FecProducer {
    private FecContext __fec;
    private ArrayList<DataBuffer> __fecPackets;
    private boolean __incompleteFrame = false;
    private ArrayList<DataBuffer> __mediaPackets = new ArrayList();
    private int __minimumMediaPackets = 1;
    private FecProtectionParameters __newParameters;
    private int __numFirstPartition = 0;
    private int __numFrames = 0;
    private FecProtectionParameters __parameters;

    public boolean addRtpPacketAndGenerateFec(DataBuffer dataBuffer, int payloadLength, int rtpHeaderLength) {
        boolean flag;
        if (ArrayListExtensions.getCount(this.__fecPackets) > 0) {
            throw new RuntimeException(new Exception("FEC packets not empty."));
        }
        if (ArrayListExtensions.getCount(this.__mediaPackets) == 0) {
            this.__parameters = this.__newParameters;
        }
        this.__incompleteFrame = true;
        boolean bl = flag = (dataBuffer.read8(1) & 0x80) > 0;
        if (ArrayListExtensions.getCount(this.__mediaPackets) < FecContext.getMaxMediaPackets()) {
            this.__mediaPackets.add(dataBuffer);
        }
        if (flag) {
            ++this.__numFrames;
            this.__incompleteFrame = false;
        }
        if (!this.__incompleteFrame && (this.__numFrames == this.__parameters.getMaxFecFrames() || this.getExcessOverheadBelowMax() && this.getMinimumMediaPacketsReached())) {
            if (this.__numFirstPartition > FecContext.getMaxMediaPackets()) {
                throw new RuntimeException(new Exception("Number of packets in the first partition exceeds the maximum allowed."));
            }
            boolean flag2 = this.__fec.generate(this.__mediaPackets, this.__parameters.getFecRate(), this.__numFirstPartition, this.__parameters.getUseUepProtection(), this.__parameters.getFecMaskType(), this.__fecPackets);
            if (ArrayListExtensions.getCount(this.__fecPackets) == 0) {
                this.__numFrames = 0;
                this.deletePackets();
            }
            return flag2;
        }
        return true;
    }

    public FecRedPacket buildRedPacket(DataBuffer dataBuffer, int payloadLength, int rtpHeaderLength, int redPayloadType) {
        FecRedPacket packet = new FecRedPacket(payloadLength + FecRedPacket.getRedForFecHeaderLength() + rtpHeaderLength);
        int payloadType = dataBuffer.read8(1) & 0x7F;
        packet.createHeader(dataBuffer, rtpHeaderLength, redPayloadType, payloadType);
        packet.assignPayload(dataBuffer, rtpHeaderLength, payloadLength);
        return packet;
    }

    private void deletePackets() {
        this.__mediaPackets.clear();
    }

    public FecProducer(FecContext fec) {
        this.__fecPackets = new ArrayList();
        this.__parameters = new FecProtectionParameters();
        this.__newParameters = new FecProtectionParameters();
        this.__fec = fec;
    }

    public boolean getExcessOverheadBelowMax() {
        return this.getOverhead() - this.__parameters.getFecRate() < FecRedPacket.getMaxExcessOverhead();
    }

    public boolean getFecAvailable() {
        return ArrayListExtensions.getCount(this.__fecPackets) > 0;
    }

    public FecRedPacket getFecPacket(int redPayloadType, int fecPayloadType, int sequenceNumber, int rtpHeaderLength) {
        if (ArrayListExtensions.getCount(this.__fecPackets) == 0) {
            return null;
        }
        DataBuffer payload = ArrayListExtensions.getItem(this.__fecPackets).get(0);
        DataBuffer rtpHeader = ArrayListExtensions.getItem(this.__mediaPackets).get(ArrayListExtensions.getCount(this.__mediaPackets) - 1);
        FecRedPacket packet = new FecRedPacket(payload.getLength() + FecRedPacket.getRedForFecHeaderLength() + rtpHeaderLength);
        packet.createHeader(rtpHeader, rtpHeaderLength, redPayloadType, fecPayloadType);
        packet.setSequenceNumber(sequenceNumber);
        packet.clearMarkerBit();
        packet.assignPayload(payload, 0, payload.getLength());
        ArrayListExtensions.removeAt(this.__fecPackets, 0);
        if (ArrayListExtensions.getCount(this.__fecPackets) == 0) {
            this.deletePackets();
            this.__numFrames = 0;
        }
        return packet;
    }

    public boolean getMinimumMediaPacketsReached() {
        float num = (float)ArrayListExtensions.getCount(this.__mediaPackets) / (float)this.__numFrames;
        if (num < 2.0f) {
            return ArrayListExtensions.getCount(this.__mediaPackets) >= this.__minimumMediaPackets;
        }
        return ArrayListExtensions.getCount(this.__mediaPackets) >= this.__minimumMediaPackets + 1;
    }

    private int getOverhead() {
        if (ArrayListExtensions.getCount(this.__mediaPackets) == 0) {
            return -1;
        }
        return (this.__fec.getNumberOfFecPackets(ArrayListExtensions.getCount(this.__mediaPackets), this.__parameters.getFecRate()) << 8) / ArrayListExtensions.getCount(this.__mediaPackets);
    }

    public void setFecParameters(FecProtectionParameters parameters, int numberFirstPartition) {
        if (numberFirstPartition > FecContext.getMaxMediaPackets()) {
            numberFirstPartition = FecContext.getMaxMediaPackets();
        }
        this.__newParameters = parameters;
        this.__numFirstPartition = numberFirstPartition;
        this.__minimumMediaPackets = parameters.getFecRate() > FecRedPacket.getHighProtectionThreshold() ? FecRedPacket.getMinimumMediaPackets() : 1;
    }
}

