/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataChannel;
import fm.icelink.DataChannelCollection;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Stream;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;

public abstract class DataStreamBase
extends Stream {
    private DataChannelCollection __channels = new DataChannelCollection();

    @Override
    public Error changeDirection(StreamDirection newDirection) {
        return new Error(ErrorCode.DataStreamDirectionCannotBeChanged, new Exception("Changes to Stream Direction of Data Streams are not permitted."));
    }

    public DataStreamBase(DataChannel[] channels) {
        super(StreamType.Application);
        this.__channels.addMany(channels);
    }

    public DataChannel[] getChannels() {
        return (DataChannel[])this.__channels.getValues();
    }

    @Override
    public StreamDirection getDirection() {
        return StreamDirection.SendReceive;
    }

    @Override
    StreamDirection getDirectionCapabilities() {
        return StreamDirection.SendReceive;
    }

    @Override
    public String getLabel() {
        return "Data Stream";
    }

    @Override
    public StreamDirection getLocalDirection() {
        return StreamDirection.SendReceive;
    }

    @Override
    protected StreamDirection getRemoteDirection() {
        return StreamDirection.SendReceive;
    }

    @Override
    public void setLocalDirection(StreamDirection value) {
        if (!Global.equals((Object)value, (Object)StreamDirection.SendReceive)) {
            throw new RuntimeException(new Exception("Local direction other than SendReceieve for DataStreams is not currently supported."));
        }
    }

    @Override
    protected void setRemoteDirection(StreamDirection value) {
        if (!Global.equals((Object)value, (Object)StreamDirection.SendReceive)) {
            throw new RuntimeException(new Exception("Remote direction other than SendReceieve for DataStreams is not currently supported."));
        }
    }
}

