/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.DataBuffer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AesCounterContext {
    private Cipher cipher;

    public AesCounterContext(DataBuffer key) {
        try {
            this.cipher = Cipher.getInstance("AES/ECB/NoPadding");
            this.cipher.init(1, new SecretKeySpec(key.getData(), key.getIndex(), key.getLength(), "AES"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void clear() {
    }

    public boolean generateKeystream(DataBuffer output, int length, byte[] counter) {
        try {
            for (int i = 0; i < length; i += 16) {
                this.cipher.update(counter, 0, 16, output.getData(), output.getIndex() + i);
                AesCounterContext.incrementCounter(counter);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void incrementCounter(byte[] counter) {
        int count = Binary.fromBytes16(counter, 14, false);
        Binary.toBytes16(count + 1, false, counter, 14);
    }
}

