/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.vp9;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferStream;

class Packet {
    private boolean _endOfLayerFrame;
    private boolean _extendedPictureID;
    private boolean _flexibleMode;
    private DataBuffer _header;
    private boolean _interPicturePredictedLayerFrame;
    private boolean _layerIndicesPresent;
    private DataBuffer _payload;
    private short _pictureID;
    private boolean _pictureIDPresent;
    private boolean _scalabilityStructurePresent;
    private boolean _startOfLayerFrame;

    private static Packet extractV00(DataBuffer packetBuffer, DataBufferStream stream) {
        Packet packet = new Packet();
        packet.setPictureIDPresent(stream.read1());
        packet.setInterPicturePredictedLayerFrame(stream.read1());
        packet.setLayerIndicesPresent(stream.read1());
        packet.setFlexibleMode(stream.read1());
        packet.setStartOfLayerFrame(stream.read1());
        packet.setEndOfLayerFrame(stream.read1());
        packet.setScalabilityStructurePresent(stream.read1());
        stream.nextByte();
        if (packet.getPictureIDPresent()) {
            packet.setExtendedPictureID(stream.read1());
            if (packet.getExtendedPictureID()) {
                packet.setPictureID((short)stream.read15());
            } else {
                packet.setPictureID((short)stream.read7());
            }
        }
        if (packet.getLayerIndicesPresent()) {
            if (packet.getFlexibleMode()) {
                stream.read3();
                stream.read1();
                stream.read3();
                stream.read1();
            } else {
                stream.read8();
                stream.read8();
            }
        }
        if (packet.getInterPicturePredictedLayerFrame() && packet.getFlexibleMode()) {
            boolean flag = false;
            do {
                stream.read7();
            } while (flag = stream.read1());
        }
        if (packet.getScalabilityStructurePresent()) {
            int num3;
            int num = stream.read3() + 1;
            boolean flag2 = stream.read1();
            int num2 = stream.read4() + 1;
            if (flag2) {
                for (num3 = 0; num3 < num; ++num3) {
                    stream.read16();
                    stream.read16();
                }
            }
            for (num3 = 0; num3 < num2; ++num3) {
                stream.read3();
                stream.read1();
                int num4 = stream.read2();
                stream.nextByte();
                for (int i = 0; i < num4; ++i) {
                    stream.read8();
                }
            }
        }
        packet.setPayload(packetBuffer.subset(stream.getPosition()));
        return packet;
    }

    private static Packet extractV02(DataBuffer packetBuffer, DataBufferStream stream) {
        Packet packet = new Packet();
        packet.setPictureIDPresent(stream.read1());
        packet.setInterPicturePredictedLayerFrame(stream.read1());
        packet.setLayerIndicesPresent(stream.read1());
        packet.setFlexibleMode(stream.read1());
        packet.setStartOfLayerFrame(stream.read1());
        packet.setEndOfLayerFrame(stream.read1());
        packet.setScalabilityStructurePresent(stream.read1());
        if (stream.read1()) {
            throw new RuntimeException(new Exception("VP9 RTP header failed sanity check for spec version 02."));
        }
        if (packet.getPictureIDPresent()) {
            packet.setExtendedPictureID(stream.read1());
            if (packet.getExtendedPictureID()) {
                packet.setPictureID((short)stream.read15());
            } else {
                packet.setPictureID((short)stream.read7());
            }
        }
        if (packet.getLayerIndicesPresent()) {
            stream.read3();
            stream.read1();
            stream.read3();
            stream.read1();
            if (!packet.getFlexibleMode()) {
                stream.read8();
            }
        }
        if (packet.getInterPicturePredictedLayerFrame() && packet.getFlexibleMode()) {
            boolean flag = false;
            do {
                stream.read7();
            } while (flag = stream.read1());
        }
        if (packet.getScalabilityStructurePresent()) {
            int num3;
            int num = stream.read3() + 1;
            boolean flag2 = stream.read1();
            boolean flag3 = stream.read1();
            if (stream.read3() != 0) {
                throw new RuntimeException(new Exception("VP9 RTP Scalability Structure failed sanity check for spec version 02."));
            }
            if (flag2) {
                for (num3 = 0; num3 < num; ++num3) {
                    stream.read16();
                    stream.read16();
                }
            }
            if (flag3) {
                int num4 = stream.read8();
                for (num3 = 0; num3 < num4; ++num3) {
                    stream.read3();
                    stream.read1();
                    int num5 = stream.read2();
                    stream.nextByte();
                    for (int i = 0; i < num5; ++i) {
                        stream.read8();
                    }
                }
            }
        }
        packet.setPayload(packetBuffer.subset(stream.getPosition()));
        return packet;
    }

    private void generateHeader() {
        this.setHeader(DataBuffer.allocate(this.getHeaderLength()));
        this.getHeader().write1(this.getPictureIDPresent(), 0, 0);
        this.getHeader().write1(this.getInterPicturePredictedLayerFrame(), 0, 1);
        this.getHeader().write1(this.getLayerIndicesPresent(), 0, 2);
        this.getHeader().write1(this.getFlexibleMode(), 0, 3);
        this.getHeader().write1(this.getStartOfLayerFrame(), 0, 4);
        this.getHeader().write1(this.getEndOfLayerFrame(), 0, 5);
        this.getHeader().write1(this.getScalabilityStructurePresent(), 0, 6);
        this.getHeader().write1(this.getReservedBit(), 0, 7);
    }

    public DataBuffer getBuffer() {
        if (this.getHeader() == null) {
            this.generateHeader();
        }
        return this.getHeader().append(this.getPayload());
    }

    public boolean getEndOfLayerFrame() {
        return this._endOfLayerFrame;
    }

    public boolean getExtendedPictureID() {
        return this._extendedPictureID;
    }

    public int getFixedHeaderLength() {
        return 1;
    }

    public boolean getFlexibleMode() {
        return this._flexibleMode;
    }

    public DataBuffer getHeader() {
        return this._header;
    }

    public int getHeaderLength() {
        return this.getFixedHeaderLength() + this.getVariableHeaderLength();
    }

    public boolean getInterPicturePredictedLayerFrame() {
        return this._interPicturePredictedLayerFrame;
    }

    public boolean getLayerIndicesPresent() {
        return this._layerIndicesPresent;
    }

    public DataBuffer getPayload() {
        return this._payload;
    }

    public short getPictureID() {
        return this._pictureID;
    }

    public boolean getPictureIDPresent() {
        return this._pictureIDPresent;
    }

    public boolean getReservedBit() {
        return false;
    }

    public boolean getScalabilityStructurePresent() {
        return this._scalabilityStructurePresent;
    }

    public boolean getStartOfLayerFrame() {
        return this._startOfLayerFrame;
    }

    public int getVariableHeaderLength() {
        return (this.getPictureIDPresent() ? 1 : 0) + (this.getExtendedPictureID() ? 1 : 0);
    }

    public Packet() {
    }

    public Packet(DataBuffer payload, boolean startOfPartition, byte partitionIndex) {
        this(payload, startOfPartition);
    }

    public Packet(DataBuffer payload, boolean startOfLayerFrame) {
        this.setPayload(payload);
        this.setStartOfLayerFrame(startOfLayerFrame);
    }

    public void setEndOfLayerFrame(boolean value) {
        this._endOfLayerFrame = value;
    }

    public void setExtendedPictureID(boolean value) {
        this._extendedPictureID = value;
    }

    public void setFlexibleMode(boolean value) {
        this._flexibleMode = value;
    }

    private void setHeader(DataBuffer value) {
        this._header = value;
    }

    public void setInterPicturePredictedLayerFrame(boolean value) {
        this._interPicturePredictedLayerFrame = value;
    }

    public void setLayerIndicesPresent(boolean value) {
        this._layerIndicesPresent = value;
    }

    public void setPayload(DataBuffer value) {
        this._payload = value;
    }

    public void setPictureID(short value) {
        this._pictureID = value;
    }

    public void setPictureIDPresent(boolean value) {
        this._pictureIDPresent = value;
    }

    public void setScalabilityStructurePresent(boolean value) {
        this._scalabilityStructurePresent = value;
    }

    public void setStartOfLayerFrame(boolean value) {
        this._startOfLayerFrame = value;
    }

    public static Packet wrap(DataBuffer packetBuffer) {
        DataBufferStream stream = new DataBufferStream(packetBuffer);
        stream.getBuffer().setLittleEndian(false);
        return Packet.extractV02(packetBuffer, stream);
    }
}

