/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.sctp;

import fm.icelink.LongExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class MaxMessageSizeAttribute
extends Attribute {
    private long _maxMessageSize;

    public static MaxMessageSizeAttribute fromAttributeValue(String value) {
        long num = ParseAssistant.parseLongValue(value);
        MaxMessageSizeAttribute attribute = new MaxMessageSizeAttribute();
        attribute.setMaxMessageSize(num);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, LongExtensions.toString(this.getMaxMessageSize()));
        return builder.toString();
    }

    public long getMaxMessageSize() {
        return this._maxMessageSize;
    }

    private MaxMessageSizeAttribute() {
        super.setAttributeType(AttributeType.SctpMaxMessageSizeAttribute);
    }

    public MaxMessageSizeAttribute(long maxMessageSize) {
        super.setAttributeType(AttributeType.SctpMaxMessageSizeAttribute);
        this.setMaxMessageSize(maxMessageSize);
    }

    private void setMaxMessageSize(long value) {
        this._maxMessageSize = value;
    }
}

