/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.LinkedList;
import fm.icelink.Log;
import fm.icelink.ManagedCondition;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.Randomizer;
import fm.icelink.StreamDirection;
import fm.icelink.Transport;
import fm.icelink.VirtualDelayedBuffer;
import java.util.ArrayList;
import java.util.List;

class VirtualRandomizerTransport
extends Transport {
    private ManagedCondition __condition;
    private int __delayNthPacket = 0;
    private int __delayPacketMaximum = 0;
    private int __delayPacketProbability = 0;
    private StreamDirection __directionToRandomize;
    private int __dropNthPacket = -1;
    private int __dropPacketProbability = 0;
    private List<IAction1<DataBuffer>> __onReceive = new ArrayList<IAction1<DataBuffer>>();
    private long __packetsReceived = 0L;
    private long __packetsSent = 0L;
    private LinkedList<VirtualDelayedBuffer> __receiveBuffer;
    private volatile boolean __receiving = false;
    private volatile boolean __receivingStopped = false;
    private LinkedList<VirtualDelayedBuffer> __sendBuffer;
    private volatile boolean __sending = false;
    private volatile boolean __sendingStopped = false;
    private ManagedThread __thread;
    private Transport _innerTransport;
    private IAction1<DataBuffer> _onReceive = null;
    private Randomizer _randomizer;

    @Override
    public void addOnReceive(IAction1<DataBuffer> value) {
        if (value != null) {
            if (this._onReceive == null) {
                this._onReceive = new IAction1<DataBuffer>(){

                    @Override
                    public void invoke(DataBuffer p0) {
                        for (IAction1 action : new ArrayList(VirtualRandomizerTransport.this.__onReceive)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceive.add(value);
        }
    }

    public int getDelayNthPacket() {
        return this.__delayNthPacket;
    }

    public int getDelayPacketMaximum() {
        return this.__delayPacketMaximum;
    }

    public int getDelayPacketProbability() {
        return this.__delayPacketProbability;
    }

    public StreamDirection getDirectionToRandomize() {
        return this.__directionToRandomize;
    }

    public int getDropNthPacket() {
        return this.__dropNthPacket;
    }

    public int getDropPacketProbability() {
        return this.__dropPacketProbability;
    }

    public Transport getInnerTransport() {
        return this._innerTransport;
    }

    @Override
    public boolean getIsClosed() {
        return false;
    }

    private int getPacketDelay() {
        if (this.getDelayNthPacket() > 0) {
            return this.__delayPacketMaximum;
        }
        return 1 + this._randomizer.next(0, this.__delayPacketMaximum);
    }

    public void receive(DataBuffer buffer) {
        ++this.__packetsReceived;
        IAction1<DataBuffer> onReceive = this._onReceive;
        if (onReceive != null) {
            if (Global.equals((Object)this.getDirectionToRandomize(), (Object)StreamDirection.ReceiveOnly) || Global.equals((Object)this.getDirectionToRandomize(), (Object)StreamDirection.SendReceive)) {
                if (!this.shouldDropPacket(this.__packetsReceived)) {
                    long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                    if (!this.shouldDelayPacket(this.__packetsReceived)) {
                        onReceive.invoke(buffer);
                    } else {
                        this.__receiveBuffer.addFirst(new VirtualDelayedBuffer(buffer, ticks + (long)(this.getPacketDelay() * Constants.getTicksPerMillisecond())));
                    }
                }
            } else {
                onReceive.invoke(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiverLoop(ManagedThread thread) {
        while (this.__receiving) {
            IAction1<DataBuffer> onReceive;
            thread.loopBegin();
            if (this.__receiveBuffer.getCount() > 0 && (onReceive = this._onReceive) != null) {
                for (int i = 0; i < this.__receiveBuffer.getCount(); ++i) {
                    long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                    if (!this.__receiveBuffer.getFirst().getValue().isReady(ticks)) break;
                    onReceive.invoke(this.__receiveBuffer.getFirst().getValue().getBuffer());
                    this.__receiveBuffer.removeFirst();
                }
            }
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                if (this.__receiving) {
                    this.__condition.halt(1);
                }
            }
            thread.loopEnd();
        }
        this.__receivingStopped = true;
    }

    @Override
    public void removeOnReceive(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceive, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceive.remove(value);
        if (this.__onReceive.size() == 0) {
            this._onReceive = null;
        }
    }

    @Override
    public void send(DataBuffer buffer) {
        ++this.__packetsSent;
        if (Global.equals((Object)this.getDirectionToRandomize(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getDirectionToRandomize(), (Object)StreamDirection.SendReceive)) {
            if (!this.shouldDropPacket(this.__packetsSent)) {
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (!this.shouldDelayPacket(this.__packetsSent)) {
                    this.getInnerTransport().send(buffer);
                } else {
                    this.__sendBuffer.addFirst(new VirtualDelayedBuffer(buffer, ticks + (long)(this.getPacketDelay() * Constants.getTicksPerMillisecond())));
                }
            } else {
                Log.debug("Randomizer dropping packet.");
            }
        } else {
            this.getInnerTransport().send(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderLoop(ManagedThread thread) {
        while (this.__sending) {
            thread.loopBegin();
            if (this.__sendBuffer.getCount() > 0) {
                for (int i = 0; i < this.__sendBuffer.getCount(); ++i) {
                    long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                    if (!this.__sendBuffer.getFirst().getValue().isReady(ticks)) break;
                    this.getInnerTransport().send(this.__sendBuffer.getFirst().getValue().getBuffer());
                    this.__sendBuffer.removeFirst();
                }
            }
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                if (this.__sending) {
                    this.__condition.halt(1);
                }
            }
            thread.loopEnd();
        }
        this.__sendingStopped = true;
    }

    public void setDelayNthPacket(int value) {
        this.__delayNthPacket = MathAssistant.max(value, 0);
    }

    public void setDelayPacketMaximum(int value) {
        this.__delayPacketMaximum = MathAssistant.max(value, 0);
    }

    public void setDelayPacketProbability(int value) {
        this.__delayPacketProbability = MathAssistant.max(MathAssistant.min(value, 100), 0);
    }

    public void setDirectionToRandomize(StreamDirection value) {
        this.__directionToRandomize = value;
    }

    public void setDropNthPacket(int value) {
        this.__dropNthPacket = MathAssistant.max(value, -1);
    }

    public void setDropPacketProbability(int value) {
        this.__dropPacketProbability = MathAssistant.max(MathAssistant.min(value, 100), 0);
    }

    private void setInnerTransport(Transport value) {
        this._innerTransport = value;
    }

    private boolean shouldDelayPacket(long packetCount) {
        if (this.getDelayPacketProbability() > 0) {
            int num = this._randomizer.next(0, 100);
            return this.__dropPacketProbability > num;
        }
        return this.getDelayNthPacket() > 0 && packetCount % (long)this.getDelayNthPacket() == 0L;
    }

    private boolean shouldDropPacket(long packetCount) {
        if (this.getDropPacketProbability() > 0) {
            int num = this._randomizer.next(0, 100);
            return this.__dropPacketProbability > num;
        }
        return this.getDropNthPacket() >= 0 && packetCount % (long)this.getDropNthPacket() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        IAction0 action = null;
        IAction0 action2 = null;
        if (!this.__sending && !this.__receiving) {
            ManagedCondition managedCondition = this.__condition;
            synchronized (managedCondition) {
                if (!this.__sending && !this.__receiving) {
                    if (action == null) {
                        action = new IAction0(){

                            @Override
                            public void invoke() {
                                VirtualRandomizerTransport.this.__sending = true;
                                VirtualRandomizerTransport.this.__sendingStopped = false;
                                VirtualRandomizerTransport.this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

                                    @Override
                                    public String getId() {
                                        return "fm.icelink.VirtualRandomizerTransport.senderLoop";
                                    }

                                    @Override
                                    public void invoke(ManagedThread thread) {
                                        VirtualRandomizerTransport.this.senderLoop(thread);
                                    }
                                });
                                VirtualRandomizerTransport.this.__thread.start();
                            }
                        };
                    }
                    ManagedThread.dispatch(action);
                    if (action2 == null) {
                        action2 = new IAction0(){

                            @Override
                            public void invoke() {
                                VirtualRandomizerTransport.this.__receiving = true;
                                VirtualRandomizerTransport.this.__receivingStopped = false;
                                VirtualRandomizerTransport.this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

                                    @Override
                                    public String getId() {
                                        return "fm.icelink.VirtualRandomizerTransport.receiverLoop";
                                    }

                                    @Override
                                    public void invoke(ManagedThread thread) {
                                        VirtualRandomizerTransport.this.receiverLoop(thread);
                                    }
                                });
                                VirtualRandomizerTransport.this.__thread.start();
                            }
                        };
                    }
                    ManagedThread.dispatch(action2);
                }
            }
        }
    }

    public void stop() {
        IAction0 action = null;
        if (!this.__sendingStopped) {
            if (action == null) {
                action = new IAction0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void invoke() {
                        ManagedCondition managedCondition = VirtualRandomizerTransport.this.__condition;
                        synchronized (managedCondition) {
                            VirtualRandomizerTransport.this.__sending = false;
                            VirtualRandomizerTransport.this.__receiving = false;
                            VirtualRandomizerTransport.this.__condition.pulse();
                        }
                        while (!VirtualRandomizerTransport.this.__sendingStopped && !VirtualRandomizerTransport.this.__receivingStopped) {
                            ManagedThread.sleep(10);
                        }
                    }
                };
            }
            ManagedThread.dispatch(action);
        }
    }

    public VirtualRandomizerTransport(Transport innerTransport) {
        this.__directionToRandomize = StreamDirection.SendReceive;
        this.__condition = new ManagedCondition();
        this.__sendBuffer = new LinkedList();
        this.__receiveBuffer = new LinkedList();
        this._randomizer = new Randomizer();
        this.setInnerTransport(innerTransport);
        innerTransport.addOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.VirtualRandomizerTransport.receive";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                VirtualRandomizerTransport.this.receive(buffer);
            }
        });
    }
}

