/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IMediaTrack;
import fm.icelink.IVideoElement;
import fm.icelink.IVideoInput;
import fm.icelink.IVideoInputCollection;
import fm.icelink.IVideoOutput;
import fm.icelink.IVideoOutputCollection;
import fm.icelink.IVideoTrack;
import fm.icelink.MediaSourceState;
import fm.icelink.MediaTrack;
import fm.icelink.Promise;
import fm.icelink.Size;
import fm.icelink.VideoBranch;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferCollection;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.VideoSink;
import fm.icelink.VideoSource;
import fm.icelink.VideoStream;
import java.util.ArrayList;
import java.util.List;

public class VideoTrack
extends MediaTrack<IVideoOutput, IVideoOutputCollection, IVideoInput, IVideoInputCollection, IVideoElement, VideoSource, VideoSink, VideoPipe, VideoTrack, VideoBranch, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>
implements IVideoTrack,
IMediaTrack {
    private ArrayList<IVideoElement> __elements;
    private Object __grabFrameLock;
    private Promise<VideoBuffer> __grabFramePromise;
    private List<IAction1<VideoBuffer>> __onRawBuffer = new ArrayList<IAction1<VideoBuffer>>();
    private List<IAction1<Size>> __onSize = new ArrayList<IAction1<Size>>();
    private IVideoInput __rawSizeInput;
    private IVideoOutput __rawSizeOutput;
    private Size __size = new Size(0, 0);
    private IAction1<VideoBuffer> _onRawBuffer = null;
    private IAction1<Size> _onSize = null;

    @Override
    protected void addElement(IVideoElement element) {
        if (element instanceof VideoBranch) {
            VideoBranch branch = (VideoBranch)element;
            for (VideoTrack track : (VideoTrack[])branch.getTracks()) {
                track.addOnRawBuffer((IAction1<VideoBuffer>)new IActionDelegate1<VideoBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.VideoTrack.track_OnRawBuffer";
                    }

                    @Override
                    public void invoke(VideoBuffer rawBuffer) {
                        VideoTrack.this.track_OnRawBuffer(rawBuffer);
                    }
                });
            }
        } else {
            IVideoOutput output;
            VideoFormat outputFormat;
            IVideoInput input;
            VideoFormat inputFormat;
            if (element instanceof IVideoInput && (inputFormat = (VideoFormat)(input = (IVideoInput)element).getInputFormat()) != null && inputFormat.getIsRaw() && this.__rawSizeInput == null && this.__rawSizeOutput == null) {
                this.__rawSizeInput = input;
                this.__rawSizeInput.addOnProcessFrame(new IActionDelegate1<VideoFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.VideoTrack.rawSize_OnProcessFrame";
                    }

                    @Override
                    public void invoke(VideoFrame frame) {
                        VideoTrack.this.rawSize_OnProcessFrame(frame);
                    }
                });
            }
            if (element instanceof IVideoOutput && (outputFormat = (VideoFormat)(output = (IVideoOutput)element).getOutputFormat()) != null && outputFormat.getIsRaw() && this.__rawSizeInput == null && this.__rawSizeOutput == null) {
                this.__rawSizeOutput = output;
                this.__rawSizeOutput.addOnRaiseFrame(new IActionDelegate1<VideoFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.VideoTrack.rawSize_OnProcessFrame";
                    }

                    @Override
                    public void invoke(VideoFrame frame) {
                        VideoTrack.this.rawSize_OnProcessFrame(frame);
                    }
                });
            }
        }
        if (ArrayListExtensions.getCount(this.__elements) == 0 && element instanceof VideoSource) {
            VideoSource source = (VideoSource)element;
            source.addOnStateChange(new IActionDelegate1<VideoSource>(){

                @Override
                public String getId() {
                    return "fm.icelink.VideoTrack.source_OnStateChange";
                }

                @Override
                public void invoke(VideoSource source) {
                    VideoTrack.this.source_OnStateChange(source);
                }
            });
        }
        this.__elements.add(element);
    }

    void addOnRawBuffer(IAction1<VideoBuffer> value) {
        if (value != null) {
            if (this._onRawBuffer == null) {
                this._onRawBuffer = new IAction1<VideoBuffer>(){

                    @Override
                    public void invoke(VideoBuffer p0) {
                        for (IAction1 action : new ArrayList(VideoTrack.this.__onRawBuffer)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onRawBuffer.add(value);
        }
    }

    @Override
    public void addOnSize(IAction1<Size> value) {
        if (value != null) {
            if (this._onSize == null) {
                this._onSize = new IAction1<Size>(){

                    @Override
                    public void invoke(Size p0) {
                        for (IAction1 action : new ArrayList(VideoTrack.this.__onSize)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onSize.add(value);
        }
    }

    protected IVideoInput[] arrayFromInputs(ArrayList<IVideoInput> inputs) {
        return inputs.toArray(new IVideoInput[0]);
    }

    protected IVideoOutput[] arrayFromOutputs(ArrayList<IVideoOutput> outputs) {
        return outputs.toArray(new IVideoOutput[0]);
    }

    protected VideoSink[] arrayFromSinks(ArrayList<VideoSink> sinks) {
        return sinks.toArray(new VideoSink[0]);
    }

    protected VideoBranch branchFromTracks(VideoTrack[] tracks) {
        return new VideoBranch(tracks);
    }

    public IVideoElement[] getElements() {
        return this.__elements.toArray(new IVideoElement[0]);
    }

    @Override
    public String getLabel() {
        return "Video Track";
    }

    @Override
    public Size getSize() {
        return this.__size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<VideoBuffer> grabFrame() {
        Promise<VideoBuffer> promise = new Promise<VideoBuffer>();
        Object object = this.__grabFrameLock;
        synchronized (object) {
            if (this.__grabFramePromise == null) {
                this.__grabFramePromise = promise;
                return promise;
            }
            promise.reject(new Exception("Please wait for the previous frame to be grabbed before attempting another."));
        }
        return promise;
    }

    private void initialize(IVideoElement element) {
        if (element != null) {
            this.addElement(element);
        }
    }

    @Override
    protected boolean isBranch(IVideoElement element) {
        return element instanceof VideoBranch;
    }

    @Override
    protected boolean isInput(IVideoElement element) {
        return element instanceof IVideoInput;
    }

    @Override
    protected boolean isOutput(IVideoElement element) {
        return element instanceof IVideoOutput;
    }

    @Override
    protected boolean isPipe(IVideoElement element) {
        return element instanceof VideoPipe;
    }

    @Override
    protected boolean isSink(IVideoElement element) {
        return element instanceof VideoSink;
    }

    @Override
    protected boolean isSource(IVideoElement element) {
        return element instanceof VideoSource;
    }

    @Override
    protected boolean isStream(IVideoElement element) {
        return element instanceof VideoStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseRawBuffer(VideoBuffer rawBuffer) {
        if (rawBuffer != null) {
            IAction1<VideoBuffer> onRawBuffer;
            if (this.__grabFramePromise != null) {
                Promise<VideoBuffer> promise = null;
                Object object = this.__grabFrameLock;
                synchronized (object) {
                    if (this.__grabFramePromise != null) {
                        promise = this.__grabFramePromise;
                        this.__grabFramePromise = null;
                    }
                }
                if (promise != null) {
                    promise.resolve(rawBuffer);
                }
            }
            if ((onRawBuffer = this._onRawBuffer) != null) {
                onRawBuffer.invoke(rawBuffer);
            }
        }
    }

    private void raiseSize(VideoBuffer rawBuffer) {
        if (rawBuffer != null) {
            this.__size = new Size(rawBuffer.getWidth(), rawBuffer.getHeight());
            IAction1<Size> onSize = this._onSize;
            if (onSize != null) {
                onSize.invoke(this.__size);
            }
        }
    }

    private void rawSize_OnProcessFrame(VideoFrame frame) {
        VideoBuffer lastBuffer = (VideoBuffer)frame.getLastBuffer();
        this.raiseRawBuffer(lastBuffer);
        this.raiseSize(lastBuffer);
    }

    void removeOnRawBuffer(IAction1<VideoBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRawBuffer, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRawBuffer.remove(value);
        if (this.__onRawBuffer.size() == 0) {
            this._onRawBuffer = null;
        }
    }

    @Override
    public void removeOnSize(IAction1<Size> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSize, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSize.remove(value);
        if (this.__onSize.size() == 0) {
            this._onSize = null;
        }
    }

    private void source_OnStateChange(VideoSource source) {
        MediaSourceState _var0 = source.getState();
        if (_var0 == MediaSourceState.Started) {
            super.raiseOnStarted();
        } else if (_var0 == MediaSourceState.Stopped) {
            super.raiseOnStopped();
        }
    }

    private void track_OnRawBuffer(VideoBuffer rawBuffer) {
        if (this.__rawSizeInput == null && this.__rawSizeOutput == null) {
            this.raiseRawBuffer(rawBuffer);
            this.raiseSize(rawBuffer);
        }
    }

    public VideoTrack() {
        this.__elements = new ArrayList();
        this.__grabFrameLock = new Object();
        this.initialize(null);
    }

    public VideoTrack(IVideoElement element) {
        this.__elements = new ArrayList();
        this.__grabFrameLock = new Object();
        this.initialize(element);
    }

    public VideoTrack(VideoTrack[] tracks) {
        this.__elements = new ArrayList();
        this.__grabFrameLock = new Object();
        this.initialize(tracks == null ? null : new VideoBranch(tracks));
    }
}

