/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.SdesItem;
import fm.icelink.StringExtensions;

public class SdesChunk {
    private DataBuffer _dataBuffer;
    private SdesItem[] _sourceDescriptionItems;

    public DataBuffer getDataBuffer() {
        return this._dataBuffer;
    }

    public static int getFixedPayloadHeaderLength() {
        return 4;
    }

    public SdesItem[] getSourceDescriptionItems() {
        return this._sourceDescriptionItems;
    }

    public long getSynchronizationSource() {
        return this.getDataBuffer().read32(0);
    }

    public SdesChunk(long synchronizationSource, SdesItem sourceDescriptionItem) {
        this(synchronizationSource, new SdesItem[]{sourceDescriptionItem});
    }

    public SdesChunk(DataBuffer buffer) {
        this.setDataBuffer(buffer);
        if (buffer.getLength() < SdesChunk.getFixedPayloadHeaderLength()) {
            throw new RuntimeException(new Exception(StringExtensions.concat("DataBuffer must be at least ", IntegerExtensions.toString(SdesChunk.getFixedPayloadHeaderLength()), " bytes for an SDES Chunk.")));
        }
        if (buffer.getLength() % 4 != 0) {
            throw new RuntimeException(new Exception("DataBuffer must be 32-bit aligned for SDES Chunks and Items."));
        }
    }

    public SdesChunk(long synchronizationSource, SdesItem[] sourceDescriptionItems) {
        int fixedPayloadHeaderLength = SdesChunk.getFixedPayloadHeaderLength();
        for (SdesItem item : sourceDescriptionItems) {
            fixedPayloadHeaderLength += item.getDataBuffer().getLength();
        }
        this.setDataBuffer(DataBuffer.allocate(fixedPayloadHeaderLength));
        int offset = SdesChunk.getFixedPayloadHeaderLength();
        for (int i = 0; i < ArrayExtensions.getLength(sourceDescriptionItems); ++i) {
            this.getDataBuffer().write(sourceDescriptionItems[i].getDataBuffer(), offset);
            offset += sourceDescriptionItems[i].getDataBuffer().getLength();
        }
    }

    private void setDataBuffer(DataBuffer value) {
        this._dataBuffer = value;
    }

    public void setSourceDescriptionItems(SdesItem[] value) {
        this._sourceDescriptionItems = value;
    }

    public void setSynchronizationSource(long value) {
        this.getDataBuffer().write32(value, 0);
    }
}

