/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.MathAssistant;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpGapAckBlock;

class SctpSackChunk
extends SctpControlChunk {
    private long _advertisedReceiverWindowCredit;
    private long _cumulativeTsnAck;
    private long[] _duplicateTsns;
    private SctpGapAckBlock[] _gapAckBlocks;
    public static int _unset = -1;

    public long getAdvertisedReceiverWindowCredit() {
        return this._advertisedReceiverWindowCredit;
    }

    public static byte[] getBytes(SctpSackChunk chunk, int sizeLimit) {
        int num4;
        int num = 16;
        if (sizeLimit != _unset && num > sizeLimit) {
            throw new RuntimeException(new Exception("SCTP chunk limit is set too low and prevents SCTP SACK chunk dispatching."));
        }
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        int num2 = sizeLimit != _unset ? MathAssistant.min(chunk.getNumberOfGapAckBlocks(), (int)MathAssistant.floor((sizeLimit - num) / 4)) : chunk.getNumberOfGapAckBlocks();
        int num3 = sizeLimit != _unset ? MathAssistant.min(chunk.getNumberOfDuplicateTsns(), (int)MathAssistant.floor((sizeLimit - (num += num2 * 4)) / 4)) : chunk.getNumberOfDuplicateTsns();
        bytes.addRange(Binary.toBytes16(num += num3 * 4, false));
        bytes.addRange(Binary.toBytes32(chunk.getCumulativeTsnAck(), false));
        bytes.addRange(Binary.toBytes32(chunk.getAdvertisedReceiverWindowCredit(), false));
        bytes.addRange(Binary.toBytes16(num2, false));
        bytes.addRange(Binary.toBytes16(num3, false));
        for (num4 = 0; num4 < num2; ++num4) {
            bytes.addRange(chunk.getGapAckBlocks()[num4].getBytes());
        }
        for (num4 = 0; num4 < num3; ++num4) {
            bytes.addRange(Binary.toBytes32(chunk.getDuplicateTsns()[num4], false));
        }
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return SctpSackChunk.getBytes(this, _unset);
    }

    public byte[] getBytes(int sizeLimit) {
        return SctpSackChunk.getBytes(this, sizeLimit);
    }

    public long getCumulativeTsnAck() {
        return this._cumulativeTsnAck;
    }

    public long[] getDuplicateTsns() {
        return this._duplicateTsns;
    }

    public SctpGapAckBlock[] getGapAckBlocks() {
        return this._gapAckBlocks;
    }

    public int getNumberOfDuplicateTsns() {
        if (this.getDuplicateTsns() == null) {
            return 0;
        }
        return ArrayExtensions.getLength(this.getDuplicateTsns());
    }

    public int getNumberOfGapAckBlocks() {
        if (this.getGapAckBlocks() == null) {
            return 0;
        }
        return ArrayExtensions.getLength(this.getGapAckBlocks());
    }

    public static SctpSackChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num6;
            long cumulativeTsnAck = Binary.fromBytes32(bytes, 4, false);
            long advertisedReceiverWindowCredit = Binary.fromBytes32(bytes, 8, false);
            int num3 = Binary.fromBytes16(bytes, 12, false);
            int num4 = Binary.fromBytes16(bytes, 14, false);
            SctpSackChunk chunk = new SctpSackChunk(cumulativeTsnAck, advertisedReceiverWindowCredit, null, null);
            int startIndex = 16;
            if (num3 > 0) {
                SctpGapAckBlock[] blockArray = new SctpGapAckBlock[num3];
                for (num6 = 0; num6 < num3; ++num6) {
                    SctpGapAckBlock _var0;
                    blockArray[num6] = _var0 = SctpGapAckBlock.parseBytes(bytes, startIndex, offsetPlus);
                    startIndex += offsetPlus.getValue();
                }
                chunk.setGapAckBlocks(blockArray);
            }
            if (num4 > 0) {
                long[] numArray = new long[num4];
                for (num6 = 0; num6 < num4; ++num6) {
                    numArray[num6] = Binary.fromBytes32(bytes, startIndex, false);
                    startIndex += 4;
                }
                chunk.setDuplicateTsns(numArray);
            }
            offsetPlus.setValue(startIndex);
            return chunk;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpSackChunk(long cumulativeTsnAck, long advertisedReceiverWindowCredit, SctpGapAckBlock[] gapAckBlocks, long[] duplicateTsns) {
        super.setType(SctpChunkType.getSack());
        this.setCumulativeTsnAck(cumulativeTsnAck);
        this.setAdvertisedReceiverWindowCredit(advertisedReceiverWindowCredit);
        this.setGapAckBlocks(gapAckBlocks);
        this.setDuplicateTsns(duplicateTsns);
        super.setCanBundleWithDataAndSackChunks(true);
        super.setUnrecognized(false);
    }

    public void setAdvertisedReceiverWindowCredit(long value) {
        this._advertisedReceiverWindowCredit = value;
    }

    public void setCumulativeTsnAck(long value) {
        this._cumulativeTsnAck = value;
    }

    public void setDuplicateTsns(long[] value) {
        this._duplicateTsns = value;
    }

    public void setGapAckBlocks(SctpGapAckBlock[] value) {
        this._gapAckBlocks = value;
    }
}

