/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioTrack;
import fm.icelink.Future;
import fm.icelink.IAction1;
import fm.icelink.LocalMediaState;
import fm.icelink.Log;
import fm.icelink.Media;
import fm.icelink.Promise;
import fm.icelink.StringExtensions;
import fm.icelink.VideoTrack;

public abstract class LocalMediaBase<TLocalMedia extends LocalMediaBase<TLocalMedia, TAudioTrack, TVideoTrack>, TAudioTrack extends AudioTrack, TVideoTrack extends VideoTrack>
extends Media<TAudioTrack, TVideoTrack> {
    private Object __stateLock = new Object();
    private LocalMediaState _state;

    protected void abortStart(final Promise<TLocalMedia> promise, final Exception exception) {
        Log.debug(StringExtensions.format("Local media failed to start and is in a partial state. Stopping...", new Object[0]));
        this.doStop().then(new IAction1<TLocalMedia>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(TLocalMedia result) {
                Log.debug(StringExtensions.format("Local media has successfully stopped.", new Object[0]));
                Object object = LocalMediaBase.this.__stateLock;
                synchronized (object) {
                    LocalMediaBase.this.setState(LocalMediaState.Stopped);
                    promise.reject(exception);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception ex) {
                Log.debug(StringExtensions.format("Local media did not stop successfully.", new Object[0]));
                Object object = LocalMediaBase.this.__stateLock;
                synchronized (object) {
                    LocalMediaBase.this.setState(LocalMediaState.Stopped);
                    promise.reject(exception);
                }
            }
        });
    }

    protected abstract Future<TLocalMedia> doStart();

    protected abstract Future<TLocalMedia> doStop();

    public LocalMediaState getState() {
        return this._state;
    }

    private void setState(LocalMediaState value) {
        this._state = value;
    }

    public Future<TLocalMedia> start() {
        return this.startInternal(new Promise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<TLocalMedia> startInternal(final Promise<TLocalMedia> promise) {
        Object object = this.__stateLock;
        synchronized (object) {
            LocalMediaState _var0 = this.getState();
            if (_var0 == LocalMediaState.Starting) {
                promise.reject(new Exception("Local media cannot be started while it is being started on a different thread."));
                return promise;
            }
            if (_var0 == LocalMediaState.Started) {
                promise.resolve(this);
                return promise;
            }
            if (_var0 == LocalMediaState.Stopping) {
                promise.reject(new Exception("Local media cannot be started while it is being stopped."));
                return promise;
            }
            if (_var0 == LocalMediaState.Destroying) {
                promise.reject(new Exception("Local media cannot be started while it is being destroyed."));
                return promise;
            }
            if (_var0 == LocalMediaState.Destroyed) {
                promise.reject(new Exception("Local media cannot be started while it is destroyed."));
                return promise;
            }
            this.setState(LocalMediaState.Starting);
        }
        Log.debug(StringExtensions.format("Local media is being started.", new Object[0]));
        this.doStart().then(new IAction1<TLocalMedia>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(TLocalMedia result) {
                Log.debug(StringExtensions.format("Local media has successfully started.", new Object[0]));
                Object object = LocalMediaBase.this.__stateLock;
                synchronized (object) {
                    LocalMediaBase.this.setState(LocalMediaState.Started);
                    promise.resolve(result);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception exception) {
                Log.debug(StringExtensions.format("Local media did not start successfully.", new Object[0]));
                Object object = LocalMediaBase.this.__stateLock;
                synchronized (object) {
                    LocalMediaBase.this.setState(LocalMediaState.Stopped);
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    public Future<TLocalMedia> stop() {
        return this.stopInternal(new Promise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<TLocalMedia> stopInternal(final Promise<TLocalMedia> promise) {
        Object object = this.__stateLock;
        synchronized (object) {
            LocalMediaState _var0 = this.getState();
            if (_var0 == LocalMediaState.New) {
                promise.resolve(this);
                return promise;
            }
            if (_var0 == LocalMediaState.Starting) {
                promise.reject(new Exception("Local media cannot be stopped while it is being started."));
                return promise;
            }
            if (_var0 == LocalMediaState.Stopping) {
                promise.reject(new Exception("Local media cannot be stopped while it is being stopped on a different thread."));
                return promise;
            }
            if (_var0 == LocalMediaState.Stopped) {
                promise.resolve(this);
                return promise;
            }
            if (_var0 == LocalMediaState.Destroying) {
                promise.reject(new Exception("Local media cannot be stopped while it is being destroyed."));
                return promise;
            }
            if (_var0 == LocalMediaState.Destroyed) {
                promise.reject(new Exception("Local media cannot be stopped while it is destroyed."));
                return promise;
            }
            this.setState(LocalMediaState.Stopping);
        }
        Log.debug(StringExtensions.format("Local media is being stopped.", new Object[0]));
        this.doStop().then(new IAction1<TLocalMedia>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(TLocalMedia result) {
                Log.debug(StringExtensions.format("Local media has successfully stopped.", new Object[0]));
                Object object = LocalMediaBase.this.__stateLock;
                synchronized (object) {
                    LocalMediaBase.this.setState(LocalMediaState.Stopped);
                    promise.resolve(result);
                }
            }
        }, new IAction1<Exception>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Exception exception) {
                Log.debug(StringExtensions.format("Local media did not stop successfully.", new Object[0]));
                Object object = LocalMediaBase.this.__stateLock;
                synchronized (object) {
                    LocalMediaBase.this.setState(LocalMediaState.Started);
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }
}

