/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.CandidateType;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.IceCandidate;
import fm.icelink.IceGatherOptions;
import fm.icelink.IceGatheringState;
import fm.icelink.IceLocalRelayedCandidate;
import fm.icelink.IceLocalRelayedCandidateState;
import fm.icelink.IceTransactionManager;
import fm.icelink.ProtocolType;
import fm.icelink.ScheduledItem;
import fm.icelink.TransportAddress;
import fm.icelink.stun.Message;
import fm.icelink.stun.turn.DataAttribute;
import fm.icelink.stun.turn.SendIndication;
import fm.icelink.stun.turn.XorPeerAddressAttribute;
import java.util.ArrayList;
import java.util.HashMap;

abstract class IceSocketManager {
    private int __hashCode;
    int __numberOfRequests = 0;
    public IceGatheringState __state;
    private Error _error;
    private IceGatherOptions _gatherOptions;
    public HashMap<String, IceCandidate> _localCandidates = new HashMap();
    private int _localPreference;
    HashMap<String, IceLocalRelayedCandidate> _localRelayedCandidates = new HashMap();
    private Object _lock;
    private IAction1<IceSocketManager> _onAllocationMismatchException;
    private IAction3<DataBuffer, IceCandidate, TransportAddress> _onIncomingData;
    private IAction1<IceCandidate> _onLocalCandidate;
    private IAction1<IceSocketManager> _onStateChange;
    private IAction3<Message, IceCandidate, TransportAddress> _onStunRequest;
    private ProtocolType _protocol;
    IceTransactionManager _transactionManager;

    protected abstract void closeSocket();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalise() {
        Object object = this.getLock();
        synchronized (object) {
            if (this._transactionManager != null) {
                this._transactionManager.remove(this);
            }
            this._localCandidates.clear();
            this._localRelayedCandidates.clear();
            if (!Global.equals((Object)this.getState(), (Object)IceGatheringState.Closed)) {
                try {
                    this.closeSocket();
                    this.setState(IceGatheringState.Closed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    abstract long getAdapterSpeed();

    public Error getError() {
        return this._error;
    }

    protected IceGatherOptions getGatherOptions() {
        return this._gatherOptions;
    }

    protected boolean getIsGathering() {
        return this._transactionManager.hasActiveTransactions(this);
    }

    abstract String getLocalIpAddress();

    abstract int getLocalPort();

    public int getLocalPreference() {
        return this._localPreference;
    }

    protected Object getLock() {
        return this._lock;
    }

    public int getNumberOfStunRequests() {
        return this.__numberOfRequests;
    }

    public IAction1<IceSocketManager> getOnAllocationMismatchException() {
        return this._onAllocationMismatchException;
    }

    IAction3<DataBuffer, IceCandidate, TransportAddress> getOnIncomingData() {
        return this._onIncomingData;
    }

    public IAction1<IceCandidate> getOnLocalCandidate() {
        return this._onLocalCandidate;
    }

    public IAction1<IceSocketManager> getOnStateChange() {
        return this._onStateChange;
    }

    IAction3<Message, IceCandidate, TransportAddress> getOnStunRequest() {
        return this._onStunRequest;
    }

    public ProtocolType getProtocol() {
        return this._protocol;
    }

    public IceGatheringState getState() {
        return this.__state;
    }

    public int hashCode() {
        return this.__hashCode;
    }

    protected IceSocketManager(Object lockObject, IceTransactionManager manager) {
        this.setLock(lockObject);
        if (manager == null) {
            throw new RuntimeException(new Exception("Transaction manager cannot be null."));
        }
        this.setState(IceGatheringState.New);
        this._transactionManager = manager;
        this.__hashCode = Guid.newGuid().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRelayedCandidateStateChanged(IceLocalRelayedCandidate candidate) {
        Object object = this.getLock();
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Closing) && (Global.equals((Object)candidate.getRelayState(), (Object)IceLocalRelayedCandidateState.Closed) || Global.equals((Object)candidate.getRelayState(), (Object)IceLocalRelayedCandidateState.Failed))) {
                this.verifyAllRelayedCandidatesStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseLocalCandidate(IceCandidate localCandidate) {
        Object object = this.getLock();
        synchronized (object) {
            if (this._localCandidates.containsKey(localCandidate.getFoundation())) {
                if (Global.equals((Object)localCandidate.getType(), (Object)CandidateType.Relayed)) {
                    ((IceLocalRelayedCandidate)localCandidate).stopRelayTransactions(false);
                }
                return;
            }
            HashMapExtensions.set(HashMapExtensions.getItem(this._localCandidates), localCandidate.getFoundation(), localCandidate);
            if (Global.equals((Object)localCandidate.getType(), (Object)CandidateType.Relayed)) {
                IceLocalRelayedCandidate candidate = (IceLocalRelayedCandidate)localCandidate;
                String key = candidate.getTurnServer().toString();
                HashMapExtensions.add(this._localRelayedCandidates, key, candidate);
            }
        }
        IAction1<IceCandidate> onLocalCandidate = this.getOnLocalCandidate();
        if (onLocalCandidate != null) {
            onLocalCandidate.invoke(localCandidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IceCandidate registerLocalPeerReflexiveCandidate(IceCandidate candidate) {
        Object object = this.getLock();
        synchronized (object) {
            for (IceCandidate candidate2 : HashMapExtensions.getValues(this._localCandidates)) {
                if (!candidate2.equals(candidate)) continue;
                return candidate2;
            }
            HashMapExtensions.set(HashMapExtensions.getItem(this._localCandidates), candidate.getFoundation(), candidate);
            IAction1<IceCandidate> onLocalCandidate = this.getOnLocalCandidate();
            if (onLocalCandidate != null) {
                onLocalCandidate.invoke(candidate);
            }
            return candidate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransaction(ScheduledItem item) {
        this._transactionManager.remove(item, (Object)this);
        Object object = this.getLock();
        synchronized (object) {
            if (!this.getIsGathering() && Global.equals((Object)this.getState(), (Object)IceGatheringState.Gathering)) {
                this.setState(IceGatheringState.Complete);
            }
        }
    }

    protected abstract void sendApplicationData(DataBuffer var1, IceCandidate var2, TransportAddress var3);

    protected void setError(Error value) {
        this._error = value;
    }

    protected void setGatherOptions(IceGatherOptions value) {
        this._gatherOptions = value;
    }

    public void setLocalPreference(int value) {
        this._localPreference = value;
    }

    protected void setLock(Object value) {
        this._lock = value;
    }

    public void setNumberOfStunRequests(int value) {
        this.__numberOfRequests = value;
    }

    public void setOnAllocationMismatchException(IAction1<IceSocketManager> value) {
        this._onAllocationMismatchException = value;
    }

    void setOnIncomingData(IAction3<DataBuffer, IceCandidate, TransportAddress> value) {
        this._onIncomingData = value;
    }

    public void setOnLocalCandidate(IAction1<IceCandidate> value) {
        this._onLocalCandidate = value;
    }

    public void setOnStateChange(IAction1<IceSocketManager> value) {
        this._onStateChange = value;
    }

    void setOnStunRequest(IAction3<Message, IceCandidate, TransportAddress> value) {
        this._onStunRequest = value;
    }

    public void setProtocol(ProtocolType value) {
        this._protocol = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(IceGatheringState value) {
        Object object = this.getLock();
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                IAction1<IceSocketManager> onStateChange = this.getOnStateChange();
                if (!Global.equals((Object)this.__state, (Object)IceGatheringState.Closed) && !Global.equals((Object)this.__state, (Object)IceGatheringState.Failed)) {
                    this.__state = value;
                    if (Global.equals((Object)this.__state, (Object)IceGatheringState.Failed)) {
                        try {
                            this.closeSocket();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        for (IceCandidate candidate : HashMapExtensions.getValues(this._localCandidates)) {
                            candidate.notifyOfSocketError(this.getError());
                        }
                        if (this._transactionManager != null) {
                            this._transactionManager.remove(this);
                        }
                        this._localCandidates.clear();
                        this._localRelayedCandidates.clear();
                    } else if (Global.equals((Object)this.__state, (Object)IceGatheringState.Closing)) {
                        for (IceCandidate candidate : HashMapExtensions.getValues(this._localCandidates)) {
                            candidate.stop();
                        }
                    }
                    if (onStateChange != null) {
                        onStateChange.invoke(this);
                    }
                }
            }
        }
    }

    public abstract boolean start(IceGatherOptions var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.getLock();
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)IceGatheringState.Closing)) {
                if (Global.equals((Object)this.getState(), (Object)IceGatheringState.Closed) || Global.equals((Object)this.getState(), (Object)IceGatheringState.Failed)) {
                    return false;
                }
                if (Global.equals((Object)this.getState(), (Object)IceGatheringState.New)) {
                    this.setOnLocalCandidate(null);
                    this.setOnStateChange(null);
                    this.setOnIncomingData(null);
                    this.setOnAllocationMismatchException(null);
                    this.setState(IceGatheringState.Closed);
                    return true;
                }
                this.setState(IceGatheringState.Closing);
                ArrayList<IceLocalRelayedCandidate> list = new ArrayList<IceLocalRelayedCandidate>();
                for (IceLocalRelayedCandidate candidate : HashMapExtensions.getValues(this._localRelayedCandidates)) {
                    if (!candidate.getOpen()) continue;
                    list.add(candidate);
                }
                for (IceLocalRelayedCandidate candidate : list) {
                    candidate.stopRelayTransactions(true);
                }
                if (ArrayListExtensions.getCount(list) == 0) {
                    this.finalise();
                }
            }
            return true;
        }
    }

    protected void turnPreProcess(DataBuffer buffer, TransportAddress address, TransportAddress relay, Holder<DataBuffer> newBuffer, Holder<TransportAddress> newAddress) {
        if (relay != null) {
            SendIndication indication = new SendIndication();
            indication.setXorPeerAddress(new XorPeerAddressAttribute(address.getIPAddress(), address.getPort(), indication.getTransactionId()));
            indication.setData(new DataAttribute(buffer));
            newBuffer.setValue(DataBuffer.allocate(indication.getLength()));
            indication.writeTo(newBuffer.getValue());
            newAddress.setValue(relay);
        } else {
            newBuffer.setValue(buffer);
            newAddress.setValue(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyAllRelayedCandidatesStopped() {
        Object object = this.getLock();
        synchronized (object) {
            boolean flag = true;
            for (IceLocalRelayedCandidate candidate : HashMapExtensions.getValues(this._localRelayedCandidates)) {
                if (Global.equals((Object)candidate.getRelayState(), (Object)IceLocalRelayedCandidateState.Closed) || Global.equals((Object)candidate.getRelayState(), (Object)IceLocalRelayedCandidateState.Failed)) continue;
                flag = false;
            }
            if (flag) {
                this.finalise();
            }
        }
    }
}

