/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Color;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Future;
import fm.icelink.IActionDelegate0;
import fm.icelink.Log;
import fm.icelink.ManagedTimer;
import fm.icelink.Promise;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoConfig;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoSource;

public class FakeVideoSource
extends VideoSource {
    private double __brightness;
    private double __hue;
    private double __saturation;
    private ManagedTimer __timer;
    private VideoConfig _config;

    @Override
    protected Future<Object> doStart() {
        Promise<Object> promise = new Promise<Object>();
        try {
            this.__hue = 0.0;
            this.__saturation = 1.0;
            this.__brightness = 1.0;
            this.__timer = new ManagedTimer(1000 / this.getConfig().getFrameRate(), new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.FakeVideoSource.raiseData";
                }

                @Override
                public void invoke() {
                    FakeVideoSource.this.raiseData();
                }
            });
            this.__timer.start();
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    @Override
    protected Future<Object> doStop() {
        Promise<Object> promise = new Promise<Object>();
        try {
            this.__timer.stop();
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public FakeVideoSource(VideoConfig config, VideoFormat format) {
        super(format);
        this.setConfig(config);
    }

    public FakeVideoSource(VideoConfig config) {
        this(config, VideoFormat.getBgr());
    }

    public VideoConfig getConfig() {
        return this._config;
    }

    @Override
    public String getLabel() {
        return "Fake Video Source";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseData() {
        VideoConfig config = this.getConfig();
        VideoFormat outputFormat = (VideoFormat)super.getOutputFormat();
        int size = VideoBuffer.getMinimumBufferLength(config.getWidth(), config.getHeight(), outputFormat.getName());
        DataBuffer buffer = DataBufferPool.getInstance().take(size);
        try {
            Color color = Color.fromHsb(this.__hue, this.__saturation, this.__brightness);
            this.__hue += 0.005;
            if (this.__hue >= 1.0) {
                this.__hue = 0.0;
            }
            VideoBuffer buffer2 = VideoBuffer.createCustom(config.getWidth(), config.getHeight(), color.getR(), color.getG(), color.getB(), outputFormat.getName(), buffer);
            this.raiseFrame(new VideoFrame(buffer2));
        }
        catch (Exception exception) {
            Log.error("Could not raise frame.", exception);
        }
        finally {
            buffer.free();
        }
    }

    public void setConfig(VideoConfig value) {
        this._config = value;
    }
}

