/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableInteger;
import java.util.HashMap;

public class CodecStats
extends BaseStats {
    private int _channelCount;
    private int _clockRate;
    private String _name;
    private String _parameters;
    private int _payloadType;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "payloadType")) {
                if (Global.equals(str, "name")) {
                    this.setName(JsonSerializer.deserializeString(valueJson));
                } else if (Global.equals(str, "clockRate")) {
                    this.setClockRate(JsonSerializer.deserializeInteger(valueJson).getValue());
                } else if (Global.equals(str, "channelCount")) {
                    this.setChannelCount(JsonSerializer.deserializeInteger(valueJson).getValue());
                } else if (Global.equals(str, "parameters")) {
                    this.setParameters(JsonSerializer.deserializeString(valueJson));
                }
            } else {
                this.setPayloadType(JsonSerializer.deserializeInteger(valueJson).getValue());
            }
        }
    }

    public static CodecStats fromJson(String codecJson) {
        return JsonSerializer.deserializeObject(codecJson, new IFunction0<CodecStats>(){

            @Override
            public CodecStats invoke() {
                return new CodecStats();
            }
        }, new IAction3<CodecStats, String, String>(){

            @Override
            public void invoke(CodecStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public int getChannelCount() {
        return this._channelCount;
    }

    public int getClockRate() {
        return this._clockRate;
    }

    public String getName() {
        return this._name;
    }

    public String getParameters() {
        return this._parameters;
    }

    public int getPayloadType() {
        return this._payloadType;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "payloadType", JsonSerializer.serializeInteger(new NullableInteger(this.getPayloadType())));
        if (this.getName() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "name", JsonSerializer.serializeString(this.getName()));
        }
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "clockRate", JsonSerializer.serializeInteger(new NullableInteger(this.getClockRate())));
        if (this.getChannelCount() != 0) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "channelCount", JsonSerializer.serializeInteger(new NullableInteger(this.getChannelCount())));
        }
        if (this.getParameters() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "parameters", JsonSerializer.serializeString(this.getParameters()));
        }
    }

    void setChannelCount(int value) {
        this._channelCount = value;
    }

    void setClockRate(int value) {
        this._clockRate = value;
    }

    void setName(String value) {
        this._name = value;
    }

    void setParameters(String value) {
        this._parameters = value;
    }

    void setPayloadType(int value) {
        this._payloadType = value;
    }

    public static String toJson(CodecStats codec) {
        return JsonSerializer.serializeObject(codec, new IAction2<CodecStats, HashMap<String, String>>(){

            @Override
            public void invoke(CodecStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public String toJson() {
        return CodecStats.toJson(this);
    }
}

