/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.IntegerHolder;
import fm.icelink.StringExtensions;

class Asn1BitString
extends Asn1Any {
    private String __value;
    private static String _defaultValue = "";
    private static byte _zeroByte = 0;

    public Asn1BitString() {
    }

    public Asn1BitString(String value) {
        this.setValue(value);
    }

    public Asn1BitString(byte[] valueBytes) {
        this.setValueBytes(valueBytes);
    }

    private static byte[] bitStringToBytes(String bitString) {
        int numberOfUnusedBits = 0;
        IntegerHolder _var0 = new IntegerHolder(numberOfUnusedBits);
        byte[] _var1 = Asn1BitString.bitStringToBytes(bitString, _var0);
        numberOfUnusedBits = _var0.getValue();
        return _var1;
    }

    private static byte[] bitStringToBytes(String bitString, IntegerHolder numberOfUnusedBits) {
        int num = StringExtensions.getLength(bitString) % 8;
        numberOfUnusedBits.setValue(0);
        if (num > 0) {
            numberOfUnusedBits.setValue((byte)(8 - num));
            for (int i = 0; i < numberOfUnusedBits.getValue(); ++i) {
                bitString = StringExtensions.concat(bitString, "0");
            }
        }
        return BitAssistant.getBinaryBytes(bitString);
    }

    private static String bytesToBitString(byte[] bytes) {
        return Asn1BitString.bytesToBitString(bytes, 0, ArrayExtensions.getLength(bytes));
    }

    private static String bytesToBitString(byte[] bytes, int offset, int length) {
        return Asn1BitString.bytesToBitString(bytes, offset, length, _zeroByte);
    }

    private static String bytesToBitString(byte[] bytes, int offset, int length, byte numberOfUnusedBits) {
        String str = BitAssistant.getBinaryString(bytes, offset, length);
        return StringExtensions.substring(str, 0, StringExtensions.getLength(str) - numberOfUnusedBits);
    }

    @Override
    public byte[] getContents() {
        int numberOfUnusedBits = 0;
        IntegerHolder _var0 = new IntegerHolder(numberOfUnusedBits);
        byte[] _var1 = Asn1BitString.bitStringToBytes(this.getValue(), _var0);
        numberOfUnusedBits = _var0.getValue();
        byte[] source = _var1;
        byte[] destination = new byte[1 + ArrayExtensions.getLength(source)];
        destination[0] = (byte)numberOfUnusedBits;
        BitAssistant.copy(source, 0, destination, 1, ArrayExtensions.getLength(source));
        return destination;
    }

    @Override
    public void getProperties(IntegerHolder tag, IntegerHolder klass, BooleanHolder isConstructed, BooleanHolder isIndefinite) {
        tag.setValue(3);
        klass.setValue(0);
        isConstructed.setValue(false);
        isIndefinite.setValue(false);
    }

    public String getValue() {
        return this.__value != null ? this.__value : _defaultValue;
    }

    public byte[] getValueBytes() {
        return Asn1BitString.bitStringToBytes(this.getValue());
    }

    public static Asn1BitString parseContents(byte[] contents) {
        if (ArrayExtensions.getLength(contents) < 1) {
            return null;
        }
        byte numberOfUnusedBits = contents[0];
        return new Asn1BitString(Asn1BitString.bytesToBitString(contents, 1, ArrayExtensions.getLength(contents) - 1, numberOfUnusedBits));
    }

    public void setValue(String value) {
        this.__value = value != null ? value : _defaultValue;
    }

    public void setValueBytes(byte[] value) {
        this.setValue(Asn1BitString.bytesToBitString(value));
    }
}

