/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.FixedPointUtil;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECCurve c = p.getCurve();
        int size = FixedPointUtil.getCombSize(c);
        if (k.bitLength() > size) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        int minWidth = this.getWidthForCombSize(size);
        FixedPointPreCompInfo info = FixedPointUtil.precompute(p, minWidth);
        ECPoint[] lookupTable = info.getPreComp();
        int width = info.getWidth();
        int d = (size + width - 1) / width;
        ECPoint R = c.getInfinity();
        int top = d * width - 1;
        int i = 0;
        while (i < d) {
            int index = 0;
            int j = top - i;
            while (j >= 0) {
                index <<= 1;
                if (k.testBit(j)) {
                    index |= 1;
                }
                j -= d;
            }
            R = R.twicePlus(lookupTable[index]);
            ++i;
        }
        return R;
    }

    protected int getWidthForCombSize(int combSize) {
        return combSize > 257 ? 6 : 5;
    }
}

