/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.TimeSpan;
import java.util.ArrayList;

public class RepeatTime {
    private ArrayList<TimeSpan> __offsets = new ArrayList();
    private TimeSpan _activeDuration;
    private TimeSpan _repeatInterval;

    public void addOffset(TimeSpan offset) {
        this.__offsets.add(offset);
    }

    public TimeSpan getActiveDuration() {
        return this._activeDuration;
    }

    public TimeSpan[] getOffsets() {
        return this.__offsets.toArray(new TimeSpan[0]);
    }

    public TimeSpan getRepeatInterval() {
        return this._repeatInterval;
    }

    public static RepeatTime parse(String s) {
        s = s.substring(2);
        Object[] strArray = StringExtensions.split(s, new char[]{' '});
        TimeSpan repeatInterval = new TimeSpan(0, 0, ParseAssistant.parseIntegerValue(strArray[0]));
        TimeSpan activeDuration = new TimeSpan(0, 0, ParseAssistant.parseIntegerValue(strArray[1]));
        RepeatTime time = new RepeatTime(repeatInterval, activeDuration);
        for (int i = 2; i < ArrayExtensions.getLength(strArray); ++i) {
            time.addOffset(new TimeSpan(0, 0, ParseAssistant.parseIntegerValue((String)strArray[2])));
        }
        return time;
    }

    public boolean removeOffset(TimeSpan offset) {
        return this.__offsets.remove(offset);
    }

    public RepeatTime(TimeSpan repeatInterval, TimeSpan activeDuration) {
        this(repeatInterval, activeDuration, null);
    }

    public RepeatTime(TimeSpan repeatInterval, TimeSpan activeDuration, TimeSpan[] offsets) {
        this.setRepeatInterval(repeatInterval);
        this.setActiveDuration(activeDuration);
        if (offsets != null) {
            ArrayListExtensions.addRange(this.__offsets, offsets);
        }
    }

    private void setActiveDuration(TimeSpan value) {
        this._activeDuration = value;
    }

    private void setRepeatInterval(TimeSpan value) {
        this._repeatInterval = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, "r=");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString((int)this.getRepeatInterval().getTotalSeconds()));
        StringBuilderExtensions.append(builder, " ");
        int totalSeconds = (int)this.getActiveDuration().getTotalSeconds();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(totalSeconds));
        for (TimeSpan span : this.getOffsets()) {
            StringBuilderExtensions.append(builder, " ");
            StringBuilderExtensions.append(builder, IntegerExtensions.toString((int)span.getTotalSeconds()));
        }
        return builder.toString();
    }
}

