/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.LockedRandomizer;
import fm.icelink.LongExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.UnixTimestamp;
import fm.icelink.sdp.AddressType;
import fm.icelink.sdp.NetworkType;

public class Origin {
    private String _addressType;
    private String _networkType;
    private long _sessionId;
    private long _sessionVersion;
    private String _unicastAddress;
    private String _username;

    private long generateSessionId() {
        return LockedRandomizer.nextLong();
    }

    private long generateSessionVersion() {
        return UnixTimestamp.getUtcNow();
    }

    public String getAddressType() {
        return this._addressType;
    }

    public String getNetworkType() {
        return this._networkType;
    }

    public long getSessionId() {
        return this._sessionId;
    }

    public long getSessionVersion() {
        return this._sessionVersion;
    }

    public String getUnicastAddress() {
        return this._unicastAddress;
    }

    public String getUsername() {
        return this._username;
    }

    public Origin(String unicastAddress, String username) {
        if (unicastAddress == null) {
            throw new RuntimeException(new Exception("unicastAddress cannot be null."));
        }
        this.setUsername(username);
        this.setSessionId(this.generateSessionId());
        this.setSessionVersion(this.generateSessionVersion());
        this.setNetworkType(NetworkType.getInternet());
        this.setAddressType(AddressType.getAddressTypeForAddress(unicastAddress));
        this.setUnicastAddress(unicastAddress);
    }

    public Origin(String unicastAddress) {
        this(unicastAddress, "-");
    }

    public static Origin parse(String s) {
        String[] strArray = StringExtensions.split(s, new char[]{' '});
        String username = strArray[0];
        String unicastAddress = strArray[5];
        Origin origin = new Origin(unicastAddress, username);
        origin.setSessionId(ParseAssistant.parseLongValue(strArray[1]));
        origin.setSessionVersion(ParseAssistant.parseLongValue(strArray[2]));
        origin.setNetworkType(strArray[3]);
        origin.setAddressType(strArray[4]);
        return origin;
    }

    public void setAddressType(String value) {
        this._addressType = value;
    }

    public void setNetworkType(String value) {
        this._networkType = value;
    }

    public void setSessionId(long value) {
        this._sessionId = value;
    }

    public void setSessionVersion(long value) {
        this._sessionVersion = value;
    }

    public void setUnicastAddress(String value) {
        this._unicastAddress = value;
    }

    public void setUsername(String value) {
        this._username = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, this.getUsername());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, LongExtensions.toString(this.getSessionId()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, LongExtensions.toString(this.getSessionVersion()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getNetworkType());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getAddressType());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getUnicastAddress());
        return builder.toString();
    }
}

