/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.matroska.Cluster;
import fm.icelink.matroska.Ebml;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.Segment;
import fm.icelink.matroska.SegmentInfo;
import fm.icelink.matroska.SimpleBlock;
import fm.icelink.matroska.SimpleBlockFlags;
import fm.icelink.matroska.Track;
import fm.icelink.matroska.TrackEntry;
import fm.icelink.matroska.TrackType;
import fm.icelink.vp8.Utility;
import java.util.ArrayList;

public class VideoRecorder
extends fm.icelink.VideoRecorder {
    private VideoFormat __inputFormat;
    private boolean __isH264;
    private boolean __isVp8;
    private boolean __isVp9;
    private int _clusterInterval = 30000;
    private Cluster _currentCluster;
    private ArrayList<SimpleBlock> _currentClusterBlocks;
    private int _frameCount;
    private volatile boolean _keyFrameWritten;
    private int _segmentSize;
    private int _segmentSizeOffset;

    @Override
    protected void doUpdateHeader() {
        this.flushCluster();
        byte[] data = Element.serializeVariableInteger(this._segmentSize, 8);
        super.getFile().writeTo(this._segmentSizeOffset, data, 0, ArrayExtensions.getLength(data));
    }

    @Override
    protected boolean doWrite(VideoBuffer buffer, long presentationTimestamp) {
        DataBuffer dataBuffer = buffer.getDataBuffer();
        if (!this._keyFrameWritten) {
            if (this.__isVp8) {
                if (!Utility.isKeyFrame(dataBuffer)) {
                    return false;
                }
                this._keyFrameWritten = true;
            } else if (this.__isVp9) {
                if (!fm.icelink.vp9.Utility.isKeyFrame(dataBuffer)) {
                    return false;
                }
                this._keyFrameWritten = true;
            } else if (this.__isH264) {
                if (!fm.icelink.h264.Utility.isKeyFrame(dataBuffer)) {
                    return false;
                }
                this._keyFrameWritten = true;
            }
        }
        this.writeFrame(dataBuffer, presentationTimestamp);
        ++this._frameCount;
        return true;
    }

    @Override
    protected void doWriteHeader() {
        Ebml ebml2 = new Ebml();
        ebml2.setWriteDefaultValues(true);
        ebml2.setDocTypeVersion(4L);
        ebml2.setDocTypeReadVersion(2L);
        byte[] bytes = ebml2.getBytes();
        super.getFileStream().write(bytes, 0, ArrayExtensions.getLength(bytes));
        String str = "";
        if (this.__isVp8) {
            str = TrackEntry.getVp8CodecId();
        } else if (this.__isVp9) {
            str = TrackEntry.getVp9CodecId();
        } else if (this.__isH264) {
            str = TrackEntry.getH264CodecId();
        }
        TrackEntry entry2 = new TrackEntry();
        entry2.setTrackNumber(1L);
        entry2.setTrackType(TrackType.getVideo());
        entry2.setCodecId(str);
        entry2.setFlagLacing(false);
        TrackEntry entry = entry2;
        Track track2 = new Track();
        track2.setTrackEntries(new TrackEntry[]{entry});
        Track track = track2;
        Segment segment2 = new Segment();
        segment2.setSizeLength(8);
        segment2.setSegmentInfo(new SegmentInfo());
        segment2.setTracks(new Track[]{track});
        Segment segment = segment2;
        byte[] buffer2 = segment.getBytes();
        super.getFileStream().write(buffer2, 0, ArrayExtensions.getLength(buffer2));
        this._segmentSize = segment.getSize();
        this._segmentSizeOffset = ArrayExtensions.getLength(bytes) + ArrayExtensions.getLength(segment.getId());
        Cluster cluster = new Cluster();
        cluster.setTimecode(0L);
        this._currentCluster = cluster;
        this._currentClusterBlocks = new ArrayList();
    }

    private void flushCluster() {
        if (ArrayListExtensions.getCount(this._currentClusterBlocks) > 0) {
            this._currentCluster.setSimpleBlocks(this._currentClusterBlocks.toArray(new SimpleBlock[0]));
            this._currentClusterBlocks.clear();
            byte[] bytes = this._currentCluster.getBytes();
            super.getFile().write(bytes, 0, ArrayExtensions.getLength(bytes));
            this._segmentSize += ArrayExtensions.getLength(bytes);
        }
    }

    public VideoRecorder(String path, VideoFormat inputFormat) {
        super(path);
        if (Global.equals(inputFormat.getName(), VideoFormat.getVp8Name())) {
            this.__isVp8 = true;
        } else if (Global.equals(inputFormat.getName(), VideoFormat.getVp9Name())) {
            this.__isVp9 = true;
        } else {
            if (!Global.equals(inputFormat.getName(), VideoFormat.getH264Name())) {
                throw new RuntimeException(new Exception(StringExtensions.concat("Matroska video recorder does not currently support the '", inputFormat.getName(), "' codec.")));
            }
            this.__isH264 = true;
        }
        this.__inputFormat = inputFormat;
    }

    private void writeFrame(DataBuffer encodedFrame, long presentationTimestamp) {
        long num = presentationTimestamp * 1000L / (long)this.__inputFormat.getClockRate();
        if (num - this._currentCluster.getTimecode() > (long)this._clusterInterval) {
            this.flushCluster();
            Cluster cluster = new Cluster();
            cluster.setTimecode(num);
            this._currentCluster = cluster;
        }
        byte keyframe = 0;
        if (this.__isVp8 && Utility.isKeyFrame(encodedFrame) || this.__isH264 && fm.icelink.h264.Utility.isKeyFrame(encodedFrame) || this.__isVp9 && fm.icelink.vp9.Utility.isKeyFrame(encodedFrame)) {
            keyframe = SimpleBlockFlags.getKeyframe();
        }
        SimpleBlock item = new SimpleBlock();
        item.setFlags(keyframe);
        item.setTimecode((int)(num - this._currentCluster.getTimecode()));
        item.setTrackNumber(1L);
        item.setData(encodedFrame.toArray());
        this._currentClusterBlocks.add(item);
    }
}

